/***************************************************************************
    smb4kshellio  -  This class takes care of all shell IO operations,
    that are not connected to mounting and unmounting of shares or
    network operations.
                             -------------------
    begin                : Sa Mai 29 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qstringlist.h>

// KDE includes
#include <kprocess.h>

// application specific includes
#include "smb4kshellio.h"


Smb4KShellIO::Smb4KShellIO( QObject *parent, const char *name ) : QObject( parent, name )
{
  m_timer = new QTimer( this );
  m_timer->start( 50, false );

  m_queue.setAutoDelete( true );

  m_proc = new KProcess( this );
  m_proc->setUseShell( true );

  connect( m_timer,  SIGNAL( timeout() ),                                 this, SLOT( slotProcess() ) );
  connect( m_proc,   SIGNAL( processExited( KProcess * ) ),               this, SLOT( slotProcessExited( KProcess* ) ) );
  connect( m_proc,   SIGNAL( receivedStdout( KProcess *, char *, int ) ), this, SLOT( slotReceivedStdout( KProcess *, char *, int ) ) );
  connect( m_proc,   SIGNAL( receivedStderr( KProcess *, char *, int ) ), this, SLOT( slotReceivedStderr( KProcess *, char *, int ) ) );
}


Smb4KShellIO::~Smb4KShellIO()
{
  delete m_queue;
}


/****************************************************************************
   Gets the version of Samba.
****************************************************************************/

void Smb4KShellIO::getSambaVersion()
{
  m_queue.enqueue( new QString( QString( "%1:" ).arg( Samba )+"smbclient --version" ) );
}


/****************************************************************************
   Processes Samba's version.
****************************************************************************/

void Smb4KShellIO::processSambaVersion()
{
  QString ver = m_buffer.section( "Version", 1, -1 ).stripWhiteSpace();
  emit sambaVersion( ver );
}


/////////////////////////////////////////////////////////////////////////////
//   SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KShellIO::slotProcess()
{
  if ( !m_queue.isEmpty() && !m_proc->isRunning() )
  {
    QString *entry = m_queue.dequeue();

    m_state = entry->section( ":", 0, 0 ).toInt();
    QString command = entry->section( ":", 1, 1 );

    delete entry;

    *m_proc << command;

    m_proc->start( KProcess::NotifyOnExit, KProcess::Stdout );
  }
}


void Smb4KShellIO::slotReceivedStdout( KProcess *, char *buf, int len )
{
  m_buffer.append( QString::fromLocal8Bit( buf, len ) );
}


void Smb4KShellIO::slotReceivedStderr( KProcess *, char *buf, int len )
{
  m_buffer.append( QString::fromLocal8Bit( buf, len ) );
}


void Smb4KShellIO::slotProcessExited( KProcess * )
{
  switch ( m_state )
  {
    case Samba:
      processSambaVersion();
      break;
    default:
      break;
  }

  m_proc->clearArguments();
  m_buffer = QString::null;
  m_state = Idle;
}

#include "smb4kshellio.moc"
