/***************************************************************************
    smb4ksystemtray.cpp - The widget that handles the docking
              to the system tray.
                             -------------------
    begin                : Mon Jan 12 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2004 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qiconset.h>
#include <qvaluelist.h>
#include <qtooltip.h>

// KDE includes
#include <kpopupmenu.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kaction.h>

// application specific includes
#include "smb4ksystemtray.h"
#include "widgets/smb4kbookmarkmenuwidget.h"
#include "widgets/smb4ksharesmenuwidget.h"
#include "core/smb4kshare.h"
#include "core/smb4kcore.h"
#include "smb4k.h"

Smb4KSystemTray::Smb4KSystemTray( bool dock_now, QWidget *parent, const char *name )
: KSystemTray( parent, name ), m_docked( false )
{
  setPixmap( loadIcon( "smb4k" ) );
  setupContextMenu();

  QToolTip::add( this, ((Smb4KApp *)parentWidget())->caption() );

  if ( dock_now )
  {
    dock();
  }

  connect( this, SIGNAL( quitSelected() ), parent, SLOT( slotQuit() ) );
}


Smb4KSystemTray::~Smb4KSystemTray()
{
}


void Smb4KSystemTray::setupContextMenu()
{
  Smb4KSharesMenuWidget *shares = new Smb4KSharesMenuWidget( this, "SystemTrayShares" );
  contextMenu()->insertItem( QIconSet( SmallIcon( "hdd_unmount" ), QIconSet::Automatic ), i18n( "Mounted &Shares" ), shares->popupMenu() );

  Smb4KBookmarkMenuWidget *bookmarks = new Smb4KBookmarkMenuWidget( this, "SystemTrayBookmarks" );
  contextMenu()->insertItem( QIconSet( SmallIcon( "folder" ), QIconSet::Automatic ), i18n( "Bookmarks" ), bookmarks->popupMenu() );

  ((Smb4KApp *)parentWidget())->actionCollection()->action( "shares_manual_mount" )->plug( contextMenu() );
  contextMenu()->insertSeparator();
  ((Smb4KApp *)parentWidget())->actionCollection()->action( "configure_smb4k" )->plug( contextMenu() );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSystemTray::dock()
{
  if ( !m_docked )
  {
    m_docked = true;
    this->show();
  }
}


void Smb4KSystemTray::undock()
{
  if ( m_docked )
  {
    m_docked = false;
    this->hide();
  }
}

#include "smb4ksystemtray.moc"
