/***************************************************************************
    smb4kbookmarkmenuwidget.h  - A bookmark popup menu.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2004 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SMB4KBOOKMARKMENUWIDGET_H
#define SMB4KBOOKMARKMENUWIDGET_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kactionclasses.h>
#include <kactioncollection.h>

class Smb4KBookmarkMenuWidget : public KActionMenu
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KBookmarkMenuWidget( QObject *parent= 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KBookmarkMenuWidget();
    /**
     * This function returns a pointer to the action collection of this class.
     * You should use it to include the action into the action collection of the
     * main action collection (e.g. KMainWindow::actionCollection()).
     *
     * The entries in this action collection are only bookmarks and are members
     * of the group "Bookmarks" (the bookmarks) and "BookmarkAction" (action to edit
     * the bookmarks, etc.).
     *
     * @returns             a pointer to the action collection of this class
     */
    KActionCollection *action_collection() { return m_collection; }

  protected slots:
    /**
     * This slot is activated when the list of shares has been updated.
     * It reads that list and enables/disables the bookmarks accordingly.
     */
    void slotUpdatedShareList();
    /**
     * This slot is activated if an item in the menu has been activated.
     */
    void slotActivated();
    /**
     * This slot is activated if the list of bookmarks has been updated.
     */
    void slotBookmarksUpdated();
    /**
     * This slot is activated if the user wants to edit the bookmarks.
     */
    void slotEditBookmarks();
    /**
     * This slot is activated whenever an action is highlighted.
     *
     * @param action        the action that is highlighted
     */
    void slotActionHighlighted( KAction *action );

  private:
    /**
     * Inserts the bookmarks.
     */
    void insertBookmarks();
    /**
     * This function initializes the actions that are _not_ bookmarks.
     */
    void initActions();
    /**
     * This is the action collection of this class.
     */
    KActionCollection *m_collection;
    /**
     * The currently highlighted KAction.
     */
    KAction *m_action;
};

#endif
