/***************************************************************************
                          smb4kbrowserwidgetitem  -  description
                             -------------------
    begin                : So Jan 30 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qpainter.h>

// KDE includes
#include <kiconloader.h>

// application specific includes
#include "smb4kbrowserwidgetitem.h"

Smb4KBrowserWidgetItem::Smb4KBrowserWidgetItem( QListView *parent, Smb4KWorkgroupItem *item )
: QListViewItem( parent, item->workgroup() ), m_workgroup( m_workgroup ), m_host( NULL ), m_share( NULL ), m_mounted( false )
{
  setPixmap( 0, SmallIcon( "network_local" ) );
}


Smb4KBrowserWidgetItem::Smb4KBrowserWidgetItem( QListViewItem *parent, Smb4KHostItem *item )
: QListViewItem( parent, item->name(), QString::null, item->ip(), item->comment() ), m_workgroup( NULL ), m_host( item ), m_share( NULL ), m_mounted( false )
{
  setPixmap( 0, SmallIcon( "server" ) );
}


Smb4KBrowserWidgetItem::Smb4KBrowserWidgetItem( QListViewItem *parent, Smb4KShareItem *item )
: QListViewItem( parent, item->name(), item->type(), QString::null, item->comment() ), m_workgroup( NULL ), m_host( NULL ), m_share( item ), m_mounted( false )
{
  if ( item->type().contains( "Printer" ) )
  {
    setPixmap( 0, SmallIcon( "printer1" ) );
  }
  else
  {
    setPixmap( 0, SmallIcon( "folder" ) );
  }
}


Smb4KBrowserWidgetItem::~Smb4KBrowserWidgetItem()
{
}


void Smb4KBrowserWidgetItem::setMounted( bool mounted )
{
  if ( depth() == 2 && QString::compare( text( 1 ), "Disk" ) == 0 )
  {
    m_mounted = mounted;

    if ( mounted )
    {
      setPixmap( 0, SmallIcon( "folder_open" ) );
    }
    else
    {
      setPixmap( 0, SmallIcon( "folder" ) );
    }
  }
}


void Smb4KBrowserWidgetItem::paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int align )
{
  QFont f( p->font() );

  if ( m_mounted )
  {
    f.setItalic( true );
  }
  else
  {
    f.setItalic( false );
  }

  p->setFont( f );

  QListViewItem::paintCell( p, cg, column, width, align );
}
