/***************************************************************************
    smb4knetworkoptions  -  description
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// application specific includes
#include "smb4knetworkoptions.h"

// Qt includes
#include <qbuttongroup.h>
#include <qvgroupbox.h>
#include <qlayout.h>

// KDE includes
#include <klocale.h>

Smb4KNetworkOptions::Smb4KNetworkOptions( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  QGridLayout *grid = new QGridLayout( this );
  grid->setSpacing( 10 );

  //
  // The browse list group box.
  //
  QButtonGroup *browsebox = new QButtonGroup( 1, Qt::Horizontal, i18n( "Browse List" ), this );

  m_useNMB = new QRadioButton( i18n( "Scan the network to retrieve the browse list" ), browsebox );
  m_useNMB->setGeometry( QRect( 0, 0, m_useNMB->sizeHint().width(), m_useNMB->sizeHint().height() ) );

  m_useHost = new QRadioButton( i18n( "Query a master browser to retrieve the browse list" ), browsebox );
  m_useHost->setGeometry( QRect( 0, m_useNMB->frameGeometry().bottom()+5, m_useHost->sizeHint().width(), m_useHost->sizeHint().height() ) );

  QWidget *nameWidget = new QWidget( browsebox );
  QGridLayout *nameLayout = new QGridLayout( nameWidget );
  QSpacerItem *spacer1 = new QSpacerItem( 25, 0, QSizePolicy::Fixed, QSizePolicy::Minimum );

  m_hostLabel = new QLabel( nameWidget );
  m_hostLabel->setText( i18n( "NetBIOS name/IP address:" ) );

  m_hostName = new KLineEdit( nameWidget );
  m_hostName->setFixedWidth( 150 );

  m_hostNeedsAuth = new QCheckBox( i18n( "This master browser needs authentication" ), nameWidget );

  QSpacerItem *spacer2 = new QSpacerItem( 10, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );

  nameLayout->setSpacing( 5 );
  nameLayout->addMultiCell( spacer1, 0, 1, 0, 0 );
  nameLayout->addWidget( m_hostLabel, 0, 1, 0 );
  nameLayout->addWidget( m_hostName, 0, 2, 0 );
  nameLayout->addItem( spacer2, 0, 3 );
  nameLayout->addMultiCellWidget( m_hostNeedsAuth, 1, 1, 1, 3, 0 );

  m_mastersAuth = new QCheckBox( i18n( "Use authentication when querying the workgroup master browsers" ), browsebox );

  QWidget *winsWidget = new QWidget( browsebox );
  QGridLayout *winsLayout = new QGridLayout( winsWidget );

  QLabel *winsLabel = new QLabel( i18n( "WINS server used by the system:" ), winsWidget );
  m_winsYesNo = new QLabel( i18n( "None" ), winsWidget );

  QSpacerItem *spacer3 = new QSpacerItem( 0, 10, QSizePolicy::Minimum, QSizePolicy::Fixed );
  QSpacerItem *spacer4 = new QSpacerItem( 10, 0, QSizePolicy::Expanding, QSizePolicy::Minimum );
  winsLayout->setSpacing( 10 );
  winsLayout->addItem( spacer3, 0, 0 );
  winsLayout->addWidget( winsLabel, 1, 0, 0 );
  winsLayout->addWidget( m_winsYesNo, 1, 1, 0 );
  winsLayout->addItem( spacer4, 1, 2 );

  //
  // The search group box
  //
  QButtonGroup *searchbox = new QButtonGroup( 1, Qt::Horizontal, i18n( "Network Search" ), this );
  QLabel *description = new QLabel( searchbox );
  description->setText( i18n( "Smb4K uses <i>nmblookup</i> by default to do network searches. This method is very reliable but fails sometimes if your network neighborhood is configured uncommonly. In this case you should try to use <i>smbclient</i>." ) );
  description->setTextFormat( Qt::RichText );

  m_nmbSearch = new QRadioButton( i18n( "Use nmblookup (recommended)" ), searchbox );
  m_clientSearch = new QRadioButton( i18n( "Use smbclient" ), searchbox );
  
  QSpacerItem *spacer5 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addWidget( browsebox, 0, 0, 0 );
  grid->addWidget( searchbox, 1, 0, 0 );
  grid->addItem( spacer5, 2, 0 );
}


Smb4KNetworkOptions::~Smb4KNetworkOptions()
{
}

#include "smb4knetworkoptions.moc"
