/***************************************************************************
    smb4knetworktab.cpp  -  Displays information about a selected
    network item.
                             -------------------
    begin                : Sam Mr 15 2003
    copyright            : (C) 2003 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qapplication.h>
#include <qvaluelist.h>

// KDE includes
#include <kiconloader.h>
#include <klocale.h>

// application specific includes
#include "smb4knetworktab.h"
#include "../core/smb4kscanner.h"
#include "../core/smb4knetworkitems.h"
#include "../core/smb4kcore.h"
#include "../smb4k.h"

Smb4KNetworkTab::Smb4KNetworkTab( QWidget *parent, const char *name ) : QWidget( parent, name )
{
  m_current = NULL;

  QGridLayout *grid = new QGridLayout( this );
  grid->setMargin( 30 );

  QLabel *picLabel = new QLabel( this );
  picLabel->setPixmap( DesktopIcon( "network", 32 ) );
  picLabel->setFixedWidth( 64 );
  picLabel->setMargin( 5 );

  QLabel *topLabel = new QLabel( i18n( "<font size=+2><b>Network</b></font>" ), this );

  QFrame *line = new QFrame( this );
  line->setFrameShadow( QFrame::Sunken );
  line->setFrameShape( QFrame::HLine );

  QSpacerItem *spacer1 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );
  
  m_workgroupLabel = new QLabel( QString::null, this );
  m_workgroup = new KSqueezedTextLabel( QString::null, this );

  m_masterLabel = new QLabel( QString::null, this );
  m_master = new KSqueezedTextLabel( QString::null, this );

  QSpacerItem *spacer2 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );

  m_hostLabel = new QLabel( QString::null, this );
  m_host = new KSqueezedTextLabel( QString::null, this );

  m_ipLabel = new QLabel( QString::null, this );
  m_ip = new KSqueezedTextLabel( QString::null, this );

  m_osLabel = new QLabel( QString::null, this );
  m_os = new KSqueezedTextLabel( QString::null, this );

  m_serverLabel = new QLabel( QString::null, this );
  m_server = new KSqueezedTextLabel( QString::null, this );

  QSpacerItem *spacer3 = new QSpacerItem( 10, 20, QSizePolicy::Preferred, QSizePolicy::Preferred );

  m_shareLabel = new QLabel( QString::null, this );
  m_share = new KSqueezedTextLabel( QString::null, this );

  m_typeLabel = new QLabel( QString::null, this );
  m_type = new KSqueezedTextLabel( QString::null, this );

  QSpacerItem *spacer4 = new QSpacerItem( 10, 10, QSizePolicy::Expanding, QSizePolicy::Expanding );
  
  grid->addMultiCellWidget( picLabel, 0, 1, 0, 0, 0 );
  grid->addMultiCellWidget( topLabel, 0, 1, 1, 4, 0 );
  grid->addMultiCellWidget( line, 2, 2, 0, 4, 0 );
  grid->addMultiCell( spacer1, 3, 3, 0, 4, 0 );
  grid->addWidget( m_workgroupLabel, 4, 1, 0 );
  grid->addMultiCellWidget( m_workgroup, 4, 4, 2, 4, 0 );
  grid->addWidget( m_masterLabel, 5, 1, 0 );
  grid->addMultiCellWidget( m_master, 5, 5, 2, 4, 0 );
  grid->addMultiCell( spacer2, 6, 6, 0, 4, 0 );
  grid->addWidget( m_hostLabel, 7, 1, 0 );
  grid->addMultiCellWidget( m_host, 7, 7, 2, 4, 0 );
  grid->addWidget( m_ipLabel, 8, 1, 0 );
  grid->addMultiCellWidget( m_ip, 8, 8, 2, 4, 0 );
  grid->addWidget( m_osLabel, 9, 1, 0 );
  grid->addMultiCellWidget( m_os, 9, 9, 2, 4, 0 );
  grid->addWidget( m_serverLabel, 10, 1, 0 );
  grid->addMultiCellWidget( m_server, 10, 10, 2, 4, 0 );
  grid->addMultiCell( spacer3, 11, 11, 0, 4, 0 );
  grid->addWidget( m_shareLabel, 12, 1, 0 );
  grid->addMultiCellWidget( m_share, 12, 12, 2, 4, 0 );
  grid->addWidget( m_typeLabel, 13, 1, 0 );
  grid->addMultiCellWidget( m_type, 13, 13, 2, 4, 0 );
  grid->addMultiCell( spacer4, 14, 14, 0, 4, 0 );

  // Connections:
  connect( smb4k_core->scanner(),  SIGNAL( killed() ),       
           this,                   SLOT( slotKilled() ) );
  connect( smb4k_core->scanner(),  SIGNAL( info( Smb4KHostItem * ) ),
           this,                   SLOT( slotInfo( Smb4KHostItem * ) ) );
  connect( smb4k_core->ipFinder(), SIGNAL( ip_address( Smb4KHostItem * ) ), 
           this,                   SLOT( slotIPAddress( Smb4KHostItem * ) ) );
}


Smb4KNetworkTab::~Smb4KNetworkTab()
{
}


void Smb4KNetworkTab::clear( int depth )
{
  if ( depth == 0 )
  {
    m_workgroup->setText( QString::null );
    m_workgroupLabel->setText( QString::null );
    m_master->setText( QString::null );
    m_masterLabel->setText( QString::null );
    m_host->setText( QString::null );
    m_hostLabel->setText( QString::null );
    m_ipLabel->setText( QString::null );
    m_ip->setText( QString::null );
    m_os->setText( QString::null );
    m_osLabel->setText( QString::null);
    m_server->setText( QString::null );
    m_serverLabel->setText( QString::null );
    m_share->setText( QString::null );
    m_shareLabel->setText( QString::null );
    m_type->setText( QString::null );
    m_typeLabel->setText( QString::null );
  }
  if ( depth == 1 )
  {
    m_host->setText( QString::null );
    m_ip->setText( QString::null );
    m_share->setText( QString::null );
    m_shareLabel->setText( QString::null );
    m_type->setText( QString::null );
    m_typeLabel->setText( QString::null );
  }
  if ( depth == 2 )
  {
    m_share->setText( QString::null );
    m_type->setText( QString::null );
  }
}

void Smb4KNetworkTab::display( QListViewItem *item )
{
  if ( item )
  {
    // Copy the old item. We need it later on to check whether the
    // wantMoreInfo() signal has to be emitted or not.
    QListViewItem *oldItem = m_current;
        
    // Now build up the display.
    m_current = item;
    clear( m_current->depth() );

    if ( m_current->depth() == 0 )
    {
      m_workgroupLabel->setText( i18n( "Workgroup:" ) );
      m_workgroup->setText( m_current->text( Network ) );

      Smb4KWorkgroupItem *i = smb4k_core->scanner()->getWorkgroup( m_current->text( Network ) );
      
      if ( !i->pseudo() )
      {
        m_masterLabel->setText( i18n( "Master:" ) );
        m_master->setText( i->master() );
      }
      else
      {
        m_masterLabel->setText( i18n( "Pseudo-Master:" ) );
        m_master->setText( i->master() );
      }
    }
    else if ( m_current->depth() == 1 )
    {
      bool search = false;
      
      if ( oldItem->depth() == 0 )
      {
        search = true;
        smb4k_core->scanner()->getInfo( m_current->parent()->text( Network ), m_current->text( Network ), m_current->text( IP ) );
      }
      else if ( (oldItem->depth() == 1 && 
                 QString::compare( oldItem->text( Network ), m_current->text( Network ) ) != 0) ||
                m_hostLabel->text().isEmpty() )
      {
        search = true;
        smb4k_core->scanner()->getInfo( m_current->parent()->text( Network ), m_current->text( Network ), m_current->text( IP ) );
      }
      else if ( (oldItem->depth() == 2  && 
                 QString::compare( oldItem->parent()->text( Network ), m_current->text( Network ) ) != 0) ||
                m_hostLabel->text().isEmpty() )
      {
        search = true;
        smb4k_core->scanner()->getInfo( m_current->parent()->text( Network ), m_current->text( Network ), m_current->text( IP ) );
      }

      m_workgroupLabel->setText( i18n( "Workgroup:" ) );

      m_workgroup->setText( m_current->parent()->text( Network ) );
      
      Smb4KWorkgroupItem *i = smb4k_core->scanner()->getWorkgroup( m_current->parent()->text( Network ) );
      
      if ( !i->pseudo() )
      {
        m_masterLabel->setText( i18n( "Master:" ) );
        m_master->setText( i->master() );
      }
      else
      {
        m_masterLabel->setText( i18n( "Pseudo-Master:" ) );
        m_master->setText( i->master() );
      }

      QString host( m_current->text( Network ) );

      if ( !m_current->text( Comment ).isEmpty() )
        host.append( "   (" ).append( m_current->text( Comment ) ).append( ")" );

      m_hostLabel->setText( i18n( "Host:" ) );
      m_ipLabel->setText( i18n( "IP Address:" ) );
      m_osLabel->setText( i18n( "OS:" ) );
      m_serverLabel->setText( i18n( "Server:" ) );
      m_host->setText( host );

      if ( !m_current->text( IP ).stripWhiteSpace().isEmpty() )
        m_ip->setText( m_current->text( IP ) );
      else
        m_ip->setText( i18n( "Unknown" ) );

      if ( search )
      {
        m_os->setText( i18n( "Searching..." ) );
        m_server->setText( i18n( "Searching..." ) );
      }
    }
    else if ( m_current->depth() == 2 )
    {
      bool search = false;
      if ( oldItem->depth() == 0 )
      {
        search = true;
        smb4k_core->scanner()->getInfo( m_current->parent()->parent()->text( Network ), m_current->parent()->text( Network ), m_current->parent()->text( IP ) );
      }
      else if ( (oldItem->depth() == 1 && 
                 QString::compare( oldItem->text( Network ), m_current->parent()->text( Network ) ) != 0) ||
                m_hostLabel->text().isEmpty() )
      {
        search = true;
        smb4k_core->scanner()->getInfo( m_current->parent()->parent()->text( Network ), m_current->parent()->text( Network ), m_current->parent()->text( IP ) );
      }
      else if ( (oldItem->depth() == 2 && 
                 QString::compare( oldItem->parent()->text( Network ), m_current->parent()->text( Network ) ) != 0) || 
                m_hostLabel->text().isEmpty() )
      {
        search = true;
        smb4k_core->scanner()->getInfo( m_current->parent()->parent()->text( Network ), m_current->parent()->text( Network ), m_current->parent()->text( IP ) );
      }

      m_workgroupLabel->setText( i18n( "Workgroup:" ) );

      m_workgroup->setText( m_current->parent()->parent()->text( Network ) );

      Smb4KWorkgroupItem *i = smb4k_core->scanner()->getWorkgroup( m_current->parent()->parent()->text( Network ) );
      
      if ( !i->pseudo() )
      {
        m_masterLabel->setText( i18n( "Master:" ) );
        m_master->setText( i->master() );
      }
      else
      {
        m_masterLabel->setText( i18n( "Pseudo-Master:" ) );
        m_master->setText( i->master() );
      }      

      m_hostLabel->setText( i18n( "Host:" ) );
      m_ipLabel->setText( i18n( "IP Address:" ) );
      m_osLabel->setText( i18n( "OS:" ) );
      m_serverLabel->setText( i18n( "Server:" ) );

      QString host( m_current->parent()->text( Network ) );

      QString ip;
      if ( !m_current->parent()->text( IP ).stripWhiteSpace().isEmpty() )
        ip = m_current->parent()->text( IP );
      else
        ip = i18n( "Unknown" );

      if ( !m_current->parent()->text( Comment ).isEmpty() )
        host.append( "   (" ).append( m_current->parent()->text( Comment ) ).append( ")" );

      QString share( m_current->text( Network ) );

      if ( !m_current->text( Comment ).isEmpty() )
        share.append( "   (" ).append( m_current->text( Comment ) ).append( ")" );

      if ( m_host->text().contains( host ) == 0 )
      {
        m_host->setText( host );
        m_ip->setText( ip );
        if ( search )
        {
          m_os->setText( i18n( "Searching..." ) );
          m_server->setText( i18n( "Searching..." ) );
        }
      }
      m_shareLabel->setText( i18n( "Share:" ) );
      m_share->setText( share );
      m_typeLabel->setText( i18n( "Type:" ) );
      m_type->setText( m_current->text( Type ) );
    }
  }
  else
    clear( 0 );
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KNetworkTab::slotInfo( Smb4KHostItem *host )
{
  QString newOS;
  QString newServer;
  
  if ( host->osString().contains( "Unix" ) != 0 )
  {
    newOS = QString( "Linux/" ).append( host->osString() );
  }
  else if ( host->osString().isEmpty() )
  {
    newOS = i18n( "Unknown" );
  }
  else
  {
    newOS = host->osString();
  }
  
  if ( host->serverString().isEmpty() )
  {
    newServer = i18n( "Unknown" );
  }
  else
  {
    newServer = host->serverString();
  }

  // Now display everything:
  if ( m_current->depth() == 1 )
  {
    m_os->setText( newOS );
    m_server->setText( newServer );
  }
  else if ( m_current->depth() == 2 )
  {
    m_os->setText( newOS );
    m_server->setText( newServer );
  }
}


void Smb4KNetworkTab::slotKilled()
{
  if ( m_current != 0 && m_current->depth() >= 1 )
  {
    m_os->setText( i18n( "Unknown" ) );
    m_server->setText( i18n( "Unknown" ) );
  }
}


void Smb4KNetworkTab::slotIPAddress( Smb4KHostItem *item )
{
  QString host;
  
  if ( m_host->text().contains( "(" ) != 0 )
  {
    host = m_host->text().section( "(", 0, 0 ).stripWhiteSpace();
  }
  else
  {
    host = m_host->text().stripWhiteSpace();
  }
  
  if ( QString::compare( item->name(), host ) == 0 && 
       QString::compare( item->workgroup(), m_workgroup->text().stripWhiteSpace() ) == 0 &&
       !item->ip().stripWhiteSpace().isEmpty() &&
       QString::compare( m_ip->text().stripWhiteSpace(), i18n( "Unknown" ) ) == 0 )
  {
    m_ip->setText( item->ip() );
  }
}


void Smb4KNetworkTab::slotGetListViewItem( QListViewItem *item )
{
  display( item );
}


void Smb4KNetworkTab::slotClearWidget()
{
  clear( 0 );
}


#include "smb4knetworktab.moc"
