/***************************************************************************
                          smb4kprintdialog  -  description
                             -------------------
    begin                : So Apr 11 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qlabel.h>
#include <qlayout.h>
#include <qgroupbox.h>
 
// KDE includes
#include <klocale.h>
#include <kmessagebox.h>
 
// application specific includes
#include "smb4kprintdialog.h"
#include "../smb4k.h"
#include "../core/smb4kprintinfo.h"
#include "../core/smb4kcore.h"

Smb4KPrintDialog::Smb4KPrintDialog( const QString &workgroup, const QString &host, const QString &ip, const QString &printer, const QString &comment, QWidget *parent, const char *name ) 
: KDialogBase( Plain, i18n( "Print File" ), Ok|Cancel, Ok, parent, name, false, true ), m_workgroup( workgroup ), m_host( host ), m_ip( ip ), m_printer( printer )
{
  QFrame *frame = plainPage();
  
  QGridLayout *grid = new QGridLayout( frame );
  grid->setSpacing( 10 );
  
  QGroupBox *p = new QGroupBox( 1, Qt::Horizontal, i18n( "Printer" ), frame );
    
  QWidget *p_w = new QWidget( p );
  QGridLayout *p_grid = new QGridLayout( p_w );
  p_grid->setSpacing( 10 );
    
  QLabel *printerLabel = new QLabel( i18n( "Printer:" ), p_w );
  QLabel *printerName = new QLabel( printer+"   ("+comment+")", p_w );
  p_grid->addWidget( printerLabel, 0, 0, 0 );
  p_grid->addWidget( printerName, 0, 1, 0 );
    
  QLabel *locLabel = new QLabel( i18n( "Location:" ), p_w );
  QLabel *loc = new QLabel( "//"+host+"/"+printer, p_w );
  p_grid->addWidget( locLabel, 1, 0, 0 );
  p_grid->addWidget( loc, 1, 1, 0 );
    
  QLabel *ipLabel = new QLabel( i18n( "IP Address:" ), p_w );
  QLabel *ipAddress = new QLabel( p_w );
  if ( ip.stripWhiteSpace().isEmpty() )
    ipAddress->setText( i18n( "Unknown" ) );
  else
    ipAddress->setText( ip );    
  p_grid->addWidget( ipLabel, 2, 0, 0 );
  p_grid->addWidget( ipAddress, 2, 1, 0 );
    
  QLabel *wgLabel = new QLabel( i18n( "Workgroup:" ), p_w );
  QLabel *wg = new QLabel( workgroup, p_w );
  p_grid->addWidget( wgLabel, 3, 0, 0 );
  p_grid->addWidget( wg, 3, 1, 0 );
  
  QSpacerItem *spacer = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Preferred );
  p_grid->addMultiCell( spacer, 0, 1, 2, 2, 0 );
    
  QGroupBox *f = new QGroupBox( 1, Qt::Horizontal, i18n( "File" ), frame );
    
  QWidget *f_w = new QWidget( f );
  QGridLayout *f_grid = new QGridLayout( f_w );
  f_grid->setSpacing( 10 );
  QLabel *f_label = new QLabel( i18n( "File:" ), f_w );
  m_input = new KURLRequester( QDir::homeDirPath()+"/print.ps", f_w );
  m_input->setMinimumWidth( 200 );
  f_grid->addWidget( f_label, 0, 0, 0 );
  f_grid->addWidget( m_input, 0, 1, 0 );
  
  QGroupBox *c = new QGroupBox( 1, Qt::Horizontal, i18n( "Copies" ), frame );
  
  QWidget *c_w = new QWidget( c );
  QGridLayout *c_grid = new QGridLayout( c_w );
  c_grid->setSpacing( 10 );
  QLabel *c_label = new QLabel( i18n( "Copies:" ), c_w );
  m_copies = new KIntNumInput( 1, c_w, 10, "PrintCopies" );
  m_copies->setMinValue( 1 );
  c_grid->addWidget( c_label, 0, 0, 0 );
  c_grid->addWidget( m_copies, 0, 1, 0 );  
    
  grid->addMultiCellWidget( p, 0, 0, 0, 1, 0 );
  grid->addWidget( f, 1, 0, 0 );
  grid->addWidget( c, 1, 1, 0 );
}


Smb4KPrintDialog::~ Smb4KPrintDialog()
{
}


/////////////////////////////////////////////////////////////////////////////
//  SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KPrintDialog::slotOk()
{
  if ( !m_input->url().stripWhiteSpace().isEmpty() )
  {    
    if ( smb4k_core->print()->init( new Smb4KPrintInfo( m_workgroup, m_host, m_ip, m_printer, m_input->url().stripWhiteSpace(), m_copies->value() ) ) )
    {
      accept();
    }
      
//     delete info;
  }
  else
  {
    KMessageBox::error( this, i18n( "You haven't specified a file." ) );
  }
}


#include "smb4kprintdialog.moc"
