/***************************************************************************
                          smb4ksharesmenuwidget  -  description
                             -------------------
    begin                : Mi Mr 16 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// Qt includes
#include <qvaluelist.h>
#include <qobject.h>

// KDE includes
#include <kpopupmenu.h>

// application specific includes
#include "smb4ksharesmenuwidget.h"
#include "../core/smb4kshare.h"
#include "../core/smb4kcore.h"


Smb4KSharesMenuWidget::Smb4KSharesMenuWidget( QObject *parent, const char *name )
: KActionMenu( parent, name )
{
  m_collection = new KActionCollection( popupMenu(), "SharesMenu_ActionCollection", KGlobal::instance() );
  m_collection->setHighlightingEnabled( true );

  m_action = NULL;

  connect( smb4k_core->mounter(), SIGNAL( updated() ), 
           this,                  SLOT( slotUpdatedShareList() ) );
  connect( m_collection,          SIGNAL( actionHighlighted( KAction * ) ),
	         this,                  SLOT( slotActionHighlighted( KAction * ) ) );
}


Smb4KSharesMenuWidget::~Smb4KSharesMenuWidget()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSharesMenuWidget::slotUpdatedShareList()
{
  QValueList<Smb4KShare *> shares_list = smb4k_core->mounter()->getShares();
  QStringList share_names;

  if ( shares_list.count() != 0 )
  {
    for ( QValueList<Smb4KShare *>::ConstIterator it = shares_list.begin(); it != shares_list.end(); ++it )
    {
      share_names.append( (*it)->getName().stripWhiteSpace() );

      if ( !m_collection->action( (*it)->getName() ) )
      {
        KAction *share = new KAction( (*it)->getName(), 0, 0, 0, 0, m_collection,(*it)->getName() );
        share->setGroup( "MountedShares" );
        share->setIcon( (*it)->isBroken() ? "file_broken" : "hdd_mount" );
        share->setEnabled( !(*it)->isBroken() );
        connect( share, SIGNAL( activated() ), this, SLOT( slotActivated() ) );
      }
      else
      {
        continue;
      }
    }
  }

  share_names.sort();

  KActionPtrList action_list = m_collection->actions( "MountedShares" );

  if ( action_list.count() != 0 )
  {
    for ( KActionPtrList::Iterator it = action_list.begin(); it != action_list.end(); ++it )
    {
      if ( share_names.find( (*it)->text().stripWhiteSpace() ) == share_names.end() )
      {
        remove( *it );
        m_collection->remove( *it );
      }
      else
      {
        bool insert = true;

        for ( uint index = 0; index < popupMenu()->count(); index++ )
        {
          if ( QString::compare( popupMenu()->text( popupMenu()->idAt( index ) ).stripWhiteSpace(), (*it)->text().stripWhiteSpace() ) == 0 )
          {
            insert = false;
            break;
          }
          else
          {
            continue;
          }
        }

        if ( insert )
        {
          (*it)->plug( popupMenu(), share_names.findIndex( (*it)->text().stripWhiteSpace() ) );
        }
      }
    }
  }
}


void Smb4KSharesMenuWidget::slotActivated()
{
  if ( m_action && m_action->plainText().stripWhiteSpace().startsWith( "//" ) )
  {
    QString name = m_action->plainText();
    Smb4KShare *s = smb4k_core->mounter()->findShareByName( name );
    smb4k_core->open( s );
  }
}


void Smb4KSharesMenuWidget::slotActionHighlighted( KAction *action )
{
  m_action = action;
}

#include "smb4ksharesmenuwidget.moc"
