/***************************************************************************
                          smb4kprint  -  description
                             -------------------
    begin                : Tue Mar 30 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KPRINT_H
#define SMB4KPRINT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qobject.h>
#include <qstring.h>
#include <qwidget.h>

// KDE includes
#include <kprocess.h>

// application specific includes
#include "smb4kprintinfo.h"
#include "smb4kpasswordhandler.h"


/**
 * This is a core class. It provides the interface for printing documents over
 * the network neighborhood.
 *
 * You shouldn't use this class directly but access it through Smb4KCore.
 */

class Smb4KPrint : public QObject
{
  Q_OBJECT

  public:
    /**
     * The constructor.
     */
    Smb4KPrint( QObject *parent = 0, const char *name = 0 );
    /**
     * The destructor.
     */
    ~Smb4KPrint();
    /**
     * This function initializes the printer stuff. It returns TRUE
     * in case of success.
     *
     * @param info        The information needed to print a file.
     */
    bool init( Smb4KPrintInfo *info );
    /**
     * Aborts the print process.
     */
    void abort();
    /**
     * This function returns TRUE if the printer handler is running and
     * FALSE otherwise.
     *
     * @returns           TRUE is the printer handler is running and FALSE otherwise.
     */
    bool isRunning() { return m_working; }


  signals:
    /**
     * This signal emits the run state.
     *
     * @param state       The so-called run state. There are several defined
     *                    in the smb4kdefs.h header file.
     */
    void state( int state );

  protected:
    /**
     * Starts any process.
     */
    void startProcess( int state );
    /**
     * Ends any process.
     */
    void endProcess();

  protected slots:
    /**
     * This slot receives output at stdout.
     */
    void slotReceivedStdout( KProcess *, char *buf, int len );
    /**
     * This slot receives output at stderr.
     */
    void slotReceivedStderr( KProcess *, char *buf, int len );
    /**
     * This slot is called when the process exited.
     */
    void slotProcessExited( KProcess * );
    /**
     * Is called, when the printing should be retried.
     */
    void slotRetry();

  private:
    /**
     * The print info object.
     */
    Smb4KPrintInfo *m_info;
    /**
     * The KProcess object.
     */
    KProcess *m_proc;
    /**
     * The buffer.
     */
    QString m_buffer;
    /**
     * Starts the printing of text files.
     */
    void startPrinting();
    /**
     * Ends the print process.
     */
    void endPrintProcess();
    /**
     * Enumeration for processing the data.
     */
    enum State{ Idle, Print, Convert };
    /**
     * Holds the state.
     */
    int m_internal_state;
    /**
     * Ends the conversion process.
     */
    void endConversionProcess();
    /**
     * Converts DVI files to PostScript using dvips.
     */
    void convertDVIToPS();
    /**
     * Converts text file to PostScript usinf enscript.
     */
    void convertTextToPS();
    /**
     * The password handler of this class.
     */
    Smb4KPasswordHandler *m_password_handler;
    /**
     * This boolean is TREU is the printer handler is running and
     * FALSE otherwise.
     */
    bool m_working;
};

#endif
