/***************************************************************************
                          smb4knetworkitemtooltip  -  description
                             -------------------
    begin                : Di Jan 10 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KNETWORKITEMTOOLTIP_H
#define SMB4KNETWORKITEMTOOLTIP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qlabel.h>
#include <qlayout.h>
#include <qpoint.h>

// application specific includes
#include "smb4kbrowserwidgetitem.h"

/**
 * This class provides a tool tip that displays information
 * about a network item (i.e: a workgroup, a host, or a remote
 * share).
 *
 * @author Alexander Reinholdt <dustpuppy@mail.berlios.de>
 */

class Smb4KNetworkItemTooltip : public QLabel
{
  Q_OBJECT

  public:
    /**
     * This is the contructor. It takes one of the network item classes
     * and the position where to show the tooltip.
     *
     * @param item          A network item (either a Smb4KWorkgroupItem,
     *                      Smb4KHostItem, or Smb4KShareItem object)
     *
     * @param pos           The position where to show the tool tip
     */
    Smb4KNetworkItemTooltip( Smb4KBrowserWidgetItem *item, const QPoint &pos );

    /**
     * The destructor
     */
    ~Smb4KNetworkItemTooltip();

    /**
     * This enumeration tells the tool tip which kind of network item it is
     * dealing with at the moment.
     */
    enum ItemType{ Workgroup, Host, Share };

    /**
     * This function shows the tool tip.
     *
     * @param pos           The position where the tooltip should be shown.
     */
    void showTip( const QPoint &pos );

    /**
     * This function returns the Smb4KBrowserWidgetItem for which this tool
     * tip is generated.
     *
     * @returns             The item for which the tool tip is generated.
     */
    Smb4KBrowserWidgetItem *item() { return m_item; }

    /**
     * This function updates the tooltip if necessary.
     */
    bool update();

  protected:
    /**
     * Reimplemented from QLabel.
     */
    void mousePressEvent( QMouseEvent *e );

    /**
     * Reimplemented from QLabel.
     */
    void leaveEvent( QEvent *e );

  protected slots:
    /**
     * This slot hides (closes) the tool tip.
     */
    void slotHideTooltip();

  private:
    /**
     * This holds the network item for which the tool tip is generated.
     */
     // You do want to use a pointer here!
    Smb4KBrowserWidgetItem *m_item;

    /**
     * The position where to show the tool tip
     */
    QPoint m_pos;

    /**
     * The layout of the tool tip
     */
    QGridLayout *m_layout;

    /**
     * This function sets up the tool tip.
     *
     * @param item          The network item for which information should
     *                      be displayed.
     */
    void setupTooltip( Smb4KBrowserWidgetItem *item );
};

#endif
