/***************************************************************************
    smb4k_kill  -  This is the kill utility for Smb4K.
                             -------------------
    begin                : So Sep 26 2004
    copyright            : (C) 2004 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <fstream>
#include <cstring>
#include <cerrno>
#include <unistd.h>
using namespace std;

#define SMB4K_KILL_VERSION 0.5


//
// Returns the information about the program
//

void info()
{
  cout << "This is smb4k_kill (version "<< SMB4K_KILL_VERSION <<"), the kill utility of Smb4K" << endl;
  cout << "Copyright (C) 2004-2005, Alexander Reinholdt" << endl << endl;
  cout << "Usage:" << endl;
  cout << " smb4k_kill -{signum} {pid}" << endl;
  cout << " smb4k_kill --help" << endl << endl;
  cout << "Arguments:" << endl;
  cout << "  {signum}\tThis is the signal number (see the kill(1) manual page for" << endl;
  cout << "\t\tmore information)." << endl;
  cout << endl;
  cout << "  {pid}\t\tThe ID of the process you want to kill." << endl;
  cout << endl;
  cout << "  --help\tDisplays this help screen and exits." << endl;
  cout << endl;
}

//
// Finds the kill program
//

const char *findprog( const char *name )
{
  const char *paths[] = { "/bin/", "/sbin/", "/usr/bin/", "/usr/sbin/", "/usr/local/bin/", "/usr/local/sbin/" };
  string file = "";

  for ( uint i = 0; i < sizeof( paths ) / sizeof( char * ); i++ )
  {
    string path( paths[i] );
    path.append( name );

    if ( access( path.c_str(), X_OK ) == 0 )
    {
      file.assign( path );
      break;
    }
  }

  if ( !strcmp( file.c_str(), "" ) )
  {
    cerr << "smb4k_kill: Could not find " << name << "." << endl;
    exit( EXIT_FAILURE );
  }

  return file.c_str();
}

//
// The main function
//

int main( int argc, char *argv[], char *envp[] )
{
  if ( argc < 2 )
  {
    info();
    exit( EXIT_FAILURE );
  }

  char *args[25];
  int k = 0;

  char *p = new char[100];

  const char *prg = findprog( "kill" );

  args[k] = strncpy( p, prg, 99 );
  p[99] = '\0';    // Do this for security reasons (see #9631)

  k++;

  for ( int i = 1; i < argc; i++ )
  {
    if ( !strcmp( argv[i], "--help" ) )
    {
      info();
      exit( EXIT_SUCCESS );
    }
    else
    {
      char *t = new char[100];

      if ( !t )
      {
        cerr << "smb4k_kill: Out of memory" << endl;
        exit( EXIT_FAILURE );
      }

      if ( strlen( argv[i] ) > 100 )
      {
        cerr << "smb4k_kill: One or more arguments exceed 100 characters" << endl;
        exit( EXIT_FAILURE );
      }

      args[k] = strncpy( t, argv[i], 99 );
      t[99] = '\0';
      k++;

      continue;
    }
  }

  args[k] = NULL;

  if ( k >= 25 )
  {
    cerr << "smb4k_kill: There are too many arguments" << endl;
    exit( EXIT_FAILURE );
  }

  if ( execve( args[0], args, envp ) == -1 )
  {
    int err_code = errno;

    cerr << "smb4k_kill: " << strerror( err_code ) << endl;
    exit( EXIT_FAILURE );
  }

  return EXIT_SUCCESS;
}
