/***************************************************************************
                          smb4kbrowserwidgetitem  -  description
                             -------------------
    begin                : So Jan 30 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qpainter.h>

// KDE includes
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kdebug.h>

// application specific includes
#include "smb4kbrowserwidgetitem.h"

Smb4KBrowserWidgetItem::Smb4KBrowserWidgetItem( QListView *parent, Smb4KWorkgroupItem *item )
: KListViewItem( parent, item->workgroup() ), m_workgroup( *item ), m_mounted( false ), m_type( Smb4KBrowserWidgetItem::Workgroup )
{
  setIcon();
}


Smb4KBrowserWidgetItem::Smb4KBrowserWidgetItem( QListViewItem *parent, Smb4KHostItem *item )
: KListViewItem( parent, item->name(), QString::null, item->ip(), item->comment() ), m_host( *item ), m_mounted( false ), m_type( Smb4KBrowserWidgetItem::Host )
{
  setIcon();
}


Smb4KBrowserWidgetItem::Smb4KBrowserWidgetItem( QListViewItem *parent, Smb4KShareItem *item )
: KListViewItem( parent, item->name(), item->plainType(), QString::null, item->comment() ), m_share( *item ), m_mounted( false ), m_type( Smb4KBrowserWidgetItem::Share )
{
  setIcon();
}


Smb4KBrowserWidgetItem::~Smb4KBrowserWidgetItem()
{
}


void Smb4KBrowserWidgetItem::setIcon()
{
  switch ( m_type )
  {
    case Workgroup:
    {
      m_desktop_icon = DesktopIcon( "network_local" );
      setPixmap( 0, SmallIcon( "network_local" ) );
      break;
    }
    case Host:
    {
      m_desktop_icon = DesktopIcon( "server" );
      setPixmap( 0, SmallIcon( "server" ) );
      break;
    }
    case Share:
    {
      if ( QString::compare( m_share.plainType(), "Printer" ) == 0 )
      {
        m_desktop_icon = DesktopIcon( "printer1" );
        setPixmap( 0, SmallIcon( "printer1" ) );
      }
      else
      {
        if ( m_mounted )
        {
          m_desktop_icon = DesktopIcon( "folder_open" );
          setPixmap( 0, SmallIcon( "folder_open" ) );
        }
        else
        {
          m_desktop_icon = DesktopIcon( "folder" );
          setPixmap( 0, SmallIcon( "folder" ) );
        }
      }
      break;
    }
    default:
    {
      break;
    }
  }
}


void Smb4KBrowserWidgetItem::setMounted( bool mounted )
{
  if ( m_type == Share && QString::compare( m_share.plainType(), "Disk" ) == 0 )
  {
    m_mounted = mounted;

    setIcon();
  }
}


void Smb4KBrowserWidgetItem::update( Smb4KWorkgroupItem *item )
{
  m_workgroup = *item;
}


void Smb4KBrowserWidgetItem::update( Smb4KHostItem *item )
{
  m_host = *item;

  if ( !m_host.ip().isEmpty() && QString::compare( text( IP ).stripWhiteSpace(), m_host.ip() ) != 0 )
  {
    setText( IP, m_host.ip() );
  }

  if ( QString::compare( text( Comment ).stripWhiteSpace(), m_host.comment() ) != 0 )
  {
    setText( Comment, m_host.comment() );
  }
}


void Smb4KBrowserWidgetItem::update( Smb4KShareItem *item )
{
  m_share = *item;

  if ( !m_share.comment().isEmpty() && QString::compare( text( Comment ).stripWhiteSpace(), m_share.comment() ) != 0 )
  {
    setText( Comment, m_share.comment() );
  }
}


void Smb4KBrowserWidgetItem::paintCell( QPainter *p, const QColorGroup &cg, int column, int width, int align )
{
  QFont f( p->font() );
  QColorGroup colorgrp( cg );

  if ( m_type == Share && m_mounted )
  {
    f.setItalic( true );
  }
  else
  {
    f.setItalic( false );
  }

  if ( m_type == Host && m_host.isMaster() )
  {
    colorgrp.setColor( QColorGroup::Text, Qt::darkBlue );
  }
  else
  {
    colorgrp.setColor( QColorGroup::Text, cg.text() );
  }

  p->setFont( f );

  QListViewItem::paintCell( p, colorgrp, column, width, align );
}
