/***************************************************************************
                          smb4ksharewidgetitem  -  description
                             -------------------
    begin                : So Aug 7 2005
    copyright            : (C) 2005 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHAREWIDGETITEM_H
#define SMB4KSHAREWIDGETITEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <qpainter.h>
#include <qpalette.h>
#include <qpixmap.h>
#include <qmime.h>

// KDE includes
#include <kiconview.h>

// application specific includes
#include "../core/smb4kshare.h"

/**
 * This class handles the icon view items that are to be displayed.
 */
class Smb4KShareWidget;
class Smb4KShareWidgetItem : public KIconViewItem
{
  public:
    /**
     * The constructor.
     *
     * @param share     The Smb4KShare object for which the item is for.
     *
     * @param parent    The parent Smb4KShareWidget.
     *
     * @param alignment The alignment of the icon text. It takes one of the values present in the Smb4KShareWidget::DisplayStyle enumeration.
     *
     * @param mp        Whether the mountpoint instead of the share name should be shown. Default is FALSE.
     */
    Smb4KShareWidgetItem( Smb4KShare *share, Smb4KShareWidget *parent = 0, int alignment = Icons, bool mp = false );

    /**
     * The destructor.
     */
    ~Smb4KShareWidgetItem();

    /**
     * Returns the UID of the item.
     */
    int uid() const { return m_share.uid(); }

    /**
     * Returns the GID of the item.
     */
    int gid() const { return m_share.gid(); }

    /**
     * Returns the name of the share.
     */
    QString name() const { return m_share.name(); }

    /**
     * Returns the mountpoint of this share.
     */
    QString mountpoint() const { return m_share.path(); }

    /**
     * Returns the Smb4KShare object.
     */
    Smb4KShare *shareObject() { return &m_share; }

    /**
     * This function replaces the share object.
     *
     * @param share     The new Smb4KShare object.
     */
    void replaceShareObject( Smb4KShare *share );

    /**
     * The display style enumeration.
     */
    enum DisplayStyle{ List, Icons };

    /**
     * Returns TRUE if the share is broken and FALSE otherwise.
     */
    bool isBroken() const { return m_share.isBroken(); }

    /**
     * Sets up the item.
     *
     * @param alignment       The new alignment of the item
     *
     * @param mountpoint      If this is TRUE, the mount point of the share will
     *                        be displayed. Otherwise, its name will be shown.
     */
    void setupItem( int alignment = Icons, bool mountpoint = false );

    /**
     * This function returns the icon of the share item. Its size is
     * always according to the settings of the KIcon::Desktop group.
     *
     * @returns               The icon of the network item
     */
    const QPixmap &desktopIcon() { return m_desktop_pixmap; }

  protected:
    /**
     * Reimplemented from QIconViewItem.
     */
    void paintItem( QPainter *p, const QColorGroup &cg );

    /**
     * Reimplemented from QIconViewItem to enable dropping.
     */
    bool acceptDrop( const QMimeSource *mime ) const;

  private:
    /**
     * The Smb4KShare object.
     */
    Smb4KShare m_share;

    /**
     * The alignment object.
     */
    int m_alignment;

    /**
     * This holds if the mount point should be shown.
     */
    bool m_mountpoint;

    /**
     * Holds the pixmap of the item with the size of the
     * KIcon::Desktop group.
     */
    QPixmap m_desktop_pixmap;
};

#endif
