/***************************************************************************
    smb4kuserinterfaceoptions  -  description
                             -------------------
    begin                : Mi Aug 30 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qbuttongroup.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4kuserinterfaceoptions.h"

Smb4KUserInterfaceOptions::Smb4KUserInterfaceOptions( QWidget *parent, const char *name )
: QTabWidget( parent, name )
{
  setMargin( 10 );

  //
  // Browser tab:
  //
  QWidget *browser_widget = new QWidget( this );
  QGridLayout *browser_layout = new QGridLayout( browser_widget );
  browser_layout->setSpacing( 10 );

  QButtonGroup *remoteSharesGroup = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Remote Shares" ), browser_widget, "BrowserRemoteSharesBox" );
  m_showPrinter = new QCheckBox( i18n( "Show printer shares" ), remoteSharesGroup );
  m_showHidden = new QCheckBox( i18n( "Show hidden shares" ), remoteSharesGroup );
  m_showIPC = new QCheckBox( i18n( "Show IPC$ shares" ), remoteSharesGroup );
  m_showIPC->setEnabled( false );
  m_showAdmin = new QCheckBox( i18n( "Show ADMIN$ shares" ), remoteSharesGroup );
  m_showAdmin->setEnabled( false );

  QButtonGroup *columnsGroup = new QButtonGroup( 2, QButtonGroup::Horizontal, i18n( "Columns" ), browser_widget, "BrowserColumnsBox" );
  m_showType = new QCheckBox( i18n( "Show type" ), columnsGroup );
  m_showIP = new QCheckBox( i18n( "Show IP address" ), columnsGroup );
  m_showComment = new QCheckBox( i18n( "Show comment" ), columnsGroup );

  QButtonGroup *networkTooltipsGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Tooltips" ), browser_widget, "BrowserTooltipsBox" );
  m_showNetworkItemTooltip = new QCheckBox( i18n( "Show tooltip with information about a network item" ), networkTooltipsGroup, 0 );

  QSpacerItem *spacer1 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  browser_layout->addWidget( remoteSharesGroup, 0, 0, 0 );
  browser_layout->addWidget( columnsGroup, 1, 0, 0 );
  browser_layout->addWidget( networkTooltipsGroup, 2, 0, 0 );
  browser_layout->addItem( spacer1, 3, 0 );

  connect( m_showHidden, SIGNAL( stateChanged( int ) ),
           this,         SLOT( slotShowHiddenShares( int ) ) );

  //
  // Shares View tab.
  //
  QWidget *shares_widget = new QWidget( this );
  QGridLayout *shares_layout = new QGridLayout( shares_widget );
  shares_layout->setSpacing( 10 );

  QButtonGroup *sharesIconGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Mounted Shares" ), shares_widget, "SharesIconGroupBox" );
  m_description = new QCheckBox( i18n( "Show mount point instead of share name" ), sharesIconGroup, 0 );
  m_shareview = new QCheckBox( i18n( "Show shares as list instead of as icons" ), sharesIconGroup, 0 );
  m_external = new QCheckBox( i18n( "Show all shares that are mounted on the system" ), sharesIconGroup, 0 );

  QButtonGroup *dragdropGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Drag and Drop" ), shares_widget, "DragnDropBox" );
  m_dropSupport = new QCheckBox( i18n( "Allow dropping of files and directories onto shares" ), dragdropGroup, 0 );
  m_dragSupport = new QCheckBox( i18n( "Allow dragging of shares" ), dragdropGroup, 0 );

  QButtonGroup *sharesTooltipGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Tooltips" ), shares_widget, "SharesTooltipsBox" );
  m_showShareTooltip = new QCheckBox( i18n( "Show tooltip with information about a share" ), sharesTooltipGroup, 0 );

  QSpacerItem *spacer2 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  shares_layout->addWidget( sharesIconGroup, 0, 0, 0 );
  shares_layout->addWidget( dragdropGroup, 1, 0, 0 );
  shares_layout->addWidget( sharesTooltipGroup, 2, 0, 0 );
  shares_layout->addItem( spacer2, 3, 0 );

  // The Preview tab
  QWidget *preview_widget = new QWidget( this );
  QGridLayout *preview_layout = new QGridLayout( preview_widget );
  preview_layout->setSpacing( 10 );

  QButtonGroup *previewFilesGroup = new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Hidden Files and Directories" ), preview_widget, "HiddenFilesBox" );
  m_previewHiddenItems = new QCheckBox( i18n( "Preview hidden files and directories" ), previewFilesGroup, 0 );

  QSpacerItem *spacer3 = new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  preview_layout->addWidget( previewFilesGroup, 0, 0, 0 );
  preview_layout->addItem( spacer3, 1, 0 );

  //
  // Add tabs:
  //
  addTab( browser_widget, i18n( "Network Browser" ) );
  addTab( shares_widget, i18n( "Shares View" ) );
  addTab( preview_widget, i18n( "Preview Dialog" ) );
}


Smb4KUserInterfaceOptions::~Smb4KUserInterfaceOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////


void Smb4KUserInterfaceOptions::slotShowHiddenShares( int state )
{
  if ( state == QCheckBox::On )
  {
    m_showIPC->setEnabled( true );
    m_showAdmin->setEnabled( true );
  }
  else if ( state == QCheckBox::Off )
  {
    m_showIPC->setEnabled( false );
    m_showAdmin->setEnabled( false );
  }
}

#include "smb4kuserinterfaceoptions.moc"
