/***************************************************************************
    smb4kbookmark.cpp  - A bookmark container.
                             -------------------
    begin                : Feb 04 2004
    copyright            : (C) 2004 by Franck Babin
                           (C) 2005-2007 by Alexander Reinholdt
    email                : babinfranck@yahoo.ca
                           dustpuppy@mail.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <ksocketaddress.h>

// application specific includes
#include "smb4kbookmark.h"
#include "smb4knetworkitems.h"


Smb4KBookmark::Smb4KBookmark( const QString &host, const QString &share, const QString &workgroup, const QString &ip, const QString &type, const QString &label )
: m_host( host ), m_share( share ), m_workgroup( workgroup ), m_type( type ), m_label( label )
{
    //FIXME should throw an exception if one of the param is empty

  m_ip = ipIsValid( ip ) ? ip : QString::null;
  m_bookmark = QString( "//%1/%2" ).arg( m_host, m_share );
}


Smb4KBookmark::Smb4KBookmark( Smb4KShareItem *item, const QString &ip, const QString &label )
: m_host( item->host() ), m_share( item->name() ), m_workgroup( item->workgroup() ),
  m_type( item->plainType() ), m_label( label )
{
  m_ip = ipIsValid( ip ) ? ip : QString::null;
  m_bookmark = QString( "//%1/%2" ).arg( m_host, m_share );
}


Smb4KBookmark::~Smb4KBookmark()
{
}


void Smb4KBookmark::setShareName( const QString &name )
{
  m_share = name;

  m_bookmark = QString( "//%1/%2" ).arg( m_host, m_share );
}


void Smb4KBookmark::setIP( const QString &ip )
{
  m_ip = ipIsValid( ip ) ? ip : QString::null;
}


void Smb4KBookmark::setLabel( const QString &text )
{
  m_label = text;
}


bool Smb4KBookmark::ipIsValid( const QString &ip )
{
  if ( !ip.isEmpty() )
  {
    KNetwork::KIpAddress ip_address = KNetwork::KIpAddress( ip );

    if ( !ip_address.isIPv4Addr() && !ip_address.isIPv6Addr() )
    {
      return false;
    }
  }
  else
  {
    return false;
  }

  return true;
}
