/***************************************************************************
    smb4ksearchdialog  -  The search dialog widget of Smb4K.
                             -------------------
    begin                : Sa Jun 2 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qlayout.h>
#include <qstringlist.h>
#include <qheader.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>
#include <kcombobox.h>

// application specific includes
#include "smb4ksearchdialog.h"
#include "smb4ksearchdialogitem.h"
#include "../core/smb4knetworkitems.h"

Smb4KSearchDialog::Smb4KSearchDialog( QWidget *parent, const char *name )
: QWidget( parent, name )
{
  QGridLayout *layout = new QGridLayout( this );
  layout->setSpacing( 5 );

  // Tool bar
  m_tool_bar = new KToolBar( this, "SearchDialogToolBar", true, true );

  m_tool_bar->insertCombo( QStringList(), Combo, true, SIGNAL( returnPressed() ),
                           this, SLOT( slotReturnPressed() ), true,
                           i18n( "Enter the search string here." ), -1, Combo );
  m_tool_bar->setItemAutoSized( Combo, true );

  m_tool_bar->insertSeparator();

  m_tool_bar->insertButton( "find", Search, false, i18n( "Search" ) );
  m_tool_bar->insertButton( "editdelete", Clear, false, i18n( "Clear" ) );
  m_tool_bar->insertButton( "button_ok", Add, false, i18n( "Add" ) );

  // List view
  m_list_view = new KListView( this, "SearchDialogListView" );
  m_list_view->addColumn( i18n( "Search Results" ), -1 );
  m_list_view->header()->hide();
  m_list_view->setSelectionMode( QListView::Single );

  layout->addWidget( m_tool_bar, 0, 0, 0 );
  layout->addWidget( m_list_view, 1, 0, 0 );

  m_search_string = QString::null;

  // Connections:
  connect( m_tool_bar->getCombo( Combo ), SIGNAL( textChanged( const QString & ) ),
           this,                          SLOT( slotTextChanged( const QString & ) ) );

  connect( m_tool_bar,                    SIGNAL( pressed( int ) ),
           this,                          SLOT( slotButtonPressed( int ) ) );

  connect( m_list_view,                   SIGNAL( clicked( QListViewItem * )  ),
           this,                          SLOT( slotItemClicked( QListViewItem * ) ) );

  connect( m_list_view,                   SIGNAL( selectionChanged( QListViewItem * )  ),
           this,                          SLOT( slotSelectionChanged( QListViewItem * ) ) );
}


Smb4KSearchDialog::~Smb4KSearchDialog()
{
}


const QString &Smb4KSearchDialog::searchString()
{
  m_search_string = m_tool_bar->getCombo( Combo )->currentText();

  return m_search_string;
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSearchDialog::slotReturnPressed()
{
  slotButtonPressed( Search );
}


void Smb4KSearchDialog::slotTextChanged( const QString &text )
{
  m_tool_bar->setItemEnabled( Search, !text.isEmpty() );
  m_tool_bar->setItemEnabled( Clear, !text.isEmpty() );
}


void Smb4KSearchDialog::slotButtonPressed( int button_id )
{
  switch( button_id )
  {
    case Search:
    {
      // We will not remove the text from the edit line of the combo
      // box like in earlier versions of Smb4K, but it will be selected
      // later on, so that the user can easily remove it, if he wants to.
      // We disable the combo box until the search process returns.
      m_tool_bar->setItemEnabled( Combo, false );

      break;
    }
    case Clear:
    {
      // Clear the combo box and the list view. The buttons
      // will be disabled by slotTextChanged().
      m_tool_bar->getCombo( Combo )->clear();
      m_list_view->clear();

      m_tool_bar->setItemEnabled( Search, false );
      m_tool_bar->setItemEnabled( Clear, false );
      m_tool_bar->setItemEnabled( Add, false );

      break;
    }
    default:
    {
      break;
    }
  }

  emit buttonPressed( button_id );
}


void Smb4KSearchDialog::slotItemClicked( QListViewItem *item )
{
  if ( !item )
  {
    // If there is no item, it means that the user clicked onto
    // the viewport. In this case, disable the "Add" button and
    // clear the current selection.
    m_tool_bar->setItemEnabled( Add, false );

    m_list_view->clearSelection();
  }
  else
  {
    // This is done by slotSelectionChanged().
  }
}


void Smb4KSearchDialog::slotSelectionChanged( QListViewItem *item )
{
  if ( item )
  {
    // If we have got an item, enable the "Add" button if the
    // item is regular. Otherwise disable the button.
    Smb4KSearchDialogItem *search_item = static_cast<Smb4KSearchDialogItem *>( item );

    if ( search_item->isRegular() )
    {
      m_tool_bar->setItemEnabled( Add, true );
    }
    else
    {
      m_tool_bar->setItemEnabled( Add, false );
    }
  }
  else
  {
    // If there is no item, it means that the user clicked onto
    // the viewport. In this case, disable the "Add" button and
    // clear the current selection.
    m_tool_bar->setItemEnabled( Add, false );

    m_list_view->clearSelection();
  }
}

#include "smb4ksearchdialog.moc"
