/*
       find-index-manage.h
       GNU Licence

       author: Rafal Michniewicz 
        email: <rafim@data.pl>
       jabber: rafim@jabber.org
    home page: http://smbc.airm.net
  
    last update: 2004-03-10
*/

#include "consts.h"

typedef struct Tfind { 
  char group[RMAXGHLEN];
  char host[RMAXGHLEN];
  char dir[2000];
  char file[1000];
  struct Tfind *next;
  struct Tfind *previous;
} TTfind; 

typedef struct TindexTable {
  int number;
  struct TindexTable *next;
  struct TindexTable *previous;
} TTindexTable;

typedef struct ThostsTable {
  char *name;
  struct ThostsTable *next;
} TThostsTable;

int RmakeCopyFileWithPID(char *Rdst, char *Rsrc);

int RindexFileUnlink(char *RpathToFile);
int RindexFileOpen(char *RpathToFile, int *RfileDesc);
int RindexFileCreate(char *RpathToFile, int *RfileDesc);
void RindexFileClose(int *RfileDesc);

int RindexFileReadOneRecord(int RfileDesc, TTfind *TfindRecord);
int RindexFileWriteOneRecord(int RfileDesc, TTfind *TfindRecord);
int RindexFileSetSeek(int RfileDesc, long int Rnr);
int RindexFileGetCount(int RfileDesc);
int RindexFileTruncate(int RfileDesc, long int Rnr);

//-----------------------------------------------------------------

int RcreateNewRecordInIndexTable(TTindexTable **Ridx, int Rnr);
int RfreeAllRecordFromIndexTable(TTindexTable **Ridx);

int RgotoFirstIndexTable(TTindexTable **Ridx);
int RgotoNIndextTable(TTindexTable **Ridx, int Rnr);
int RgetCountRecordIndexTable(TTindexTable *Ridx);
int RgotoNextIndexTable(TTindexTable **Ridx);

//-----------------------------------------------------------------

int RloadIndexFile(int Rfd, TTfind **RidxNet);
void RfreeIndexFile(TTfind **RidxNet);

int RindexNetSetSeek(TTfind **RidxNet, int Rnr);
int RindexNetReadOneRecord(TTfind **RidxNet, TTfind *RidxNetDst);

//-----------------------------------------------------------------

int RAddHostToHostsTable(TThostsTable **RhostsTable, char *Rstr);
int RFreeHostsTable(TThostsTable **RhostsTable);
int RFindHostInToHostsTable(TThostsTable *RhostsTable, char *Rstr);

