#ifndef __SMBITEM_H__
#define __SMBITEM_H__

#include <time.h>
#include "list.h"
#include "buffer.h"
#include "array.h"

#define USERPATH	0x01
#define AUTOPATH	0x02

#define SMBITEM_LINK	0
#define SMBITEM_COMP	1
#define SMBITEM_GROUP	2

#define PATH_UNKNOWN		-1
#define PATH_TO_DIR		0
#define PATH_TO_LINK		1
#define PATH_TO_COMP		2
#define PATH_TO_SHARE		3
#define PATH_TO_SMBFILE		4

typedef struct{
    char	reserved[sizeof(LIST)];
    int		ref_count;	// the number of item references
    time_t	ctime;		// item creation time
    int		type;		// item type: comp/link/group
    hstring	name;		// pointer to item name and its hash
    hstring	link;		// pointer to link and its hash
    char	data[0];	// internal data
} smbitem;

extern BUFFERMANAGER   ConvertBuffer;

int    isTimeForRescanSambaTree(time_t time);
int    SetSmbItemUpdateInterval(int interval);
int    SetSmbItemTime2Live(int ttl);
int    SetQueryBrowserFlag(int flag);
int    GetQueryBrowserFlag();

int  mkgroup(const char *path, int flag);
int  mkhost(const char *path, int flag);
int  mklink(const char *path, const char *link, int flag);

int  getdir(ARRAY *array, const char *path, int flag);
void DeleteSmbItemArray(ARRAY *array);
void RequestSmbItem(smbitem *item);
void ReleaseSmbItem(smbitem* item);
void DeleteOldSmbItem(time_t ctime, int flag);
void UpdateSambaTree();

int  GetPathType(const char *path, BUFFER *buf);

#endif /* __SMBITEM_H__ */
