#include <string.h>
#include <iostream.h>
#include "request.h"
#include "headers.h"
#include "sms.h"

int WyslijSMS_Era(SMS_packet *sms)
{
	const char *cookie, *location, *foo, *foo2, *omnix_url = "http://www.eraomnix.pl";
	char *value, buf[4096], cookie_buf[4096];
	Headers *h2, *f_login;
	HTTP_Request *s;

	char *anc, code[5], *anc_end, code_name[6], code2[5];
	int ret_val;
	char *telefon = sms->telefon;
	char *wiadomosc = sms->wiadomosc;
	char *ok_msg = sms->potwierdzenie;

	while (1) {
		// teraz dostaniemy strone z formularzem do wyslania SMSow
		f_login = new Headers();
		f_login->Add("j_username", konfig.omnix_login);
		f_login->Add("j_password", konfig.omnix_pass);
		s = new HTTP_Request("www.eraomnix.pl", 80, konfig.w3cache_host, konfig.w3cache_port);
		s->AddHeader("Host","www.eraomnix.pl");
		h2 = s->PostData("/sms/do/j_security_check", *f_login);
		delete f_login;

		// pobieramy Cookie eraomnix
		cookie = h2->Header("Set-Cookie");
		if (!cookie) break;
		if (!(value = strchr(cookie, ';'))) break;
		strncpy(cookie_buf, cookie, strlen(cookie));
		*value = 0;

		// pobieramy adres przekierowania
		location = h2->Header("Location");
		if (!location) break;
		// wycinamy z niego poczatkowa nazwe hosta
		if (strstr(location, omnix_url)) {
			foo = location + strlen(omnix_url);
			memmove(buf, foo, strlen(location) - strlen(omnix_url)+1);	
		} else break;
		delete h2;


		// ok, idziemy na strone na ktora nam kazano
		s->AddHeader("Set-Cookie", cookie);
		h2 = s->GetData(buf);

		// znowu pobieramy nowy adres location
		location = h2->Header("Location");
		if (!location) break;
		// wycinamy z niego poczatkowa nazwe hosta
		if (strstr(location, omnix_url)) {
			foo = location + strlen(omnix_url);
			memmove(buf, foo, strlen(location) - strlen(omnix_url)+1);	
		} else break;
		delete h2;


		// idziemy dalej
		h2 = s->GetData(buf);

		// znowu pobieramy nowy adres location
		location = h2->Header("Location");
		if (!location) break;
		// wycinamy z niego poczatkowa nazwe hosta
		if (strstr(location, omnix_url)) {
			foo = location + strlen(omnix_url);
			memmove(buf, foo, strlen(location) - strlen(omnix_url)+1);	
		} else break;
		delete h2;
		s->GetData(buf);

		// musimy odczytac wlasciwy adres do Postowania formularza
		foo = s->GetBody();
		foo = strstr(foo, "/sms/do/previewSMS;jsessionid=");
		if (!foo) break;
		foo2 = strchr(foo, '"');
		if (!foo2) break;
	
		strncpy(buf, foo, foo2-foo);
		buf[foo2-foo] = 0;

		// wow, nareszcie mozemy wyslac SMSa!
		f_login = new Headers();
		f_login->Add("phoneNumber", telefon);
		f_login->Add("smsContent", wiadomosc);
		f_login->Add("reply", "");
		f_login->Add("signature", "");
		f_login->Add("hour", "-- wybierz --");
		f_login->Add("minute", "-- wybierz --");
		f_login->Add("actionKey", "send");
		s->PostData(buf, *f_login);
		


		// ok, teraz szukamy linku do do potwierdzenia wyslania wiadomosci
		foo = s->GetBody();
		foo = strstr(foo, "/sms/do/sendSMS;jsessionid=");
		if (!foo) break;
		foo2 = strchr(foo, '"');
		if (!foo2) break;
		strncpy(buf, foo, foo2-foo);
		buf[foo2-foo] = 0;

		// no i na sam koniec wysylamy!
		s->GetData(buf);
		
		
    		ret_val = poprawna_odpowiedz(ok_msg, telefon, s->GetBody());

		delete s;

		return ret_val;
    }

    throw new Exception("Blad obslugi strony www.eraomnix.pl");
    return 0;
}

