#ifndef __cgdbm_h_
#define __cgdbm_h_

#include <stdlib.h>
#include <string>
#include <gdbm.h>
#include <exception>

// typy danych rozpoznawane przez klase Cdatum - takich typow mozna uzywac
// bezposrednio w konstruktorach

class Cdatum
{
protected:
	datum dat;
   void Clear();
public:
   Cdatum();
   Cdatum(const Cdatum &cd);
   Cdatum(const datum &d);
   Cdatum(const void *ptr, int size);
   Cdatum(const std::string &str);
   Cdatum(long val);
   Cdatum(float val);
   virtual ~Cdatum();
   Cdatum &operator=(const Cdatum &cd);
   Cdatum &operator=(const datum &d);

   bool isNull() { return dat.dptr==NULL; };

   operator datum&();
   operator std::string();
   operator long();
   operator float();
   operator const void*();
};    

class Cgdbm
{
public:
	class Cgdbm_exception : public std::exception {
		public:
		Cgdbm_exception() {};
	};
protected:
   std::string filename;     
   GDBM_FILE db;
   Cdatum tmp_key;
public:
   Cgdbm() : db(NULL) {};
   Cgdbm(const std::string &_filename, int block_size, int read_write, int mode = 0600);
   virtual ~Cgdbm();

   bool Open(const std::string &_filename, int block_size, int read_write, int mode = 0600);
   void Close();
   
   bool store(Cdatum &key, Cdatum &content, int flag);
   bool insert(Cdatum &key, Cdatum &content);
   bool replace(Cdatum &key, Cdatum &content);

   Cdatum operator[](Cdatum &key);
   Cdatum begin();
   Cdatum next();

   bool Exists(Cdatum &key);

   bool Delete(Cdatum &key);

   bool Reorganize();
   void Sync();
   int SetOpt(int option, int *value, int size);

   const char *StrError(gdbm_error err = (gdbm_error)-1);
   const char *Version();
   const int Status();
};

#endif
