/*
SMS Server Tools 
Copyright (C) Stefan Frings

This program is free software unless you got it under another license directly
from the author. You can redistribute it and/or modify it under the terms of 
the GNU General Public License as published by the Free Software Foundation.
Either version 2 of the License, or (at your option) any later version.

http://www.isis.de/members/~s.frings
mailto:stefan.frings@vodafone.de
*/

#include "charset.h"

//                  iso   sms   mo    mt
char charset[] = { '@' , 0x00, 0x40, 0x40,
		   0xA3, 0x01, 0xA3, 0x01,
		   '$' , 0x02, 0x24, 0x24,
		   0xA5, 0x03, 0xA5, 0x03,
		   0xE8, 0x04, 0xE8, 0x04,
		   0xE9, 0x05, 0xE9, 0x05,
		   0xF9, 0x06, 0xF9, 0x06,
		   0xEC, 0x07, 0xEC, 0x07,
		   0xF2, 0x08, 0xF2, 0x08,
		   0xC7, 0x09, 0xC7, 0x09,
		   0x0A, 0x0A, 0x0A, 0x0A,
		   0xD8, 0x0B, 0xD8, 0x0B,
		   0xF8, 0x0C, 0xF8, 0x0C,
		   0x0D, 0x0D, 0x0D, 0x0D,
		   0xC5, 0x0E, 0xC5, 0x0E,
		   0xE5, 0x0F, 0xE5, 0x0F,
		   0x81, 0x10, 0x81, 0x10,
		   0x5F, 0x11, 0x5F, 0x11,
		   0x82, 0x12, 0x82, 0x12,
		   0x83, 0x13, 0x83, 0x13,
		   0x84, 0x14, 0x84, 0x14,
		   0x85, 0x15, 0x85, 0x15,
		   0x86, 0x16, 0x86, 0x16,
		   0x87, 0x17, 0x87, 0x17,
		   0x88, 0x18, 0x88, 0x18,
		   0x89, 0x19, 0x89, 0x19,
		   0x8A, 0x1A, 0x8A, 0x1A,
		   0x1B, 0x1B, 0x1B, 0x1B,
		   0xC6, 0x1C, 0xC6, 0x1C,
		   0xE6, 0x1D, 0xE6, 0x1D,
		   0xDF, 0x1E, 0x7E, 0x1E,
		   0xC9, 0x1F, 0xC9, 0x1F,
		   ' ' , 0x20, 0x20, 0x20,
		   '!' , 0x21, 0x21, 0x21,
		   0x22, 0x22, 0x22, 0x22,
		   '#' , 0x23, 0x23, 0x23,
		   0xA4, 0x24, 0xA4, 0x02,
		   '%' , 0x25, 0x25, 0x25,
		   '&' , 0x26, 0x26, 0x26,
		   0x27, 0x27, 0x27, 0x27,
		   '(' , 0x28, 0x28, 0x28,
		   ')' , 0x29, 0x29, 0x29,
		   '*' , 0x2A, 0x2A, 0x2A,
		   '+' , 0x2B, 0x2B, 0x2B,
		   ',' , 0x2C, 0x2C, 0x2C,
		   '-' , 0x2D, 0x2D, 0x2D,
		   '.' , 0x2E, 0x2E, 0x2E,
		   '/' , 0x2F, 0x2F, 0x2F,
		   '0' , 0x30, 0x30, 0x30,
		   '1' , 0x31, 0x31, 0x31,
		   '2' , 0x32, 0x32, 0x32,
		   '3' , 0x33, 0x33, 0x33,
		   '4' , 0x34, 0x34, 0x34,
		   '5' , 0x35, 0x35, 0x35,
		   '6' , 0x36, 0x36, 0x36,
		   '7' , 0x37, 0x37, 0x37,
		   '8' , 0x38, 0x38, 0x38,
		   '9' , 0x39, 0x39, 0x39,
		   ':' , 0x3A, 0x3A, 0x3A,
		   ';' , 0x3B, 0x3B, 0x3B,
		   '<' , 0x3C, 0x3C, 0x3C,
		   '=' , 0x3D, 0x3D, 0x3D,
		   '>' , 0x3E, 0x3E, 0x3E,
		   '?' , 0x3F, 0x3F, 0x3F,
		   0xA1, 0x40, 0xA1, 0x00,
		   'A' , 0x41, 0x41, 0x41,
		   'B' , 0x42, 0x42, 0x42,
		   'C' , 0x43, 0x43, 0x43,
		   'D' , 0x44, 0x44, 0x44,
		   'E' , 0x45, 0x45, 0x45,
		   'F' , 0x46, 0x46, 0x46,
		   'G' , 0x47, 0x47, 0x47,
		   'H' , 0x48, 0x48, 0x48,
		   'I' , 0x49, 0x49, 0x49,
		   'J' , 0x4A, 0x4A, 0x4A,
		   'K' , 0x4B, 0x4B, 0x4B,
		   'L' , 0x4C, 0x4C, 0x4C,
		   'M' , 0x4D, 0x4D, 0x4D,
		   'N' , 0x4E, 0x4D, 0x4D,
		   'O' , 0x4F, 0x4F, 0x4F,
		   'P' , 0x50, 0x50, 0x50,
		   'Q' , 0x51, 0x51, 0x51,
		   'R' , 0x52, 0x52, 0x52,
		   'S' , 0x53, 0x53, 0x53,
		   'T' , 0x54, 0x54, 0x54,
		   'U' , 0x55, 0x55, 0x55,
		   'V' , 0x56, 0x56, 0x56,
		   'W' , 0x57, 0x57, 0x57,
		   'X' , 0x58, 0x58, 0x58,
		   'Y' , 0x59, 0x59, 0x59,
		   'Z' , 0x5A, 0x5A, 0x5A,
		   0xC4, 0x5B, 0x5B, 0x5B,
		   0xD6, 0x5C, 0x5C, 0x5C,
		   0xD1, 0x5D, 0xD1, 0x5F,
		   0xDC, 0x5E, 0x5D, 0x5D,
		   0xA7, 0x5F, 0xA7, 0x5E,
		   0xBF, 0x60, 0xBF, 0x60,
		   'a' , 0x61, 0x61, 0x61,
		   'b' , 0x62, 0x62, 0x62,
		   'c' , 0x63, 0x63, 0x63,
		   'd' , 0x64, 0x64, 0x64,
		   'e' , 0x65, 0x65, 0x65,
		   'f' , 0x66, 0x66, 0x66,
		   'g' , 0x67, 0x67, 0x67,
		   'h' , 0x68, 0x68, 0x68,
		   'i' , 0x69, 0x69, 0x69,
		   'j' , 0x6A, 0x6A, 0x6A,
		   'k' , 0x6B, 0x6B, 0x6B,
		   'l' , 0x6C, 0x6C, 0x6C,
		   'm' , 0x6D, 0x6D, 0x6D,
		   'n' , 0x6E, 0x6E, 0x6E,
		   'o' , 0x6F, 0x6F, 0x6F,
		   'p' , 0x70, 0x70, 0x70,
		   'q' , 0x71, 0x71, 0x71,
		   'r' , 0x72, 0x72, 0x72,
		   's' , 0x73, 0x73, 0x73,
		   't' , 0x74, 0x74, 0x74,
		   'u' , 0x75, 0x75, 0x75,
		   'v' , 0x76, 0x76, 0x76,
		   'w' , 0x77, 0x77, 0x77,
		   'x' , 0x78, 0x78, 0x78,
		   'y' , 0x79, 0x79, 0x79,
		   'z' , 0x7A, 0x7A, 0x7A,
		   0xE4, 0x7B, 0x7B, 0x7B,
		   0xF6, 0x7C, 0x7C, 0x7C,
		   0xF1, 0x7D, 0xF1, 0x1E,
		   0xFC, 0x7E, 0x7D, 0x7D,
		   0xE0, 0x7F, 0xE0, 0x7F,
// Replacements for ISO 8859-1 charcters that do not exist in the SMS alphabet
		   0x60, 0x27, 0x27, 0x27,
// End mark
		   0   , 0   , 0   , 0
		 };

// Extended characters in iso-8859-15 / sms / mo / mt
// Only the first 2 columns are used by SMS Server Tools
char ext_charset[] = { 0x0C, 0x0A, 0x0A, 0x0A,
                       0x5E, 0x14, 0x14, 0x14,    // ^
		       0x7B, 0x28, 0x28, 0x28,    // {
		       0x7D, 0x29, 0x29, 0x29,    // }
		       0x5C, 0x2F, 0x2F, 0x2F,    // \
		       0x5B, 0x3C, 0x3C, 0x3C,    // [
		       0x7E, 0x3D, 0x3D, 0x3D,    // ~
		       0x5D, 0x3E, 0x3E, 0x3E,    // ]
		       0x7C, 0x40, 0x40, 0x40,    // |
		       0xA4, 0x65, 0x65, 0x65,    //  Euro iso-8859-15
// End mark		       
		       0   , 0   , 0   , 0  
	             };
		




char convert(char c,int from,int to)
{
  int table=0;
  while (charset[table*4])
  {
    if (charset[table*4+from]==c)
      // found
      return charset[table*4+to];
    table++;
  }
  // not found, return a space character
  return ' ';
}

char ext_convert(char c,int from,int to)
{
  int table=0;
  while (ext_charset[table*4])
  {
    if (ext_charset[table*4+from]==c)
      // found
      return ext_charset[table*4+to];
    table++;
  }
  // not found, return a space character
  return ' ';
}
