/*==================================================================
 * uif_menutbar.h - Header file for menu and tool bar routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef UIF_MENUTBAR_H_DEF
#define UIF_MENUTBAR_H_DEF

#include <gtk/gtk.h>

/* function prototypes */

void sfmenu_view_log (void);
void sfmenu_restart_sequencer (void);
void sfmenu_cb_find (void);
void sfmenu_set_filemenu_save_sensitive (gboolean state);

/* a bunch of callbacks for Glade menu items as it currently doesn't support
   parameters to callback functions for menu items */
void sfmenu_cb_save (void);
void sfmenu_cb_save_as (void);
void sfmenu_cb_gen_view (GtkWidget * widg);
void sfmenu_cb_gen_ctrl (GtkWidget * widg);
void sfmenu_cb_sam_view (GtkWidget * widg);
void sfmenu_cb_piano_mode (GtkWidget * widg);
void sfmenu_cb_velocity_mode (GtkWidget * widg);

void sfmenu_set_lowpane_radio_item (gint mode);
void sfmenu_set_piano_mode_radio_item (gint mode);

void sfmenu_update_control_buttons (void);
void sfmenu_wavetable_caching (GtkWidget *menuitem);
void sfmenu_piano_follows (GtkWidget *menuitem);
void sfmenu_auto_temp_audible (GtkWidget *menuitem);
void sfmenu_bank_refresh (GtkWidget *menuitem);

#if 0
void sfmenu_start_jam_server (void);
void sfmenu_start_jam_client (void);
#endif

void tbar_create (void);
void tbar_update_seq_togbtn (void);
void tbar_set_seq_toggle (GtkWidget * btn, gboolean active);
gboolean tbar_cb_seq_toggle (GtkWidget * btn);
gboolean tbar_cb_gen_set_win (GtkWidget * rad, gint wintype);
void tbar_cb_pianospan_set_mode (GtkWidget * rad, gint mode);
void tbar_set_lowpane_togbtn (gint mode);
void tbar_set_piano_mode_togbtn (gint mode);

#endif
