/*==================================================================
 * vbank.h - Virtual sound font bank header file
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * Borrowed code from awesfx utilities
 * in files loadbank.c, bool.c, dynload.c in awelib/
 * awesfx utilities are Copyright (C) 1996-1999 Takashi Iwai
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __VBANK_H__
#define __VBANK_H__

#include <glib.h>
#include "sfont.h"


/* a little temporary structure returned from some routines, a SFPreset along
   with its destination bank:preset */
typedef struct _VBnkPresetMap {
  SFPreset *preset;
  SFData *sf;
  gint bank;
  gint psetnum;
} VBnkPresetMap;

/* Virtual bank item pointer preset/bank/keynote */
typedef struct _VBnkPtr {
  gint psetnum;
  gint bank;
  gint keynote;
} VBnkPtr;

/* a mapped item in a virtual bank */
typedef struct _VBnkItem {
  SFItemID itemid;		/* ID of item in sftree */
  VBnkPtr src;			/* source preset/bank/note */
  VBnkPtr map;			/* preset/bank/note to map to */
  gchar *sfname;		/* file name of sound font (no path or ext) */
} VBnkItem;

typedef struct _VBnkData {
  SFItemID itemid;		/* ID of vbank in sftree */
  gchar *fname;			/* file name of the virtual bank file */
  gchar *defname;		/* default SF file name (or NULL if none) */
  GSList *wilditems; /* wildcard maps (list of VBnkItems - NOT SUPPORTED YET) */
  GSList *items;		/* list of virtual bank items (VBnkItems) */
  gboolean beensaved;		/* virtual bank has been saved yet? */
  gboolean up2date;		/* is saved file up to date? */
} VBnkData;

VBnkData *vbank_new (gint untitlecount);
VBnkData *vbank_load (gchar *fname);
gint vbank_save (VBnkData *vbnk, FILE *fp);
void vbank_close (VBnkData *vbnk);
VBnkItem *vbank_item_alloc (void);
void vbank_item_free (VBnkItem *item);
VBnkItem *vbank_add_map (gint mapbank, gint mappset, gint mapnote, gint srcbank,
			 gint srcpset, gint srcnote, gchar *srcsfname,
			 VBnkData *vbnk);
void vbank_delete_map (VBnkItem *item, VBnkData *vbnk);
void vbank_find_free_map (gint *bank, gint *psetnum, VBnkData *vbnk);
gint vbank_is_virtual_bank (gchar *path);
void vbank_set_fname (VBnkData *vbnk, gchar *fname);
void vbank_set_defsf (VBnkData *vbnk, gchar *fname);
GList *vbank_get_preset_maps (VBnkData *vbnk);
SFPreset *vbank_get_item_preset (VBnkItem *item);
void vbank_find_unloaded_sfonts (VBnkData *vbnk, GList **found,
				 GList **notfound);
gchar *vbank_locate_sfont_by_name (gchar *sfname);
gchar *vbank_base_fname (gchar *sfpath);
void vbank_update_sffile_hash (void);

#endif /* __VBANK_H__ */
