from __future__ import division
import textures
import pygame
from OpenGL.GL import *
import glFreeType
import settings


# Hack to get the map loading to know when to create new igloos and when to
# wait for them to be added later.
THIS_IS_SERVER = True


class Penguins:
    def __init__(self, bigtexture):
        self.bigtexture = textures.Texture(bigtexture)

        self.images = {}

        directions = [(0,1), (-1,1), (-1,0), (-1,-1), (0,-1), (1,-1), (1,0), (1,1)]
        for dc in xrange(len(directions)):
            d = directions[dc]
            for i in xrange(11):
                if i == 10:
                    key = ("idle", d)
                else:
                    key = (i, d)
                t = self.bigtexture.sub(32*i, (256-32)-32*dc, 32, 32)
                #print 32*i,(512-32)-32*dc
                self.images[key] = t


class View:
    def __init__(self,x,y):
        self.x = x
        self.y = y
        self.h = 0
        self.w = 0
        self.zoom = 1.0
        
    @property
    def scale_h(self):
        return int(self.h // self.zoom)
    @property
    def scale_w(self):
        return int(self.w // self.zoom)

view = View(0,0)

class Rendered:
    def __init__(self, image, x, y, z=0, colorize=(1,1,1), scale=None, alpha=1):
        self.image = image
        self.x = x
        self.y = y
        self.z = z
        self.colorize = list(colorize)+[alpha]
        self.scale = scale

    def render(self):
        glColor4f(*self.colorize)
        if self.scale:
            glPushMatrix()
            glTranslatef(self.x, self.y, 0)
            glScalef(self.scale, self.scale, 1)
            self.image.render()
            glPopMatrix()
        else:
            self.image.render(self.x, self.y)
        glColor4f(1,1,1,1)

    def __cmp__(self, other):
        return cmp((self.z, self.y+self.image.height, -self.x), (other.z, other.y+other.image.height, -other.x))

particles = set()



class ImprentSet:
    def __init__(self, image, length):
        self.image = textures.Texture(image)
        self.imprents = set()

        # convert seconds to milliseconds.
        self.length = length*1000

    def add(self,x,y,color=(1,1,1)):
        self.imprents.add(Imprent(x,y, color))

    def draw(self, dt):
        if not self.imprents: return
        global view, get_ticks
        t_r = set()
        glEnable(GL_TEXTURE_2D)
        self.image.bind()
        for i in self.imprents:
            if i.x > view.x and i.x < view.x+view.w\
                    and i.y > view.y and i.y < view.y+view.h:
                opc = 1 - (get_ticks()-i.start_time) / self.length
                color = []
                for c in i.color:
                    if c > 1:
                        c = c/255
                    color.append(c)
                color.append(opc)
                glColor4f(*color)


                x = i.x
                y = i.y

                #self.image.render(x,y)
                glTranslatef(x,y,0)
                glCallList(self.image.get_render_disp_list())
                glTranslatef(-x,-y,0)


            if (get_ticks()-i.start_time) / self.length >= 1:
                t_r.add(i)
        self.imprents.difference_update(t_r)
        glColor4f(1,1,1,1)
        glDisable(GL_TEXTURE_2D)


class Imprent:
    def __init__(self, x, y, color=(1,1,1)):
        global get_ticks
        self.x = x
        self.y = y
        self.color = color
        self.start_time = get_ticks()


class Animator:
    def __init__(self, speed, max_alpha, min_alpha, active=True):
        self.active = active
        self.alpha = 1
        self.speed = 0.05
        self.max_alpha = max_alpha
        self.min_alpha = min_alpha

    def animate(self):
        if self.active:
            self.alpha += self.speed
            if self.alpha > self.max_alpha:
                self.alpha = self.max_alpha
                self.speed = -self.speed
            elif self.alpha < self.min_alpha:
                self.alpha = self.min_alpha
                self.speed = -self.speed

class Messages:

    class Message(Animator):
        def __init__(self, time, msg, from_player, pulsate=False):
            Animator.__init__(self, 0.05, 1, 0.6, pulsate)
            self.time = time
            self.msg = msg
            self.from_player = from_player
            self.force_close = False
            self.num_lines = len(msg.split("\n"))

    def __init__(self):
        self.messages = []

    def clear(self):
        for m in self.messages:
            m.force_close = True

    def send(self, msg, from_player, to_player):
        self.display(msg, from_player, to_player)
        # Send the message to the server...
        try:
            import networking
            networking.send_chat_message(msg, from_player, to_player)
        except ImportError:
            pass

    def display(self, msg, from_player, to_player):
        global get_ticks, player, view
        # Display the message locally
        if to_player:
            if from_player == player:
                self.messages.append(Messages.Message(get_ticks(),
                        ">%s: %s" % (to_player.name, msg), from_player))
            if to_player == player:
                self.messages.append(Messages.Message(get_ticks(),
                        "%s > %s" % (from_player.name, msg), from_player, True))
                import ctrl
                ctrl.last_received_from = from_player.name

            if to_player.type is "ai" and from_player.type is "human":
                to_player.ai.send_msg(msg, from_player)
        else:
            self.messages.append(Messages.Message(get_ticks(), "%s: %s"%
                    (from_player.name, msg), from_player))
        #print msg

    def drawall(self):
        global get_ticks, view
        lh = float (chat_font.m_font_height) / 0.63
        y = lh
        #fading = False
        to_r = False
        first = False
        for m in self.messages:
            h = lh*m.num_lines
            timep = get_ticks() - m.time

            m.animate()

            alpha = m.alpha
            if first and not m.force_close:
                m.time = get_ticks()
            elif timep > 4000 or m.force_close:
                if m.force_close and timep < 4000:
                    m.time = get_ticks() - 4000
                    timep = 4000
                # Fade out. Takes 1000 milsecs.
                alpha = 1 - (timep-4000)/1000
                y -= h - alpha*h
            alpha = max(0, min(alpha, 1))
            first = True
            color = m.from_player.glcolor[:]
            color.append(alpha)
            glColor4f(*color)
            chat_font.glPrint(10, view.h-y, m.msg)
            glColor4f(1,1,1,1)
            if alpha == 0:
                to_r = True
            y += h

        if to_r:
            self.messages.pop(0)


messages = Messages()


draw_buffer = []


selected_units = set()
select_box_start = None
select_box_end = None

draw_minimap = False


units = []
buildings = []
resources = set()
snowballs = set()

# Players in the game.
players = {}

# The player on this client
player = None


pause_time = 0
penguins = {}
map = None
minimap = None
trees = []
snowballtextures = []
smoke = None
snowparticle = None
snowballimprents = None
snowball_ice_imprents = None
footimprents = None
penguinselection = None
moveimprents = None
runmoveimprents = None
gathermoveimprents = None
marker = None
jeopardy_marker = None
fish = None
chat_font = None
stat_font = None
data_loaded = False
footprints_settings = 0
icepinnacle = []
def init(mapname):
    from player import Player
    from map import Map
    from minimap import MiniMap
    global data_loaded, penguins, map, player, trees, snowballtextures, smoke, snowparticle, Imprent, snowballimprents, snowball_ice_imprents, footimprents, penguinselection, moveimprents, marker, jeopardy_marker, fish, minimap, units, buildings, resources, snowballs, players, draw_buffer, selected_units, select_box_start, select_box_end, draw_minimap, runmoveimprents, chat_font, stat_font, gathermoveimprents, footprints_settings, icepinnacle

    # We cache this here because this option is accessed so often.
    footprints_settings = int(settings.get_option("footprints"))

    #Clear data stores in case filled.
    messages.__init__()
    units = []
    buildings = []
    resources = set()
    snowballs = set()
    players = {}
    draw_buffer = []
    selected_units = set()
    select_box_start = None
    select_box_end = None
    draw_minimap = False

    # Imprent sets. We want to assign these even if data loaded.,
    snowballimprents = ImprentSet("data/snowballimprent.png", 2)
    snowball_ice_imprents = ImprentSet("data/snowball_ice_imprent.png", 2)
    footimprents = ImprentSet("data/footprint.png", 4)
    moveimprents = ImprentSet("data/marker.png", 0.3)
    runmoveimprents = ImprentSet("data/marker_run.png", 0.3)
    gathermoveimprents = ImprentSet("data/marker_gather.png", 0.3)


    if not data_loaded:
        # Fonts.
        chat_font = glFreeType.Font("data/TSCu_Comic.ttf", 20)
        stat_font = glFreeType.Font("data/TSCu_Comic.ttf", 16, True)

        # Some general textures.
        fish = textures.Texture("data/fish.png")
        snowparticle = textures.Texture("data/snowparticle.png")
        jeopardy_marker = textures.Texture("data/jeopardy_marker.png")
        marker = textures.Texture("data/marker.png")
        smoke = textures.Texture("data/smoke.png")
        penguinselection = textures.Texture("data/selected.png")

        # Trees.
        tt = textures.Texture("data/trees.png")
        trees.append(tt.sub(0,0,64,64))
        trees.append(tt.sub(64,0,64,64))
        trees.append(tt.sub(0,64,64,64))
        trees.append(tt.sub(64,64,64,64))

        # Ice pinnacles.
        it = textures.Texture("data/icepinnacles.png")
        icepinnacle.append(it.sub(0,0,64,64))
        icepinnacle.append(it.sub(64,0,64,64))
        icepinnacle.append(it.sub(0,64,64,64))

        # Snowball.
        ss = textures.Texture("data/snowball.png")
        snowballtextures.append(ss.sub(0,0,8,8))
        snowballtextures.append(ss.sub(8,0,8,8))

    # Setup map.
    Map.load(mapname)
    minimap = MiniMap()

    if not data_loaded:

        # Generate penguin textures.
        penguins["walk"] = Penguins("data/walk.png")

        penguins["workerwalk"] = Penguins("data/workerwalk.png")
        penguins["snowballerwalk"] = Penguins("data/snowballerwalk.png")

        penguins["throwing"] = Penguins("data/throw.png")
        penguins["snowballerthrowing"] = Penguins("data/snowballerthrow.png")

        penguins["getting_snowball"] = Penguins("data/gathersnow.png")
        penguins["snowballergetting_snowball"] = Penguins("data/snowballergathersnow.png")

        penguins["unloadfish"] = Penguins("data/unloadfish.png")
        penguins["workerunloadfish"] = Penguins("data/workerunloadfish.png")

        penguins["unloadcrystal"] = Penguins("data/unloadcrystal.png")
        penguins["workerunloadcrystal"] = Penguins("data/workerunloadcrystal.png")

        penguins["gathering"] = Penguins("data/gatherfish.png")
        penguins["workergathering"] = Penguins("data/workergatherfish.png")

        penguins["walkfish"] = Penguins("data/walkfish.png")
        penguins["workerwalkfish"] = Penguins("data/workerwalkfish.png")

        penguins["walkcrystal"] = Penguins("data/walkcrystal.png")
        penguins["workerwalkcrystal"] = penguins["workerwalkfish"]


        penguins["frozen"] = textures.Texture("data/frozen.png")


    data_loaded = True


def get_ticks():
    global pause_time
    return pygame.time.get_ticks()-pause_time


def canvas_to_map(x, y):
    global view
    x, y = view.x + x, view.y + y
    return (max(0, (x // 32) * 32 // 32), max(0, (y // 32) * 32 // 32))

def draw_box(x,y,w,h):
    glBegin(GL_QUADS)
    glVertex2f(x, y+h)
    glVertex2f(x+w, y+h)
    glVertex2f(x+w, y)
    glVertex2f(x, y)
    glEnd()
