/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 3      *
*                (c) 2006-2008 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
//
// C++ Interface: TriangleBendingSprings
//
// Description: 
//
//
// Author: The SOFA team </www.sofa-framework.org>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SOFA_COMPONENT_FORCEFIELD_TRIANGLEBENDINGSPRINGS_H
#define SOFA_COMPONENT_FORCEFIELD_TRIANGLEBENDINGSPRINGS_H

#include <sofa/component/forcefield/StiffSpringForceField.h>
#include <sofa/component/MechanicalObject.h>
#include <map>

namespace sofa
{

namespace component
{

namespace forcefield
{

/**
Bending springs added between vertices of triangles sharing a common edge.
The springs connect the vertices not belonging to the common edge. It compresses when the surface bends along the common edge.


	@author The SOFA team </www.sofa-framework.org>
*/
  template<class DataTypes>
      class TriangleBendingSprings : public sofa::component::forcefield::StiffSpringForceField<DataTypes>
{
public:
  typedef typename DataTypes::Real Real;
  typedef typename DataTypes::VecCoord VecCoord;
  
  TriangleBendingSprings();

    ~TriangleBendingSprings();
    
    /// Searches triangle topology and creates the bending springs
    virtual void init();
     
    //virtual void draw()
    //{
    //}
    
protected:
    typedef std::pair<unsigned,unsigned> IndexPair;
    void addSpring( unsigned, unsigned );
    void registerTriangle( unsigned, unsigned, unsigned, std::map<IndexPair, unsigned>& );
    component::MechanicalObject<DataTypes>* dof;

};

} // namespace forcefield

} // namespace component

} // namespace sofa

#endif
