/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 3      *
*                (c) 2006-2008 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef SOFA_COMPONENT_MAPPING_CENTEROFMASSMAPPING_H
#define SOFA_COMPONENT_MAPPING_CENTEROFMASSMAPPING_H

#include <sofa/core/componentmodel/behavior/MechanicalMapping.h>
#include <sofa/core/componentmodel/behavior/MechanicalState.h>
#include <sofa/core/componentmodel/behavior/BaseMass.h>
#include <sofa/defaulttype/RigidTypes.h>

namespace sofa
{

namespace component
{

namespace mapping
{

	using namespace sofa::core::componentmodel::behavior;


template <class BasicMapping>
class CenterOfMassMapping : public BasicMapping, public virtual core::objectmodel::BaseObject
{
  public:
	typedef BasicMapping Inherit;
	typedef typename Inherit::In In;
	typedef typename Inherit::Out Out;
	typedef typename Out::Coord OutCoord;
	typedef typename Out::Deriv OutDeriv;
	typedef typename In::Coord InCoord;
	typedef typename In::Deriv InDeriv;
	typedef typename OutCoord::value_type Real;

	CenterOfMassMapping ( In* from, Out* to ): Inherit ( from, to )
	{}

	virtual ~CenterOfMassMapping()
	{}

	void init();
	
	virtual void apply ( typename Out::VecCoord& childPositions, const typename In::VecCoord& parentPositions );

	virtual void applyJ ( typename Out::VecDeriv& childForces, const typename In::VecDeriv& parentForces );

	virtual void applyJT ( typename In::VecDeriv& parentForces, const typename Out::VecDeriv& childForces );

	void draw();


  protected :
	BaseMass * masses;

	double totalMass;

};

} // namespace mapping

} // namespace component

} // namespace sofa

#endif
