/*
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef SIP_TAG_H
/** Defined when <sofia-sip/sip_tag.h> has been included. */
#define SIP_TAG_H

/**@file sofia-sip/sip_tag.h
 * @brief Tag class for SIP headers
 *
 * This file is automatically generated from <sip.h> by msg_parser.awk.
 *
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>.
 *
 */

#ifndef SU_TAG_H
#include <sofia-sip/su_tag.h>
#endif
#ifndef SU_TAG_CLASS_H
#include <sofia-sip/su_tag_class.h>
#endif

#ifndef SIP_H
#include <sofia-sip/sip.h>
#endif

SOFIA_BEGIN_DECLS

/** Test if tag type marks a sip_t structure. @HIDE */
#define SIPTAG_P(tt)     ((tt)->tt_class == siphdrtag_class)
/** Test if tag type marks a SIP header string. @HIDE */
#define SIPTAG_STR_P(tt) ((tt)->tt_class == sipstrtag_class)
/** Test if tag type marks a SIP header structure. @HIDE */
#define SIPTAG_SIP_P(tt) ((tt)->tt_class == sipmsgtag_class)

/** Test if tag item contains sip_t structure. @HIDE */
#define SIPTAGI_P(t)     (SIPTAG_P((t)->t_tag))
/** Test if tag item contains a SIP header string. @HIDE */
#define SIPTAGI_STR_P(t) (SIPTAG_STR_P((t)->t_tag))
/** Test if tag item contains a SIP header structure. @HIDE */
#define SIPTAGI_SIP_P(t) (SIPTAG_SIP_P((t)->t_tag))

/** Tag class for SIP headers */
SOFIAPUBVAR tag_class_t siphdrtag_class[1];
/** Tag class for string values of SIP headers */
SOFIAPUBVAR tag_class_t sipstrtag_class[1];
/** Tag class for SIP message */
SOFIAPUBVAR tag_class_t sipmsgtag_class[1];

/** Lists of SIP tags. */
SOFIAPUBVAR tag_type_t sip_tag_list[], sip_tag_str_list[];

/** Filter tag matching any sip tag. */
#define SIPTAG_ANY()         siptag_any, ((tag_value_t)0)
SOFIAPUBVAR tag_typedef_t siptag_any;

/** End of SIP headers */
#define SIPTAG_END()         siptag_end, (tag_value_t)0
SOFIAPUBVAR tag_typedef_t siptag_end;

/**Tag list item for #sip_t object.
 *
 * The SIPTAG_SIP() macro is used to include a tag item for a #sip_t struct
 * in the tag list.
 *
 * @param x pointer to a #sip_t message structure, or NULL.
 *
 * @HIDE
 */
#define SIPTAG_SIP(x)       siptag_sip, siptag_sip_v((x))

/** Tag for @c sip_t */
SOFIAPUBVAR tag_typedef_t siptag_sip;

#define SIPTAG_SIP_REF(x)   siptag_sip_ref, siptag_sip_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_sip_ref;

#if SU_HAVE_INLINE
su_inline
tag_value_t siptag_sip_v(sip_t const *v) { return (tag_value_t)v; }
su_inline 
tag_value_t siptag_sip_vr(sip_t const **vp) { return (tag_value_t)vp; }
#else
#define siptag_sip_v(v)   (tag_value_t)(v)
#define siptag_sip_vr(vp) (tag_value_t)(vp)
#endif

/**Tag list item for header string.
 *
 * The SIPTAG_HEADER() macro is used to include a tag item containing an
 * unknown SIP header in the tag list, e.g., 
 * @code 
 * sip_header_t *hdr;
 *
 * SIPTAG_HEADER(hdr).
 * @endcode
 *
 * @param x pointer to a header structure, or NULL.
 *
 * @HIDE
 */
#define SIPTAG_HEADER(x)       siptag_header, siptag_header_v((x))

/** Tag for header string */
SOFIAPUBVAR tag_typedef_t siptag_header;

#define SIPTAG_HEADER_REF(x)   siptag_header_ref, siptag_header_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_header_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_header_v(sip_header_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_header_vr(sip_header_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_header_v(v)   (tag_value_t)(v)
#define siptag_header_vr(vp) (tag_value_t)(vp)
#endif

/**Tag list item for header string.
 *
 * Macro is used to include a tag item containing an unknown extension
 * header in the tag list, e.g.,
 * @code
 * SIPTAG_HEADER_STR("Remote-Party-ID: +358718008000")
 * @endcode
 *
 * It is also possible to include multiple headers at once
 * @code
 * SIPTAG_HEADER_STR("P-Access-Network-Info: IEEE-802.11g;"
 *                   "    access-point-id=00:11:5C:34:E5:C0\r\n"
 "                   "P-Visited-Network-ID: other.net\r\n")
 * @endcode
 *
 * (See @RFC3455 for more information about these headers.)
 *
 * @param s pointer to a string, or NULL.
 *
 * The corresponding tag item taking reference parameter is
 * SIPTAG_HEADER_STR_REF().
 *
 * @HIDE
 */
#define SIPTAG_HEADER_STR(s)       siptag_header_str, tag_str_v((s))

/** Tag for header string */
SOFIAPUBVAR tag_typedef_t siptag_header_str;

#define SIPTAG_HEADER_STR_REF(s)   siptag_header_str_ref, tag_str_vr(&(s))
SOFIAPUBVAR tag_typedef_t siptag_header_str_ref;

/**@ingroup sip_request
 *
 * Tag list item for pointer to a @ref sip_request "request line"
 * structure #sip_request_t.
 *
 * The SIPTAG_REQUEST() macro is used to include a tag item with a
 * pointer to a #sip_request_t structure in a tag list.
 *
 * @param x pointer to a #sip_request_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REQUEST_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REQUEST(x) siptag_request, siptag_request_v(x)

SOFIAPUBVAR tag_typedef_t siptag_request;

/**@ingroup sip_request
 * Tag list item for reference to a 
 * @ref sip_request "request line" pointer.
 */
#define SIPTAG_REQUEST_REF(x) siptag_request_ref, siptag_request_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_request_ref;

/**@ingroup sip_request
 *
 * Tag list item for string with @ref sip_request "request line" value.
 *
 * The SIPTAG_REQUEST_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_request_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_request "request line" value, or NULL.
 *
 * The string in SIPTAG_REQUEST_STR() can be converted to a
 * #sip_request_t header structure by giving the string @a s has
 * second argument to function sip_request_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REQUEST_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REQUEST_STR(s) siptag_request_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_request_str;

/**@ingroup sip_request
 * Tag list item for reference to a
 * @ref sip_request "request line" string.
 */
#define SIPTAG_REQUEST_STR_REF(x) siptag_request_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_request_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_request_v(sip_request_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_request_vr(sip_request_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_request_v(v)   (tag_value_t)(v)
#define siptag_request_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_status
 *
 * Tag list item for pointer to a @ref sip_status "status line"
 * structure #sip_status_t.
 *
 * The SIPTAG_STATUS() macro is used to include a tag item with a
 * pointer to a #sip_status_t structure in a tag list.
 *
 * @param x pointer to a #sip_status_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_STATUS_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_STATUS(x) siptag_status, siptag_status_v(x)

SOFIAPUBVAR tag_typedef_t siptag_status;

/**@ingroup sip_status
 * Tag list item for reference to a 
 * @ref sip_status "status line" pointer.
 */
#define SIPTAG_STATUS_REF(x) siptag_status_ref, siptag_status_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_status_ref;

/**@ingroup sip_status
 *
 * Tag list item for string with @ref sip_status "status line" value.
 *
 * The SIPTAG_STATUS_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_status_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_status "status line" value, or NULL.
 *
 * The string in SIPTAG_STATUS_STR() can be converted to a
 * #sip_status_t header structure by giving the string @a s has
 * second argument to function sip_status_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_STATUS_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_STATUS_STR(s) siptag_status_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_status_str;

/**@ingroup sip_status
 * Tag list item for reference to a
 * @ref sip_status "status line" string.
 */
#define SIPTAG_STATUS_STR_REF(x) siptag_status_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_status_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_status_v(sip_status_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_status_vr(sip_status_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_status_v(v)   (tag_value_t)(v)
#define siptag_status_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_via
 *
 * Tag list item for pointer to a @ref sip_via "Via header"
 * structure #sip_via_t.
 *
 * The SIPTAG_VIA() macro is used to include a tag item with a
 * pointer to a #sip_via_t structure in a tag list.
 *
 * @param x pointer to a #sip_via_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_VIA_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_VIA(x) siptag_via, siptag_via_v(x)

SOFIAPUBVAR tag_typedef_t siptag_via;

/**@ingroup sip_via
 * Tag list item for reference to a 
 * @ref sip_via "Via header" pointer.
 */
#define SIPTAG_VIA_REF(x) siptag_via_ref, siptag_via_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_via_ref;

/**@ingroup sip_via
 *
 * Tag list item for string with @ref sip_via "Via header" value.
 *
 * The SIPTAG_VIA_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_via_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_via "Via header" value, or NULL.
 *
 * The string in SIPTAG_VIA_STR() can be converted to a
 * #sip_via_t header structure by giving the string @a s has
 * second argument to function sip_via_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_VIA_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_VIA_STR(s) siptag_via_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_via_str;

/**@ingroup sip_via
 * Tag list item for reference to a
 * @ref sip_via "Via header" string.
 */
#define SIPTAG_VIA_STR_REF(x) siptag_via_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_via_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_via_v(sip_via_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_via_vr(sip_via_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_via_v(v)   (tag_value_t)(v)
#define siptag_via_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_route
 *
 * Tag list item for pointer to a @ref sip_route "Route header"
 * structure #sip_route_t.
 *
 * The SIPTAG_ROUTE() macro is used to include a tag item with a
 * pointer to a #sip_route_t structure in a tag list.
 *
 * @param x pointer to a #sip_route_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ROUTE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ROUTE(x) siptag_route, siptag_route_v(x)

SOFIAPUBVAR tag_typedef_t siptag_route;

/**@ingroup sip_route
 * Tag list item for reference to a 
 * @ref sip_route "Route header" pointer.
 */
#define SIPTAG_ROUTE_REF(x) siptag_route_ref, siptag_route_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_route_ref;

/**@ingroup sip_route
 *
 * Tag list item for string with @ref sip_route "Route header" value.
 *
 * The SIPTAG_ROUTE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_route_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_route "Route header" value, or NULL.
 *
 * The string in SIPTAG_ROUTE_STR() can be converted to a
 * #sip_route_t header structure by giving the string @a s has
 * second argument to function sip_route_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ROUTE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ROUTE_STR(s) siptag_route_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_route_str;

/**@ingroup sip_route
 * Tag list item for reference to a
 * @ref sip_route "Route header" string.
 */
#define SIPTAG_ROUTE_STR_REF(x) siptag_route_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_route_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_route_v(sip_route_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_route_vr(sip_route_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_route_v(v)   (tag_value_t)(v)
#define siptag_route_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_record_route
 *
 * Tag list item for pointer to a @ref sip_record_route "Record-Route header"
 * structure #sip_record_route_t.
 *
 * The SIPTAG_RECORD_ROUTE() macro is used to include a tag item with a
 * pointer to a #sip_record_route_t structure in a tag list.
 *
 * @param x pointer to a #sip_record_route_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_RECORD_ROUTE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_RECORD_ROUTE(x) siptag_record_route, siptag_record_route_v(x)

SOFIAPUBVAR tag_typedef_t siptag_record_route;

/**@ingroup sip_record_route
 * Tag list item for reference to a 
 * @ref sip_record_route "Record-Route header" pointer.
 */
#define SIPTAG_RECORD_ROUTE_REF(x) siptag_record_route_ref, siptag_record_route_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_record_route_ref;

/**@ingroup sip_record_route
 *
 * Tag list item for string with @ref sip_record_route "Record-Route header" value.
 *
 * The SIPTAG_RECORD_ROUTE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_record_route_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_record_route "Record-Route header" value, or NULL.
 *
 * The string in SIPTAG_RECORD_ROUTE_STR() can be converted to a
 * #sip_record_route_t header structure by giving the string @a s has
 * second argument to function sip_record_route_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_RECORD_ROUTE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_RECORD_ROUTE_STR(s) siptag_record_route_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_record_route_str;

/**@ingroup sip_record_route
 * Tag list item for reference to a
 * @ref sip_record_route "Record-Route header" string.
 */
#define SIPTAG_RECORD_ROUTE_STR_REF(x) siptag_record_route_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_record_route_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_record_route_v(sip_record_route_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_record_route_vr(sip_record_route_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_record_route_v(v)   (tag_value_t)(v)
#define siptag_record_route_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_max_forwards
 *
 * Tag list item for pointer to a @ref sip_max_forwards "Max-Forwards header"
 * structure #sip_max_forwards_t.
 *
 * The SIPTAG_MAX_FORWARDS() macro is used to include a tag item with a
 * pointer to a #sip_max_forwards_t structure in a tag list.
 *
 * @param x pointer to a #sip_max_forwards_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_MAX_FORWARDS_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_MAX_FORWARDS(x) siptag_max_forwards, siptag_max_forwards_v(x)

SOFIAPUBVAR tag_typedef_t siptag_max_forwards;

/**@ingroup sip_max_forwards
 * Tag list item for reference to a 
 * @ref sip_max_forwards "Max-Forwards header" pointer.
 */
#define SIPTAG_MAX_FORWARDS_REF(x) siptag_max_forwards_ref, siptag_max_forwards_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_max_forwards_ref;

/**@ingroup sip_max_forwards
 *
 * Tag list item for string with @ref sip_max_forwards "Max-Forwards header" value.
 *
 * The SIPTAG_MAX_FORWARDS_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_max_forwards_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_max_forwards "Max-Forwards header" value, or NULL.
 *
 * The string in SIPTAG_MAX_FORWARDS_STR() can be converted to a
 * #sip_max_forwards_t header structure by giving the string @a s has
 * second argument to function sip_max_forwards_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_MAX_FORWARDS_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_MAX_FORWARDS_STR(s) siptag_max_forwards_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_max_forwards_str;

/**@ingroup sip_max_forwards
 * Tag list item for reference to a
 * @ref sip_max_forwards "Max-Forwards header" string.
 */
#define SIPTAG_MAX_FORWARDS_STR_REF(x) siptag_max_forwards_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_max_forwards_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_max_forwards_v(sip_max_forwards_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_max_forwards_vr(sip_max_forwards_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_max_forwards_v(v)   (tag_value_t)(v)
#define siptag_max_forwards_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_proxy_require
 *
 * Tag list item for pointer to a @ref sip_proxy_require "Proxy-Require header"
 * structure #sip_proxy_require_t.
 *
 * The SIPTAG_PROXY_REQUIRE() macro is used to include a tag item with a
 * pointer to a #sip_proxy_require_t structure in a tag list.
 *
 * @param x pointer to a #sip_proxy_require_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PROXY_REQUIRE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PROXY_REQUIRE(x) siptag_proxy_require, siptag_proxy_require_v(x)

SOFIAPUBVAR tag_typedef_t siptag_proxy_require;

/**@ingroup sip_proxy_require
 * Tag list item for reference to a 
 * @ref sip_proxy_require "Proxy-Require header" pointer.
 */
#define SIPTAG_PROXY_REQUIRE_REF(x) siptag_proxy_require_ref, siptag_proxy_require_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_proxy_require_ref;

/**@ingroup sip_proxy_require
 *
 * Tag list item for string with @ref sip_proxy_require "Proxy-Require header" value.
 *
 * The SIPTAG_PROXY_REQUIRE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_proxy_require_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_proxy_require "Proxy-Require header" value, or NULL.
 *
 * The string in SIPTAG_PROXY_REQUIRE_STR() can be converted to a
 * #sip_proxy_require_t header structure by giving the string @a s has
 * second argument to function sip_proxy_require_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PROXY_REQUIRE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PROXY_REQUIRE_STR(s) siptag_proxy_require_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_proxy_require_str;

/**@ingroup sip_proxy_require
 * Tag list item for reference to a
 * @ref sip_proxy_require "Proxy-Require header" string.
 */
#define SIPTAG_PROXY_REQUIRE_STR_REF(x) siptag_proxy_require_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_proxy_require_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_proxy_require_v(sip_proxy_require_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_proxy_require_vr(sip_proxy_require_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_proxy_require_v(v)   (tag_value_t)(v)
#define siptag_proxy_require_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_from
 *
 * Tag list item for pointer to a @ref sip_from "From header"
 * structure #sip_from_t.
 *
 * The SIPTAG_FROM() macro is used to include a tag item with a
 * pointer to a #sip_from_t structure in a tag list.
 *
 * @param x pointer to a #sip_from_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_FROM_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_FROM(x) siptag_from, siptag_from_v(x)

SOFIAPUBVAR tag_typedef_t siptag_from;

/**@ingroup sip_from
 * Tag list item for reference to a 
 * @ref sip_from "From header" pointer.
 */
#define SIPTAG_FROM_REF(x) siptag_from_ref, siptag_from_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_from_ref;

/**@ingroup sip_from
 *
 * Tag list item for string with @ref sip_from "From header" value.
 *
 * The SIPTAG_FROM_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_from_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_from "From header" value, or NULL.
 *
 * The string in SIPTAG_FROM_STR() can be converted to a
 * #sip_from_t header structure by giving the string @a s has
 * second argument to function sip_from_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_FROM_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_FROM_STR(s) siptag_from_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_from_str;

/**@ingroup sip_from
 * Tag list item for reference to a
 * @ref sip_from "From header" string.
 */
#define SIPTAG_FROM_STR_REF(x) siptag_from_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_from_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_from_v(sip_from_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_from_vr(sip_from_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_from_v(v)   (tag_value_t)(v)
#define siptag_from_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_to
 *
 * Tag list item for pointer to a @ref sip_to "To header"
 * structure #sip_to_t.
 *
 * The SIPTAG_TO() macro is used to include a tag item with a
 * pointer to a #sip_to_t structure in a tag list.
 *
 * @param x pointer to a #sip_to_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_TO_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_TO(x) siptag_to, siptag_to_v(x)

SOFIAPUBVAR tag_typedef_t siptag_to;

/**@ingroup sip_to
 * Tag list item for reference to a 
 * @ref sip_to "To header" pointer.
 */
#define SIPTAG_TO_REF(x) siptag_to_ref, siptag_to_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_to_ref;

/**@ingroup sip_to
 *
 * Tag list item for string with @ref sip_to "To header" value.
 *
 * The SIPTAG_TO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_to_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_to "To header" value, or NULL.
 *
 * The string in SIPTAG_TO_STR() can be converted to a
 * #sip_to_t header structure by giving the string @a s has
 * second argument to function sip_to_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_TO_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_TO_STR(s) siptag_to_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_to_str;

/**@ingroup sip_to
 * Tag list item for reference to a
 * @ref sip_to "To header" string.
 */
#define SIPTAG_TO_STR_REF(x) siptag_to_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_to_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_to_v(sip_to_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_to_vr(sip_to_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_to_v(v)   (tag_value_t)(v)
#define siptag_to_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_call_id
 *
 * Tag list item for pointer to a @ref sip_call_id "Call-ID header"
 * structure #sip_call_id_t.
 *
 * The SIPTAG_CALL_ID() macro is used to include a tag item with a
 * pointer to a #sip_call_id_t structure in a tag list.
 *
 * @param x pointer to a #sip_call_id_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CALL_ID_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CALL_ID(x) siptag_call_id, siptag_call_id_v(x)

SOFIAPUBVAR tag_typedef_t siptag_call_id;

/**@ingroup sip_call_id
 * Tag list item for reference to a 
 * @ref sip_call_id "Call-ID header" pointer.
 */
#define SIPTAG_CALL_ID_REF(x) siptag_call_id_ref, siptag_call_id_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_call_id_ref;

/**@ingroup sip_call_id
 *
 * Tag list item for string with @ref sip_call_id "Call-ID header" value.
 *
 * The SIPTAG_CALL_ID_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_call_id_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_call_id "Call-ID header" value, or NULL.
 *
 * The string in SIPTAG_CALL_ID_STR() can be converted to a
 * #sip_call_id_t header structure by giving the string @a s has
 * second argument to function sip_call_id_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CALL_ID_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CALL_ID_STR(s) siptag_call_id_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_call_id_str;

/**@ingroup sip_call_id
 * Tag list item for reference to a
 * @ref sip_call_id "Call-ID header" string.
 */
#define SIPTAG_CALL_ID_STR_REF(x) siptag_call_id_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_call_id_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_call_id_v(sip_call_id_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_call_id_vr(sip_call_id_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_call_id_v(v)   (tag_value_t)(v)
#define siptag_call_id_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_cseq
 *
 * Tag list item for pointer to a @ref sip_cseq "CSeq header"
 * structure #sip_cseq_t.
 *
 * The SIPTAG_CSEQ() macro is used to include a tag item with a
 * pointer to a #sip_cseq_t structure in a tag list.
 *
 * @param x pointer to a #sip_cseq_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CSEQ_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CSEQ(x) siptag_cseq, siptag_cseq_v(x)

SOFIAPUBVAR tag_typedef_t siptag_cseq;

/**@ingroup sip_cseq
 * Tag list item for reference to a 
 * @ref sip_cseq "CSeq header" pointer.
 */
#define SIPTAG_CSEQ_REF(x) siptag_cseq_ref, siptag_cseq_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_cseq_ref;

/**@ingroup sip_cseq
 *
 * Tag list item for string with @ref sip_cseq "CSeq header" value.
 *
 * The SIPTAG_CSEQ_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_cseq_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_cseq "CSeq header" value, or NULL.
 *
 * The string in SIPTAG_CSEQ_STR() can be converted to a
 * #sip_cseq_t header structure by giving the string @a s has
 * second argument to function sip_cseq_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CSEQ_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CSEQ_STR(s) siptag_cseq_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_cseq_str;

/**@ingroup sip_cseq
 * Tag list item for reference to a
 * @ref sip_cseq "CSeq header" string.
 */
#define SIPTAG_CSEQ_STR_REF(x) siptag_cseq_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_cseq_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_cseq_v(sip_cseq_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_cseq_vr(sip_cseq_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_cseq_v(v)   (tag_value_t)(v)
#define siptag_cseq_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_contact
 *
 * Tag list item for pointer to a @ref sip_contact "Contact header"
 * structure #sip_contact_t.
 *
 * The SIPTAG_CONTACT() macro is used to include a tag item with a
 * pointer to a #sip_contact_t structure in a tag list.
 *
 * @param x pointer to a #sip_contact_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTACT_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTACT(x) siptag_contact, siptag_contact_v(x)

SOFIAPUBVAR tag_typedef_t siptag_contact;

/**@ingroup sip_contact
 * Tag list item for reference to a 
 * @ref sip_contact "Contact header" pointer.
 */
#define SIPTAG_CONTACT_REF(x) siptag_contact_ref, siptag_contact_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_contact_ref;

/**@ingroup sip_contact
 *
 * Tag list item for string with @ref sip_contact "Contact header" value.
 *
 * The SIPTAG_CONTACT_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_contact_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_contact "Contact header" value, or NULL.
 *
 * The string in SIPTAG_CONTACT_STR() can be converted to a
 * #sip_contact_t header structure by giving the string @a s has
 * second argument to function sip_contact_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTACT_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTACT_STR(s) siptag_contact_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_contact_str;

/**@ingroup sip_contact
 * Tag list item for reference to a
 * @ref sip_contact "Contact header" string.
 */
#define SIPTAG_CONTACT_STR_REF(x) siptag_contact_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_contact_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_contact_v(sip_contact_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_contact_vr(sip_contact_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_contact_v(v)   (tag_value_t)(v)
#define siptag_contact_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_rseq
 *
 * Tag list item for pointer to a @ref sip_rseq "RSeq header"
 * structure #sip_rseq_t.
 *
 * The SIPTAG_RSEQ() macro is used to include a tag item with a
 * pointer to a #sip_rseq_t structure in a tag list.
 *
 * @param x pointer to a #sip_rseq_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_RSEQ_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_RSEQ(x) siptag_rseq, siptag_rseq_v(x)

SOFIAPUBVAR tag_typedef_t siptag_rseq;

/**@ingroup sip_rseq
 * Tag list item for reference to a 
 * @ref sip_rseq "RSeq header" pointer.
 */
#define SIPTAG_RSEQ_REF(x) siptag_rseq_ref, siptag_rseq_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_rseq_ref;

/**@ingroup sip_rseq
 *
 * Tag list item for string with @ref sip_rseq "RSeq header" value.
 *
 * The SIPTAG_RSEQ_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_rseq_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_rseq "RSeq header" value, or NULL.
 *
 * The string in SIPTAG_RSEQ_STR() can be converted to a
 * #sip_rseq_t header structure by giving the string @a s has
 * second argument to function sip_rseq_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_RSEQ_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_RSEQ_STR(s) siptag_rseq_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_rseq_str;

/**@ingroup sip_rseq
 * Tag list item for reference to a
 * @ref sip_rseq "RSeq header" string.
 */
#define SIPTAG_RSEQ_STR_REF(x) siptag_rseq_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_rseq_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_rseq_v(sip_rseq_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_rseq_vr(sip_rseq_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_rseq_v(v)   (tag_value_t)(v)
#define siptag_rseq_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_rack
 *
 * Tag list item for pointer to a @ref sip_rack "RAck header"
 * structure #sip_rack_t.
 *
 * The SIPTAG_RACK() macro is used to include a tag item with a
 * pointer to a #sip_rack_t structure in a tag list.
 *
 * @param x pointer to a #sip_rack_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_RACK_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_RACK(x) siptag_rack, siptag_rack_v(x)

SOFIAPUBVAR tag_typedef_t siptag_rack;

/**@ingroup sip_rack
 * Tag list item for reference to a 
 * @ref sip_rack "RAck header" pointer.
 */
#define SIPTAG_RACK_REF(x) siptag_rack_ref, siptag_rack_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_rack_ref;

/**@ingroup sip_rack
 *
 * Tag list item for string with @ref sip_rack "RAck header" value.
 *
 * The SIPTAG_RACK_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_rack_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_rack "RAck header" value, or NULL.
 *
 * The string in SIPTAG_RACK_STR() can be converted to a
 * #sip_rack_t header structure by giving the string @a s has
 * second argument to function sip_rack_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_RACK_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_RACK_STR(s) siptag_rack_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_rack_str;

/**@ingroup sip_rack
 * Tag list item for reference to a
 * @ref sip_rack "RAck header" string.
 */
#define SIPTAG_RACK_STR_REF(x) siptag_rack_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_rack_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_rack_v(sip_rack_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_rack_vr(sip_rack_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_rack_v(v)   (tag_value_t)(v)
#define siptag_rack_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_request_disposition
 *
 * Tag list item for pointer to a @ref sip_request_disposition "Request-Disposition header"
 * structure #sip_request_disposition_t.
 *
 * The SIPTAG_REQUEST_DISPOSITION() macro is used to include a tag item with a
 * pointer to a #sip_request_disposition_t structure in a tag list.
 *
 * @param x pointer to a #sip_request_disposition_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REQUEST_DISPOSITION_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REQUEST_DISPOSITION(x) siptag_request_disposition, siptag_request_disposition_v(x)

SOFIAPUBVAR tag_typedef_t siptag_request_disposition;

/**@ingroup sip_request_disposition
 * Tag list item for reference to a 
 * @ref sip_request_disposition "Request-Disposition header" pointer.
 */
#define SIPTAG_REQUEST_DISPOSITION_REF(x) siptag_request_disposition_ref, siptag_request_disposition_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_request_disposition_ref;

/**@ingroup sip_request_disposition
 *
 * Tag list item for string with @ref sip_request_disposition "Request-Disposition header" value.
 *
 * The SIPTAG_REQUEST_DISPOSITION_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_request_disposition_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_request_disposition "Request-Disposition header" value, or NULL.
 *
 * The string in SIPTAG_REQUEST_DISPOSITION_STR() can be converted to a
 * #sip_request_disposition_t header structure by giving the string @a s has
 * second argument to function sip_request_disposition_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REQUEST_DISPOSITION_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REQUEST_DISPOSITION_STR(s) siptag_request_disposition_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_request_disposition_str;

/**@ingroup sip_request_disposition
 * Tag list item for reference to a
 * @ref sip_request_disposition "Request-Disposition header" string.
 */
#define SIPTAG_REQUEST_DISPOSITION_STR_REF(x) siptag_request_disposition_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_request_disposition_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_request_disposition_v(sip_request_disposition_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_request_disposition_vr(sip_request_disposition_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_request_disposition_v(v)   (tag_value_t)(v)
#define siptag_request_disposition_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_accept_contact
 *
 * Tag list item for pointer to a @ref sip_accept_contact "Accept-Contact header"
 * structure #sip_accept_contact_t.
 *
 * The SIPTAG_ACCEPT_CONTACT() macro is used to include a tag item with a
 * pointer to a #sip_accept_contact_t structure in a tag list.
 *
 * @param x pointer to a #sip_accept_contact_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ACCEPT_CONTACT_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ACCEPT_CONTACT(x) siptag_accept_contact, siptag_accept_contact_v(x)

SOFIAPUBVAR tag_typedef_t siptag_accept_contact;

/**@ingroup sip_accept_contact
 * Tag list item for reference to a 
 * @ref sip_accept_contact "Accept-Contact header" pointer.
 */
#define SIPTAG_ACCEPT_CONTACT_REF(x) siptag_accept_contact_ref, siptag_accept_contact_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_accept_contact_ref;

/**@ingroup sip_accept_contact
 *
 * Tag list item for string with @ref sip_accept_contact "Accept-Contact header" value.
 *
 * The SIPTAG_ACCEPT_CONTACT_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_accept_contact_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_accept_contact "Accept-Contact header" value, or NULL.
 *
 * The string in SIPTAG_ACCEPT_CONTACT_STR() can be converted to a
 * #sip_accept_contact_t header structure by giving the string @a s has
 * second argument to function sip_accept_contact_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ACCEPT_CONTACT_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ACCEPT_CONTACT_STR(s) siptag_accept_contact_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_accept_contact_str;

/**@ingroup sip_accept_contact
 * Tag list item for reference to a
 * @ref sip_accept_contact "Accept-Contact header" string.
 */
#define SIPTAG_ACCEPT_CONTACT_STR_REF(x) siptag_accept_contact_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_accept_contact_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_accept_contact_v(sip_accept_contact_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_accept_contact_vr(sip_accept_contact_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_accept_contact_v(v)   (tag_value_t)(v)
#define siptag_accept_contact_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_reject_contact
 *
 * Tag list item for pointer to a @ref sip_reject_contact "Reject-Contact header"
 * structure #sip_reject_contact_t.
 *
 * The SIPTAG_REJECT_CONTACT() macro is used to include a tag item with a
 * pointer to a #sip_reject_contact_t structure in a tag list.
 *
 * @param x pointer to a #sip_reject_contact_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REJECT_CONTACT_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REJECT_CONTACT(x) siptag_reject_contact, siptag_reject_contact_v(x)

SOFIAPUBVAR tag_typedef_t siptag_reject_contact;

/**@ingroup sip_reject_contact
 * Tag list item for reference to a 
 * @ref sip_reject_contact "Reject-Contact header" pointer.
 */
#define SIPTAG_REJECT_CONTACT_REF(x) siptag_reject_contact_ref, siptag_reject_contact_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_reject_contact_ref;

/**@ingroup sip_reject_contact
 *
 * Tag list item for string with @ref sip_reject_contact "Reject-Contact header" value.
 *
 * The SIPTAG_REJECT_CONTACT_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_reject_contact_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_reject_contact "Reject-Contact header" value, or NULL.
 *
 * The string in SIPTAG_REJECT_CONTACT_STR() can be converted to a
 * #sip_reject_contact_t header structure by giving the string @a s has
 * second argument to function sip_reject_contact_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REJECT_CONTACT_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REJECT_CONTACT_STR(s) siptag_reject_contact_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_reject_contact_str;

/**@ingroup sip_reject_contact
 * Tag list item for reference to a
 * @ref sip_reject_contact "Reject-Contact header" string.
 */
#define SIPTAG_REJECT_CONTACT_STR_REF(x) siptag_reject_contact_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_reject_contact_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_reject_contact_v(sip_reject_contact_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_reject_contact_vr(sip_reject_contact_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_reject_contact_v(v)   (tag_value_t)(v)
#define siptag_reject_contact_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_expires
 *
 * Tag list item for pointer to a @ref sip_expires "Expires header"
 * structure #sip_expires_t.
 *
 * The SIPTAG_EXPIRES() macro is used to include a tag item with a
 * pointer to a #sip_expires_t structure in a tag list.
 *
 * @param x pointer to a #sip_expires_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_EXPIRES_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_EXPIRES(x) siptag_expires, siptag_expires_v(x)

SOFIAPUBVAR tag_typedef_t siptag_expires;

/**@ingroup sip_expires
 * Tag list item for reference to a 
 * @ref sip_expires "Expires header" pointer.
 */
#define SIPTAG_EXPIRES_REF(x) siptag_expires_ref, siptag_expires_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_expires_ref;

/**@ingroup sip_expires
 *
 * Tag list item for string with @ref sip_expires "Expires header" value.
 *
 * The SIPTAG_EXPIRES_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_expires_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_expires "Expires header" value, or NULL.
 *
 * The string in SIPTAG_EXPIRES_STR() can be converted to a
 * #sip_expires_t header structure by giving the string @a s has
 * second argument to function sip_expires_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_EXPIRES_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_EXPIRES_STR(s) siptag_expires_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_expires_str;

/**@ingroup sip_expires
 * Tag list item for reference to a
 * @ref sip_expires "Expires header" string.
 */
#define SIPTAG_EXPIRES_STR_REF(x) siptag_expires_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_expires_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_expires_v(sip_expires_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_expires_vr(sip_expires_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_expires_v(v)   (tag_value_t)(v)
#define siptag_expires_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_date
 *
 * Tag list item for pointer to a @ref sip_date "Date header"
 * structure #sip_date_t.
 *
 * The SIPTAG_DATE() macro is used to include a tag item with a
 * pointer to a #sip_date_t structure in a tag list.
 *
 * @param x pointer to a #sip_date_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_DATE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_DATE(x) siptag_date, siptag_date_v(x)

SOFIAPUBVAR tag_typedef_t siptag_date;

/**@ingroup sip_date
 * Tag list item for reference to a 
 * @ref sip_date "Date header" pointer.
 */
#define SIPTAG_DATE_REF(x) siptag_date_ref, siptag_date_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_date_ref;

/**@ingroup sip_date
 *
 * Tag list item for string with @ref sip_date "Date header" value.
 *
 * The SIPTAG_DATE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_date_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_date "Date header" value, or NULL.
 *
 * The string in SIPTAG_DATE_STR() can be converted to a
 * #sip_date_t header structure by giving the string @a s has
 * second argument to function sip_date_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_DATE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_DATE_STR(s) siptag_date_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_date_str;

/**@ingroup sip_date
 * Tag list item for reference to a
 * @ref sip_date "Date header" string.
 */
#define SIPTAG_DATE_STR_REF(x) siptag_date_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_date_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_date_v(sip_date_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_date_vr(sip_date_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_date_v(v)   (tag_value_t)(v)
#define siptag_date_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_retry_after
 *
 * Tag list item for pointer to a @ref sip_retry_after "Retry-After header"
 * structure #sip_retry_after_t.
 *
 * The SIPTAG_RETRY_AFTER() macro is used to include a tag item with a
 * pointer to a #sip_retry_after_t structure in a tag list.
 *
 * @param x pointer to a #sip_retry_after_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_RETRY_AFTER_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_RETRY_AFTER(x) siptag_retry_after, siptag_retry_after_v(x)

SOFIAPUBVAR tag_typedef_t siptag_retry_after;

/**@ingroup sip_retry_after
 * Tag list item for reference to a 
 * @ref sip_retry_after "Retry-After header" pointer.
 */
#define SIPTAG_RETRY_AFTER_REF(x) siptag_retry_after_ref, siptag_retry_after_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_retry_after_ref;

/**@ingroup sip_retry_after
 *
 * Tag list item for string with @ref sip_retry_after "Retry-After header" value.
 *
 * The SIPTAG_RETRY_AFTER_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_retry_after_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_retry_after "Retry-After header" value, or NULL.
 *
 * The string in SIPTAG_RETRY_AFTER_STR() can be converted to a
 * #sip_retry_after_t header structure by giving the string @a s has
 * second argument to function sip_retry_after_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_RETRY_AFTER_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_RETRY_AFTER_STR(s) siptag_retry_after_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_retry_after_str;

/**@ingroup sip_retry_after
 * Tag list item for reference to a
 * @ref sip_retry_after "Retry-After header" string.
 */
#define SIPTAG_RETRY_AFTER_STR_REF(x) siptag_retry_after_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_retry_after_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_retry_after_v(sip_retry_after_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_retry_after_vr(sip_retry_after_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_retry_after_v(v)   (tag_value_t)(v)
#define siptag_retry_after_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_timestamp
 *
 * Tag list item for pointer to a @ref sip_timestamp "Timestamp header"
 * structure #sip_timestamp_t.
 *
 * The SIPTAG_TIMESTAMP() macro is used to include a tag item with a
 * pointer to a #sip_timestamp_t structure in a tag list.
 *
 * @param x pointer to a #sip_timestamp_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_TIMESTAMP_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_TIMESTAMP(x) siptag_timestamp, siptag_timestamp_v(x)

SOFIAPUBVAR tag_typedef_t siptag_timestamp;

/**@ingroup sip_timestamp
 * Tag list item for reference to a 
 * @ref sip_timestamp "Timestamp header" pointer.
 */
#define SIPTAG_TIMESTAMP_REF(x) siptag_timestamp_ref, siptag_timestamp_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_timestamp_ref;

/**@ingroup sip_timestamp
 *
 * Tag list item for string with @ref sip_timestamp "Timestamp header" value.
 *
 * The SIPTAG_TIMESTAMP_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_timestamp_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_timestamp "Timestamp header" value, or NULL.
 *
 * The string in SIPTAG_TIMESTAMP_STR() can be converted to a
 * #sip_timestamp_t header structure by giving the string @a s has
 * second argument to function sip_timestamp_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_TIMESTAMP_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_TIMESTAMP_STR(s) siptag_timestamp_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_timestamp_str;

/**@ingroup sip_timestamp
 * Tag list item for reference to a
 * @ref sip_timestamp "Timestamp header" string.
 */
#define SIPTAG_TIMESTAMP_STR_REF(x) siptag_timestamp_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_timestamp_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_timestamp_v(sip_timestamp_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_timestamp_vr(sip_timestamp_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_timestamp_v(v)   (tag_value_t)(v)
#define siptag_timestamp_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_min_expires
 *
 * Tag list item for pointer to a @ref sip_min_expires "Min-Expires header"
 * structure #sip_min_expires_t.
 *
 * The SIPTAG_MIN_EXPIRES() macro is used to include a tag item with a
 * pointer to a #sip_min_expires_t structure in a tag list.
 *
 * @param x pointer to a #sip_min_expires_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_MIN_EXPIRES_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_MIN_EXPIRES(x) siptag_min_expires, siptag_min_expires_v(x)

SOFIAPUBVAR tag_typedef_t siptag_min_expires;

/**@ingroup sip_min_expires
 * Tag list item for reference to a 
 * @ref sip_min_expires "Min-Expires header" pointer.
 */
#define SIPTAG_MIN_EXPIRES_REF(x) siptag_min_expires_ref, siptag_min_expires_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_min_expires_ref;

/**@ingroup sip_min_expires
 *
 * Tag list item for string with @ref sip_min_expires "Min-Expires header" value.
 *
 * The SIPTAG_MIN_EXPIRES_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_min_expires_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_min_expires "Min-Expires header" value, or NULL.
 *
 * The string in SIPTAG_MIN_EXPIRES_STR() can be converted to a
 * #sip_min_expires_t header structure by giving the string @a s has
 * second argument to function sip_min_expires_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_MIN_EXPIRES_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_MIN_EXPIRES_STR(s) siptag_min_expires_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_min_expires_str;

/**@ingroup sip_min_expires
 * Tag list item for reference to a
 * @ref sip_min_expires "Min-Expires header" string.
 */
#define SIPTAG_MIN_EXPIRES_STR_REF(x) siptag_min_expires_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_min_expires_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_min_expires_v(sip_min_expires_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_min_expires_vr(sip_min_expires_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_min_expires_v(v)   (tag_value_t)(v)
#define siptag_min_expires_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_subject
 *
 * Tag list item for pointer to a @ref sip_subject "Subject header"
 * structure #sip_subject_t.
 *
 * The SIPTAG_SUBJECT() macro is used to include a tag item with a
 * pointer to a #sip_subject_t structure in a tag list.
 *
 * @param x pointer to a #sip_subject_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUBJECT_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SUBJECT(x) siptag_subject, siptag_subject_v(x)

SOFIAPUBVAR tag_typedef_t siptag_subject;

/**@ingroup sip_subject
 * Tag list item for reference to a 
 * @ref sip_subject "Subject header" pointer.
 */
#define SIPTAG_SUBJECT_REF(x) siptag_subject_ref, siptag_subject_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_subject_ref;

/**@ingroup sip_subject
 *
 * Tag list item for string with @ref sip_subject "Subject header" value.
 *
 * The SIPTAG_SUBJECT_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_subject_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_subject "Subject header" value, or NULL.
 *
 * The string in SIPTAG_SUBJECT_STR() can be converted to a
 * #sip_subject_t header structure by giving the string @a s has
 * second argument to function sip_subject_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUBJECT_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SUBJECT_STR(s) siptag_subject_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_subject_str;

/**@ingroup sip_subject
 * Tag list item for reference to a
 * @ref sip_subject "Subject header" string.
 */
#define SIPTAG_SUBJECT_STR_REF(x) siptag_subject_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_subject_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_subject_v(sip_subject_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_subject_vr(sip_subject_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_subject_v(v)   (tag_value_t)(v)
#define siptag_subject_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_priority
 *
 * Tag list item for pointer to a @ref sip_priority "Priority header"
 * structure #sip_priority_t.
 *
 * The SIPTAG_PRIORITY() macro is used to include a tag item with a
 * pointer to a #sip_priority_t structure in a tag list.
 *
 * @param x pointer to a #sip_priority_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PRIORITY_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PRIORITY(x) siptag_priority, siptag_priority_v(x)

SOFIAPUBVAR tag_typedef_t siptag_priority;

/**@ingroup sip_priority
 * Tag list item for reference to a 
 * @ref sip_priority "Priority header" pointer.
 */
#define SIPTAG_PRIORITY_REF(x) siptag_priority_ref, siptag_priority_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_priority_ref;

/**@ingroup sip_priority
 *
 * Tag list item for string with @ref sip_priority "Priority header" value.
 *
 * The SIPTAG_PRIORITY_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_priority_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_priority "Priority header" value, or NULL.
 *
 * The string in SIPTAG_PRIORITY_STR() can be converted to a
 * #sip_priority_t header structure by giving the string @a s has
 * second argument to function sip_priority_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PRIORITY_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PRIORITY_STR(s) siptag_priority_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_priority_str;

/**@ingroup sip_priority
 * Tag list item for reference to a
 * @ref sip_priority "Priority header" string.
 */
#define SIPTAG_PRIORITY_STR_REF(x) siptag_priority_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_priority_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_priority_v(sip_priority_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_priority_vr(sip_priority_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_priority_v(v)   (tag_value_t)(v)
#define siptag_priority_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_call_info
 *
 * Tag list item for pointer to a @ref sip_call_info "Call-Info header"
 * structure #sip_call_info_t.
 *
 * The SIPTAG_CALL_INFO() macro is used to include a tag item with a
 * pointer to a #sip_call_info_t structure in a tag list.
 *
 * @param x pointer to a #sip_call_info_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CALL_INFO_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CALL_INFO(x) siptag_call_info, siptag_call_info_v(x)

SOFIAPUBVAR tag_typedef_t siptag_call_info;

/**@ingroup sip_call_info
 * Tag list item for reference to a 
 * @ref sip_call_info "Call-Info header" pointer.
 */
#define SIPTAG_CALL_INFO_REF(x) siptag_call_info_ref, siptag_call_info_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_call_info_ref;

/**@ingroup sip_call_info
 *
 * Tag list item for string with @ref sip_call_info "Call-Info header" value.
 *
 * The SIPTAG_CALL_INFO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_call_info_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_call_info "Call-Info header" value, or NULL.
 *
 * The string in SIPTAG_CALL_INFO_STR() can be converted to a
 * #sip_call_info_t header structure by giving the string @a s has
 * second argument to function sip_call_info_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CALL_INFO_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CALL_INFO_STR(s) siptag_call_info_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_call_info_str;

/**@ingroup sip_call_info
 * Tag list item for reference to a
 * @ref sip_call_info "Call-Info header" string.
 */
#define SIPTAG_CALL_INFO_STR_REF(x) siptag_call_info_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_call_info_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_call_info_v(sip_call_info_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_call_info_vr(sip_call_info_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_call_info_v(v)   (tag_value_t)(v)
#define siptag_call_info_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_organization
 *
 * Tag list item for pointer to a @ref sip_organization "Organization header"
 * structure #sip_organization_t.
 *
 * The SIPTAG_ORGANIZATION() macro is used to include a tag item with a
 * pointer to a #sip_organization_t structure in a tag list.
 *
 * @param x pointer to a #sip_organization_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ORGANIZATION_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ORGANIZATION(x) siptag_organization, siptag_organization_v(x)

SOFIAPUBVAR tag_typedef_t siptag_organization;

/**@ingroup sip_organization
 * Tag list item for reference to a 
 * @ref sip_organization "Organization header" pointer.
 */
#define SIPTAG_ORGANIZATION_REF(x) siptag_organization_ref, siptag_organization_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_organization_ref;

/**@ingroup sip_organization
 *
 * Tag list item for string with @ref sip_organization "Organization header" value.
 *
 * The SIPTAG_ORGANIZATION_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_organization_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_organization "Organization header" value, or NULL.
 *
 * The string in SIPTAG_ORGANIZATION_STR() can be converted to a
 * #sip_organization_t header structure by giving the string @a s has
 * second argument to function sip_organization_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ORGANIZATION_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ORGANIZATION_STR(s) siptag_organization_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_organization_str;

/**@ingroup sip_organization
 * Tag list item for reference to a
 * @ref sip_organization "Organization header" string.
 */
#define SIPTAG_ORGANIZATION_STR_REF(x) siptag_organization_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_organization_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_organization_v(sip_organization_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_organization_vr(sip_organization_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_organization_v(v)   (tag_value_t)(v)
#define siptag_organization_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_server
 *
 * Tag list item for pointer to a @ref sip_server "Server header"
 * structure #sip_server_t.
 *
 * The SIPTAG_SERVER() macro is used to include a tag item with a
 * pointer to a #sip_server_t structure in a tag list.
 *
 * @param x pointer to a #sip_server_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SERVER_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SERVER(x) siptag_server, siptag_server_v(x)

SOFIAPUBVAR tag_typedef_t siptag_server;

/**@ingroup sip_server
 * Tag list item for reference to a 
 * @ref sip_server "Server header" pointer.
 */
#define SIPTAG_SERVER_REF(x) siptag_server_ref, siptag_server_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_server_ref;

/**@ingroup sip_server
 *
 * Tag list item for string with @ref sip_server "Server header" value.
 *
 * The SIPTAG_SERVER_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_server_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_server "Server header" value, or NULL.
 *
 * The string in SIPTAG_SERVER_STR() can be converted to a
 * #sip_server_t header structure by giving the string @a s has
 * second argument to function sip_server_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SERVER_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SERVER_STR(s) siptag_server_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_server_str;

/**@ingroup sip_server
 * Tag list item for reference to a
 * @ref sip_server "Server header" string.
 */
#define SIPTAG_SERVER_STR_REF(x) siptag_server_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_server_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_server_v(sip_server_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_server_vr(sip_server_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_server_v(v)   (tag_value_t)(v)
#define siptag_server_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_user_agent
 *
 * Tag list item for pointer to a @ref sip_user_agent "User-Agent header"
 * structure #sip_user_agent_t.
 *
 * The SIPTAG_USER_AGENT() macro is used to include a tag item with a
 * pointer to a #sip_user_agent_t structure in a tag list.
 *
 * @param x pointer to a #sip_user_agent_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_USER_AGENT_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_USER_AGENT(x) siptag_user_agent, siptag_user_agent_v(x)

SOFIAPUBVAR tag_typedef_t siptag_user_agent;

/**@ingroup sip_user_agent
 * Tag list item for reference to a 
 * @ref sip_user_agent "User-Agent header" pointer.
 */
#define SIPTAG_USER_AGENT_REF(x) siptag_user_agent_ref, siptag_user_agent_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_user_agent_ref;

/**@ingroup sip_user_agent
 *
 * Tag list item for string with @ref sip_user_agent "User-Agent header" value.
 *
 * The SIPTAG_USER_AGENT_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_user_agent_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_user_agent "User-Agent header" value, or NULL.
 *
 * The string in SIPTAG_USER_AGENT_STR() can be converted to a
 * #sip_user_agent_t header structure by giving the string @a s has
 * second argument to function sip_user_agent_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_USER_AGENT_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_USER_AGENT_STR(s) siptag_user_agent_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_user_agent_str;

/**@ingroup sip_user_agent
 * Tag list item for reference to a
 * @ref sip_user_agent "User-Agent header" string.
 */
#define SIPTAG_USER_AGENT_STR_REF(x) siptag_user_agent_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_user_agent_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_user_agent_v(sip_user_agent_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_user_agent_vr(sip_user_agent_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_user_agent_v(v)   (tag_value_t)(v)
#define siptag_user_agent_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_in_reply_to
 *
 * Tag list item for pointer to a @ref sip_in_reply_to "In-Reply-To header"
 * structure #sip_in_reply_to_t.
 *
 * The SIPTAG_IN_REPLY_TO() macro is used to include a tag item with a
 * pointer to a #sip_in_reply_to_t structure in a tag list.
 *
 * @param x pointer to a #sip_in_reply_to_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_IN_REPLY_TO_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_IN_REPLY_TO(x) siptag_in_reply_to, siptag_in_reply_to_v(x)

SOFIAPUBVAR tag_typedef_t siptag_in_reply_to;

/**@ingroup sip_in_reply_to
 * Tag list item for reference to a 
 * @ref sip_in_reply_to "In-Reply-To header" pointer.
 */
#define SIPTAG_IN_REPLY_TO_REF(x) siptag_in_reply_to_ref, siptag_in_reply_to_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_in_reply_to_ref;

/**@ingroup sip_in_reply_to
 *
 * Tag list item for string with @ref sip_in_reply_to "In-Reply-To header" value.
 *
 * The SIPTAG_IN_REPLY_TO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_in_reply_to_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_in_reply_to "In-Reply-To header" value, or NULL.
 *
 * The string in SIPTAG_IN_REPLY_TO_STR() can be converted to a
 * #sip_in_reply_to_t header structure by giving the string @a s has
 * second argument to function sip_in_reply_to_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_IN_REPLY_TO_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_IN_REPLY_TO_STR(s) siptag_in_reply_to_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_in_reply_to_str;

/**@ingroup sip_in_reply_to
 * Tag list item for reference to a
 * @ref sip_in_reply_to "In-Reply-To header" string.
 */
#define SIPTAG_IN_REPLY_TO_STR_REF(x) siptag_in_reply_to_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_in_reply_to_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_in_reply_to_v(sip_in_reply_to_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_in_reply_to_vr(sip_in_reply_to_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_in_reply_to_v(v)   (tag_value_t)(v)
#define siptag_in_reply_to_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_accept
 *
 * Tag list item for pointer to a @ref sip_accept "Accept header"
 * structure #sip_accept_t.
 *
 * The SIPTAG_ACCEPT() macro is used to include a tag item with a
 * pointer to a #sip_accept_t structure in a tag list.
 *
 * @param x pointer to a #sip_accept_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ACCEPT_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ACCEPT(x) siptag_accept, siptag_accept_v(x)

SOFIAPUBVAR tag_typedef_t siptag_accept;

/**@ingroup sip_accept
 * Tag list item for reference to a 
 * @ref sip_accept "Accept header" pointer.
 */
#define SIPTAG_ACCEPT_REF(x) siptag_accept_ref, siptag_accept_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_accept_ref;

/**@ingroup sip_accept
 *
 * Tag list item for string with @ref sip_accept "Accept header" value.
 *
 * The SIPTAG_ACCEPT_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_accept_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_accept "Accept header" value, or NULL.
 *
 * The string in SIPTAG_ACCEPT_STR() can be converted to a
 * #sip_accept_t header structure by giving the string @a s has
 * second argument to function sip_accept_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ACCEPT_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ACCEPT_STR(s) siptag_accept_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_accept_str;

/**@ingroup sip_accept
 * Tag list item for reference to a
 * @ref sip_accept "Accept header" string.
 */
#define SIPTAG_ACCEPT_STR_REF(x) siptag_accept_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_accept_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_accept_v(sip_accept_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_accept_vr(sip_accept_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_accept_v(v)   (tag_value_t)(v)
#define siptag_accept_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_accept_encoding
 *
 * Tag list item for pointer to a @ref sip_accept_encoding "Accept-Encoding header"
 * structure #sip_accept_encoding_t.
 *
 * The SIPTAG_ACCEPT_ENCODING() macro is used to include a tag item with a
 * pointer to a #sip_accept_encoding_t structure in a tag list.
 *
 * @param x pointer to a #sip_accept_encoding_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ACCEPT_ENCODING_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ACCEPT_ENCODING(x) siptag_accept_encoding, siptag_accept_encoding_v(x)

SOFIAPUBVAR tag_typedef_t siptag_accept_encoding;

/**@ingroup sip_accept_encoding
 * Tag list item for reference to a 
 * @ref sip_accept_encoding "Accept-Encoding header" pointer.
 */
#define SIPTAG_ACCEPT_ENCODING_REF(x) siptag_accept_encoding_ref, siptag_accept_encoding_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_accept_encoding_ref;

/**@ingroup sip_accept_encoding
 *
 * Tag list item for string with @ref sip_accept_encoding "Accept-Encoding header" value.
 *
 * The SIPTAG_ACCEPT_ENCODING_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_accept_encoding_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_accept_encoding "Accept-Encoding header" value, or NULL.
 *
 * The string in SIPTAG_ACCEPT_ENCODING_STR() can be converted to a
 * #sip_accept_encoding_t header structure by giving the string @a s has
 * second argument to function sip_accept_encoding_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ACCEPT_ENCODING_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ACCEPT_ENCODING_STR(s) siptag_accept_encoding_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_accept_encoding_str;

/**@ingroup sip_accept_encoding
 * Tag list item for reference to a
 * @ref sip_accept_encoding "Accept-Encoding header" string.
 */
#define SIPTAG_ACCEPT_ENCODING_STR_REF(x) siptag_accept_encoding_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_accept_encoding_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_accept_encoding_v(sip_accept_encoding_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_accept_encoding_vr(sip_accept_encoding_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_accept_encoding_v(v)   (tag_value_t)(v)
#define siptag_accept_encoding_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_accept_language
 *
 * Tag list item for pointer to a @ref sip_accept_language "Accept-Language header"
 * structure #sip_accept_language_t.
 *
 * The SIPTAG_ACCEPT_LANGUAGE() macro is used to include a tag item with a
 * pointer to a #sip_accept_language_t structure in a tag list.
 *
 * @param x pointer to a #sip_accept_language_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ACCEPT_LANGUAGE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ACCEPT_LANGUAGE(x) siptag_accept_language, siptag_accept_language_v(x)

SOFIAPUBVAR tag_typedef_t siptag_accept_language;

/**@ingroup sip_accept_language
 * Tag list item for reference to a 
 * @ref sip_accept_language "Accept-Language header" pointer.
 */
#define SIPTAG_ACCEPT_LANGUAGE_REF(x) siptag_accept_language_ref, siptag_accept_language_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_accept_language_ref;

/**@ingroup sip_accept_language
 *
 * Tag list item for string with @ref sip_accept_language "Accept-Language header" value.
 *
 * The SIPTAG_ACCEPT_LANGUAGE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_accept_language_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_accept_language "Accept-Language header" value, or NULL.
 *
 * The string in SIPTAG_ACCEPT_LANGUAGE_STR() can be converted to a
 * #sip_accept_language_t header structure by giving the string @a s has
 * second argument to function sip_accept_language_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ACCEPT_LANGUAGE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ACCEPT_LANGUAGE_STR(s) siptag_accept_language_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_accept_language_str;

/**@ingroup sip_accept_language
 * Tag list item for reference to a
 * @ref sip_accept_language "Accept-Language header" string.
 */
#define SIPTAG_ACCEPT_LANGUAGE_STR_REF(x) siptag_accept_language_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_accept_language_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_accept_language_v(sip_accept_language_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_accept_language_vr(sip_accept_language_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_accept_language_v(v)   (tag_value_t)(v)
#define siptag_accept_language_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_allow
 *
 * Tag list item for pointer to a @ref sip_allow "Allow header"
 * structure #sip_allow_t.
 *
 * The SIPTAG_ALLOW() macro is used to include a tag item with a
 * pointer to a #sip_allow_t structure in a tag list.
 *
 * @param x pointer to a #sip_allow_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ALLOW_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ALLOW(x) siptag_allow, siptag_allow_v(x)

SOFIAPUBVAR tag_typedef_t siptag_allow;

/**@ingroup sip_allow
 * Tag list item for reference to a 
 * @ref sip_allow "Allow header" pointer.
 */
#define SIPTAG_ALLOW_REF(x) siptag_allow_ref, siptag_allow_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_allow_ref;

/**@ingroup sip_allow
 *
 * Tag list item for string with @ref sip_allow "Allow header" value.
 *
 * The SIPTAG_ALLOW_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_allow_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_allow "Allow header" value, or NULL.
 *
 * The string in SIPTAG_ALLOW_STR() can be converted to a
 * #sip_allow_t header structure by giving the string @a s has
 * second argument to function sip_allow_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ALLOW_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ALLOW_STR(s) siptag_allow_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_allow_str;

/**@ingroup sip_allow
 * Tag list item for reference to a
 * @ref sip_allow "Allow header" string.
 */
#define SIPTAG_ALLOW_STR_REF(x) siptag_allow_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_allow_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_allow_v(sip_allow_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_allow_vr(sip_allow_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_allow_v(v)   (tag_value_t)(v)
#define siptag_allow_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_require
 *
 * Tag list item for pointer to a @ref sip_require "Require header"
 * structure #sip_require_t.
 *
 * The SIPTAG_REQUIRE() macro is used to include a tag item with a
 * pointer to a #sip_require_t structure in a tag list.
 *
 * @param x pointer to a #sip_require_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REQUIRE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REQUIRE(x) siptag_require, siptag_require_v(x)

SOFIAPUBVAR tag_typedef_t siptag_require;

/**@ingroup sip_require
 * Tag list item for reference to a 
 * @ref sip_require "Require header" pointer.
 */
#define SIPTAG_REQUIRE_REF(x) siptag_require_ref, siptag_require_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_require_ref;

/**@ingroup sip_require
 *
 * Tag list item for string with @ref sip_require "Require header" value.
 *
 * The SIPTAG_REQUIRE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_require_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_require "Require header" value, or NULL.
 *
 * The string in SIPTAG_REQUIRE_STR() can be converted to a
 * #sip_require_t header structure by giving the string @a s has
 * second argument to function sip_require_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REQUIRE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REQUIRE_STR(s) siptag_require_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_require_str;

/**@ingroup sip_require
 * Tag list item for reference to a
 * @ref sip_require "Require header" string.
 */
#define SIPTAG_REQUIRE_STR_REF(x) siptag_require_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_require_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_require_v(sip_require_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_require_vr(sip_require_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_require_v(v)   (tag_value_t)(v)
#define siptag_require_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_supported
 *
 * Tag list item for pointer to a @ref sip_supported "Supported header"
 * structure #sip_supported_t.
 *
 * The SIPTAG_SUPPORTED() macro is used to include a tag item with a
 * pointer to a #sip_supported_t structure in a tag list.
 *
 * @param x pointer to a #sip_supported_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUPPORTED_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SUPPORTED(x) siptag_supported, siptag_supported_v(x)

SOFIAPUBVAR tag_typedef_t siptag_supported;

/**@ingroup sip_supported
 * Tag list item for reference to a 
 * @ref sip_supported "Supported header" pointer.
 */
#define SIPTAG_SUPPORTED_REF(x) siptag_supported_ref, siptag_supported_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_supported_ref;

/**@ingroup sip_supported
 *
 * Tag list item for string with @ref sip_supported "Supported header" value.
 *
 * The SIPTAG_SUPPORTED_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_supported_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_supported "Supported header" value, or NULL.
 *
 * The string in SIPTAG_SUPPORTED_STR() can be converted to a
 * #sip_supported_t header structure by giving the string @a s has
 * second argument to function sip_supported_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUPPORTED_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SUPPORTED_STR(s) siptag_supported_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_supported_str;

/**@ingroup sip_supported
 * Tag list item for reference to a
 * @ref sip_supported "Supported header" string.
 */
#define SIPTAG_SUPPORTED_STR_REF(x) siptag_supported_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_supported_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_supported_v(sip_supported_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_supported_vr(sip_supported_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_supported_v(v)   (tag_value_t)(v)
#define siptag_supported_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_unsupported
 *
 * Tag list item for pointer to a @ref sip_unsupported "Unsupported header"
 * structure #sip_unsupported_t.
 *
 * The SIPTAG_UNSUPPORTED() macro is used to include a tag item with a
 * pointer to a #sip_unsupported_t structure in a tag list.
 *
 * @param x pointer to a #sip_unsupported_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_UNSUPPORTED_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_UNSUPPORTED(x) siptag_unsupported, siptag_unsupported_v(x)

SOFIAPUBVAR tag_typedef_t siptag_unsupported;

/**@ingroup sip_unsupported
 * Tag list item for reference to a 
 * @ref sip_unsupported "Unsupported header" pointer.
 */
#define SIPTAG_UNSUPPORTED_REF(x) siptag_unsupported_ref, siptag_unsupported_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_unsupported_ref;

/**@ingroup sip_unsupported
 *
 * Tag list item for string with @ref sip_unsupported "Unsupported header" value.
 *
 * The SIPTAG_UNSUPPORTED_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_unsupported_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_unsupported "Unsupported header" value, or NULL.
 *
 * The string in SIPTAG_UNSUPPORTED_STR() can be converted to a
 * #sip_unsupported_t header structure by giving the string @a s has
 * second argument to function sip_unsupported_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_UNSUPPORTED_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_UNSUPPORTED_STR(s) siptag_unsupported_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_unsupported_str;

/**@ingroup sip_unsupported
 * Tag list item for reference to a
 * @ref sip_unsupported "Unsupported header" string.
 */
#define SIPTAG_UNSUPPORTED_STR_REF(x) siptag_unsupported_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_unsupported_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_unsupported_v(sip_unsupported_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_unsupported_vr(sip_unsupported_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_unsupported_v(v)   (tag_value_t)(v)
#define siptag_unsupported_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_event
 *
 * Tag list item for pointer to a @ref sip_event "Event header"
 * structure #sip_event_t.
 *
 * The SIPTAG_EVENT() macro is used to include a tag item with a
 * pointer to a #sip_event_t structure in a tag list.
 *
 * @param x pointer to a #sip_event_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_EVENT_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_EVENT(x) siptag_event, siptag_event_v(x)

SOFIAPUBVAR tag_typedef_t siptag_event;

/**@ingroup sip_event
 * Tag list item for reference to a 
 * @ref sip_event "Event header" pointer.
 */
#define SIPTAG_EVENT_REF(x) siptag_event_ref, siptag_event_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_event_ref;

/**@ingroup sip_event
 *
 * Tag list item for string with @ref sip_event "Event header" value.
 *
 * The SIPTAG_EVENT_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_event_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_event "Event header" value, or NULL.
 *
 * The string in SIPTAG_EVENT_STR() can be converted to a
 * #sip_event_t header structure by giving the string @a s has
 * second argument to function sip_event_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_EVENT_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_EVENT_STR(s) siptag_event_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_event_str;

/**@ingroup sip_event
 * Tag list item for reference to a
 * @ref sip_event "Event header" string.
 */
#define SIPTAG_EVENT_STR_REF(x) siptag_event_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_event_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_event_v(sip_event_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_event_vr(sip_event_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_event_v(v)   (tag_value_t)(v)
#define siptag_event_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_allow_events
 *
 * Tag list item for pointer to a @ref sip_allow_events "Allow-Events header"
 * structure #sip_allow_events_t.
 *
 * The SIPTAG_ALLOW_EVENTS() macro is used to include a tag item with a
 * pointer to a #sip_allow_events_t structure in a tag list.
 *
 * @param x pointer to a #sip_allow_events_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ALLOW_EVENTS_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ALLOW_EVENTS(x) siptag_allow_events, siptag_allow_events_v(x)

SOFIAPUBVAR tag_typedef_t siptag_allow_events;

/**@ingroup sip_allow_events
 * Tag list item for reference to a 
 * @ref sip_allow_events "Allow-Events header" pointer.
 */
#define SIPTAG_ALLOW_EVENTS_REF(x) siptag_allow_events_ref, siptag_allow_events_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_allow_events_ref;

/**@ingroup sip_allow_events
 *
 * Tag list item for string with @ref sip_allow_events "Allow-Events header" value.
 *
 * The SIPTAG_ALLOW_EVENTS_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_allow_events_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_allow_events "Allow-Events header" value, or NULL.
 *
 * The string in SIPTAG_ALLOW_EVENTS_STR() can be converted to a
 * #sip_allow_events_t header structure by giving the string @a s has
 * second argument to function sip_allow_events_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ALLOW_EVENTS_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ALLOW_EVENTS_STR(s) siptag_allow_events_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_allow_events_str;

/**@ingroup sip_allow_events
 * Tag list item for reference to a
 * @ref sip_allow_events "Allow-Events header" string.
 */
#define SIPTAG_ALLOW_EVENTS_STR_REF(x) siptag_allow_events_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_allow_events_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_allow_events_v(sip_allow_events_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_allow_events_vr(sip_allow_events_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_allow_events_v(v)   (tag_value_t)(v)
#define siptag_allow_events_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_subscription_state
 *
 * Tag list item for pointer to a @ref sip_subscription_state "Subscription-State header"
 * structure #sip_subscription_state_t.
 *
 * The SIPTAG_SUBSCRIPTION_STATE() macro is used to include a tag item with a
 * pointer to a #sip_subscription_state_t structure in a tag list.
 *
 * @param x pointer to a #sip_subscription_state_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUBSCRIPTION_STATE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SUBSCRIPTION_STATE(x) siptag_subscription_state, siptag_subscription_state_v(x)

SOFIAPUBVAR tag_typedef_t siptag_subscription_state;

/**@ingroup sip_subscription_state
 * Tag list item for reference to a 
 * @ref sip_subscription_state "Subscription-State header" pointer.
 */
#define SIPTAG_SUBSCRIPTION_STATE_REF(x) siptag_subscription_state_ref, siptag_subscription_state_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_subscription_state_ref;

/**@ingroup sip_subscription_state
 *
 * Tag list item for string with @ref sip_subscription_state "Subscription-State header" value.
 *
 * The SIPTAG_SUBSCRIPTION_STATE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_subscription_state_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_subscription_state "Subscription-State header" value, or NULL.
 *
 * The string in SIPTAG_SUBSCRIPTION_STATE_STR() can be converted to a
 * #sip_subscription_state_t header structure by giving the string @a s has
 * second argument to function sip_subscription_state_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SUBSCRIPTION_STATE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SUBSCRIPTION_STATE_STR(s) siptag_subscription_state_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_subscription_state_str;

/**@ingroup sip_subscription_state
 * Tag list item for reference to a
 * @ref sip_subscription_state "Subscription-State header" string.
 */
#define SIPTAG_SUBSCRIPTION_STATE_STR_REF(x) siptag_subscription_state_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_subscription_state_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_subscription_state_v(sip_subscription_state_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_subscription_state_vr(sip_subscription_state_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_subscription_state_v(v)   (tag_value_t)(v)
#define siptag_subscription_state_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_proxy_authenticate
 *
 * Tag list item for pointer to a @ref sip_proxy_authenticate "Proxy-Authenticate header"
 * structure #sip_proxy_authenticate_t.
 *
 * The SIPTAG_PROXY_AUTHENTICATE() macro is used to include a tag item with a
 * pointer to a #sip_proxy_authenticate_t structure in a tag list.
 *
 * @param x pointer to a #sip_proxy_authenticate_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PROXY_AUTHENTICATE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PROXY_AUTHENTICATE(x) siptag_proxy_authenticate, siptag_proxy_authenticate_v(x)

SOFIAPUBVAR tag_typedef_t siptag_proxy_authenticate;

/**@ingroup sip_proxy_authenticate
 * Tag list item for reference to a 
 * @ref sip_proxy_authenticate "Proxy-Authenticate header" pointer.
 */
#define SIPTAG_PROXY_AUTHENTICATE_REF(x) siptag_proxy_authenticate_ref, siptag_proxy_authenticate_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_proxy_authenticate_ref;

/**@ingroup sip_proxy_authenticate
 *
 * Tag list item for string with @ref sip_proxy_authenticate "Proxy-Authenticate header" value.
 *
 * The SIPTAG_PROXY_AUTHENTICATE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_proxy_authenticate_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_proxy_authenticate "Proxy-Authenticate header" value, or NULL.
 *
 * The string in SIPTAG_PROXY_AUTHENTICATE_STR() can be converted to a
 * #sip_proxy_authenticate_t header structure by giving the string @a s has
 * second argument to function sip_proxy_authenticate_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PROXY_AUTHENTICATE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PROXY_AUTHENTICATE_STR(s) siptag_proxy_authenticate_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_proxy_authenticate_str;

/**@ingroup sip_proxy_authenticate
 * Tag list item for reference to a
 * @ref sip_proxy_authenticate "Proxy-Authenticate header" string.
 */
#define SIPTAG_PROXY_AUTHENTICATE_STR_REF(x) siptag_proxy_authenticate_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_proxy_authenticate_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_proxy_authenticate_v(sip_proxy_authenticate_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_proxy_authenticate_vr(sip_proxy_authenticate_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_proxy_authenticate_v(v)   (tag_value_t)(v)
#define siptag_proxy_authenticate_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_proxy_authentication_info
 *
 * Tag list item for pointer to a @ref sip_proxy_authentication_info "Proxy-Authentication-Info header"
 * structure #sip_proxy_authentication_info_t.
 *
 * The SIPTAG_PROXY_AUTHENTICATION_INFO() macro is used to include a tag item with a
 * pointer to a #sip_proxy_authentication_info_t structure in a tag list.
 *
 * @param x pointer to a #sip_proxy_authentication_info_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PROXY_AUTHENTICATION_INFO_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PROXY_AUTHENTICATION_INFO(x) siptag_proxy_authentication_info, siptag_proxy_authentication_info_v(x)

SOFIAPUBVAR tag_typedef_t siptag_proxy_authentication_info;

/**@ingroup sip_proxy_authentication_info
 * Tag list item for reference to a 
 * @ref sip_proxy_authentication_info "Proxy-Authentication-Info header" pointer.
 */
#define SIPTAG_PROXY_AUTHENTICATION_INFO_REF(x) siptag_proxy_authentication_info_ref, siptag_proxy_authentication_info_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_proxy_authentication_info_ref;

/**@ingroup sip_proxy_authentication_info
 *
 * Tag list item for string with @ref sip_proxy_authentication_info "Proxy-Authentication-Info header" value.
 *
 * The SIPTAG_PROXY_AUTHENTICATION_INFO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_proxy_authentication_info_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_proxy_authentication_info "Proxy-Authentication-Info header" value, or NULL.
 *
 * The string in SIPTAG_PROXY_AUTHENTICATION_INFO_STR() can be converted to a
 * #sip_proxy_authentication_info_t header structure by giving the string @a s has
 * second argument to function sip_proxy_authentication_info_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PROXY_AUTHENTICATION_INFO_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PROXY_AUTHENTICATION_INFO_STR(s) siptag_proxy_authentication_info_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_proxy_authentication_info_str;

/**@ingroup sip_proxy_authentication_info
 * Tag list item for reference to a
 * @ref sip_proxy_authentication_info "Proxy-Authentication-Info header" string.
 */
#define SIPTAG_PROXY_AUTHENTICATION_INFO_STR_REF(x) siptag_proxy_authentication_info_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_proxy_authentication_info_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_proxy_authentication_info_v(sip_proxy_authentication_info_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_proxy_authentication_info_vr(sip_proxy_authentication_info_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_proxy_authentication_info_v(v)   (tag_value_t)(v)
#define siptag_proxy_authentication_info_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_proxy_authorization
 *
 * Tag list item for pointer to a @ref sip_proxy_authorization "Proxy-Authorization header"
 * structure #sip_proxy_authorization_t.
 *
 * The SIPTAG_PROXY_AUTHORIZATION() macro is used to include a tag item with a
 * pointer to a #sip_proxy_authorization_t structure in a tag list.
 *
 * @param x pointer to a #sip_proxy_authorization_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PROXY_AUTHORIZATION_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PROXY_AUTHORIZATION(x) siptag_proxy_authorization, siptag_proxy_authorization_v(x)

SOFIAPUBVAR tag_typedef_t siptag_proxy_authorization;

/**@ingroup sip_proxy_authorization
 * Tag list item for reference to a 
 * @ref sip_proxy_authorization "Proxy-Authorization header" pointer.
 */
#define SIPTAG_PROXY_AUTHORIZATION_REF(x) siptag_proxy_authorization_ref, siptag_proxy_authorization_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_proxy_authorization_ref;

/**@ingroup sip_proxy_authorization
 *
 * Tag list item for string with @ref sip_proxy_authorization "Proxy-Authorization header" value.
 *
 * The SIPTAG_PROXY_AUTHORIZATION_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_proxy_authorization_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_proxy_authorization "Proxy-Authorization header" value, or NULL.
 *
 * The string in SIPTAG_PROXY_AUTHORIZATION_STR() can be converted to a
 * #sip_proxy_authorization_t header structure by giving the string @a s has
 * second argument to function sip_proxy_authorization_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PROXY_AUTHORIZATION_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PROXY_AUTHORIZATION_STR(s) siptag_proxy_authorization_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_proxy_authorization_str;

/**@ingroup sip_proxy_authorization
 * Tag list item for reference to a
 * @ref sip_proxy_authorization "Proxy-Authorization header" string.
 */
#define SIPTAG_PROXY_AUTHORIZATION_STR_REF(x) siptag_proxy_authorization_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_proxy_authorization_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_proxy_authorization_v(sip_proxy_authorization_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_proxy_authorization_vr(sip_proxy_authorization_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_proxy_authorization_v(v)   (tag_value_t)(v)
#define siptag_proxy_authorization_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_authorization
 *
 * Tag list item for pointer to a @ref sip_authorization "Authorization header"
 * structure #sip_authorization_t.
 *
 * The SIPTAG_AUTHORIZATION() macro is used to include a tag item with a
 * pointer to a #sip_authorization_t structure in a tag list.
 *
 * @param x pointer to a #sip_authorization_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_AUTHORIZATION_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_AUTHORIZATION(x) siptag_authorization, siptag_authorization_v(x)

SOFIAPUBVAR tag_typedef_t siptag_authorization;

/**@ingroup sip_authorization
 * Tag list item for reference to a 
 * @ref sip_authorization "Authorization header" pointer.
 */
#define SIPTAG_AUTHORIZATION_REF(x) siptag_authorization_ref, siptag_authorization_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_authorization_ref;

/**@ingroup sip_authorization
 *
 * Tag list item for string with @ref sip_authorization "Authorization header" value.
 *
 * The SIPTAG_AUTHORIZATION_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_authorization_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_authorization "Authorization header" value, or NULL.
 *
 * The string in SIPTAG_AUTHORIZATION_STR() can be converted to a
 * #sip_authorization_t header structure by giving the string @a s has
 * second argument to function sip_authorization_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_AUTHORIZATION_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_AUTHORIZATION_STR(s) siptag_authorization_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_authorization_str;

/**@ingroup sip_authorization
 * Tag list item for reference to a
 * @ref sip_authorization "Authorization header" string.
 */
#define SIPTAG_AUTHORIZATION_STR_REF(x) siptag_authorization_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_authorization_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_authorization_v(sip_authorization_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_authorization_vr(sip_authorization_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_authorization_v(v)   (tag_value_t)(v)
#define siptag_authorization_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_www_authenticate
 *
 * Tag list item for pointer to a @ref sip_www_authenticate "WWW-Authenticate header"
 * structure #sip_www_authenticate_t.
 *
 * The SIPTAG_WWW_AUTHENTICATE() macro is used to include a tag item with a
 * pointer to a #sip_www_authenticate_t structure in a tag list.
 *
 * @param x pointer to a #sip_www_authenticate_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_WWW_AUTHENTICATE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_WWW_AUTHENTICATE(x) siptag_www_authenticate, siptag_www_authenticate_v(x)

SOFIAPUBVAR tag_typedef_t siptag_www_authenticate;

/**@ingroup sip_www_authenticate
 * Tag list item for reference to a 
 * @ref sip_www_authenticate "WWW-Authenticate header" pointer.
 */
#define SIPTAG_WWW_AUTHENTICATE_REF(x) siptag_www_authenticate_ref, siptag_www_authenticate_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_www_authenticate_ref;

/**@ingroup sip_www_authenticate
 *
 * Tag list item for string with @ref sip_www_authenticate "WWW-Authenticate header" value.
 *
 * The SIPTAG_WWW_AUTHENTICATE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_www_authenticate_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_www_authenticate "WWW-Authenticate header" value, or NULL.
 *
 * The string in SIPTAG_WWW_AUTHENTICATE_STR() can be converted to a
 * #sip_www_authenticate_t header structure by giving the string @a s has
 * second argument to function sip_www_authenticate_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_WWW_AUTHENTICATE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_WWW_AUTHENTICATE_STR(s) siptag_www_authenticate_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_www_authenticate_str;

/**@ingroup sip_www_authenticate
 * Tag list item for reference to a
 * @ref sip_www_authenticate "WWW-Authenticate header" string.
 */
#define SIPTAG_WWW_AUTHENTICATE_STR_REF(x) siptag_www_authenticate_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_www_authenticate_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_www_authenticate_v(sip_www_authenticate_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_www_authenticate_vr(sip_www_authenticate_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_www_authenticate_v(v)   (tag_value_t)(v)
#define siptag_www_authenticate_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_authentication_info
 *
 * Tag list item for pointer to a @ref sip_authentication_info "Authentication-Info header"
 * structure #sip_authentication_info_t.
 *
 * The SIPTAG_AUTHENTICATION_INFO() macro is used to include a tag item with a
 * pointer to a #sip_authentication_info_t structure in a tag list.
 *
 * @param x pointer to a #sip_authentication_info_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_AUTHENTICATION_INFO_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_AUTHENTICATION_INFO(x) siptag_authentication_info, siptag_authentication_info_v(x)

SOFIAPUBVAR tag_typedef_t siptag_authentication_info;

/**@ingroup sip_authentication_info
 * Tag list item for reference to a 
 * @ref sip_authentication_info "Authentication-Info header" pointer.
 */
#define SIPTAG_AUTHENTICATION_INFO_REF(x) siptag_authentication_info_ref, siptag_authentication_info_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_authentication_info_ref;

/**@ingroup sip_authentication_info
 *
 * Tag list item for string with @ref sip_authentication_info "Authentication-Info header" value.
 *
 * The SIPTAG_AUTHENTICATION_INFO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_authentication_info_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_authentication_info "Authentication-Info header" value, or NULL.
 *
 * The string in SIPTAG_AUTHENTICATION_INFO_STR() can be converted to a
 * #sip_authentication_info_t header structure by giving the string @a s has
 * second argument to function sip_authentication_info_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_AUTHENTICATION_INFO_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_AUTHENTICATION_INFO_STR(s) siptag_authentication_info_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_authentication_info_str;

/**@ingroup sip_authentication_info
 * Tag list item for reference to a
 * @ref sip_authentication_info "Authentication-Info header" string.
 */
#define SIPTAG_AUTHENTICATION_INFO_STR_REF(x) siptag_authentication_info_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_authentication_info_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_authentication_info_v(sip_authentication_info_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_authentication_info_vr(sip_authentication_info_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_authentication_info_v(v)   (tag_value_t)(v)
#define siptag_authentication_info_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_error_info
 *
 * Tag list item for pointer to a @ref sip_error_info "Error-Info header"
 * structure #sip_error_info_t.
 *
 * The SIPTAG_ERROR_INFO() macro is used to include a tag item with a
 * pointer to a #sip_error_info_t structure in a tag list.
 *
 * @param x pointer to a #sip_error_info_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ERROR_INFO_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ERROR_INFO(x) siptag_error_info, siptag_error_info_v(x)

SOFIAPUBVAR tag_typedef_t siptag_error_info;

/**@ingroup sip_error_info
 * Tag list item for reference to a 
 * @ref sip_error_info "Error-Info header" pointer.
 */
#define SIPTAG_ERROR_INFO_REF(x) siptag_error_info_ref, siptag_error_info_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_error_info_ref;

/**@ingroup sip_error_info
 *
 * Tag list item for string with @ref sip_error_info "Error-Info header" value.
 *
 * The SIPTAG_ERROR_INFO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_error_info_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_error_info "Error-Info header" value, or NULL.
 *
 * The string in SIPTAG_ERROR_INFO_STR() can be converted to a
 * #sip_error_info_t header structure by giving the string @a s has
 * second argument to function sip_error_info_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ERROR_INFO_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ERROR_INFO_STR(s) siptag_error_info_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_error_info_str;

/**@ingroup sip_error_info
 * Tag list item for reference to a
 * @ref sip_error_info "Error-Info header" string.
 */
#define SIPTAG_ERROR_INFO_STR_REF(x) siptag_error_info_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_error_info_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_error_info_v(sip_error_info_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_error_info_vr(sip_error_info_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_error_info_v(v)   (tag_value_t)(v)
#define siptag_error_info_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_warning
 *
 * Tag list item for pointer to a @ref sip_warning "Warning header"
 * structure #sip_warning_t.
 *
 * The SIPTAG_WARNING() macro is used to include a tag item with a
 * pointer to a #sip_warning_t structure in a tag list.
 *
 * @param x pointer to a #sip_warning_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_WARNING_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_WARNING(x) siptag_warning, siptag_warning_v(x)

SOFIAPUBVAR tag_typedef_t siptag_warning;

/**@ingroup sip_warning
 * Tag list item for reference to a 
 * @ref sip_warning "Warning header" pointer.
 */
#define SIPTAG_WARNING_REF(x) siptag_warning_ref, siptag_warning_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_warning_ref;

/**@ingroup sip_warning
 *
 * Tag list item for string with @ref sip_warning "Warning header" value.
 *
 * The SIPTAG_WARNING_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_warning_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_warning "Warning header" value, or NULL.
 *
 * The string in SIPTAG_WARNING_STR() can be converted to a
 * #sip_warning_t header structure by giving the string @a s has
 * second argument to function sip_warning_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_WARNING_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_WARNING_STR(s) siptag_warning_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_warning_str;

/**@ingroup sip_warning
 * Tag list item for reference to a
 * @ref sip_warning "Warning header" string.
 */
#define SIPTAG_WARNING_STR_REF(x) siptag_warning_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_warning_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_warning_v(sip_warning_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_warning_vr(sip_warning_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_warning_v(v)   (tag_value_t)(v)
#define siptag_warning_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_refer_to
 *
 * Tag list item for pointer to a @ref sip_refer_to "Refer-To header"
 * structure #sip_refer_to_t.
 *
 * The SIPTAG_REFER_TO() macro is used to include a tag item with a
 * pointer to a #sip_refer_to_t structure in a tag list.
 *
 * @param x pointer to a #sip_refer_to_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REFER_TO_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REFER_TO(x) siptag_refer_to, siptag_refer_to_v(x)

SOFIAPUBVAR tag_typedef_t siptag_refer_to;

/**@ingroup sip_refer_to
 * Tag list item for reference to a 
 * @ref sip_refer_to "Refer-To header" pointer.
 */
#define SIPTAG_REFER_TO_REF(x) siptag_refer_to_ref, siptag_refer_to_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_refer_to_ref;

/**@ingroup sip_refer_to
 *
 * Tag list item for string with @ref sip_refer_to "Refer-To header" value.
 *
 * The SIPTAG_REFER_TO_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_refer_to_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_refer_to "Refer-To header" value, or NULL.
 *
 * The string in SIPTAG_REFER_TO_STR() can be converted to a
 * #sip_refer_to_t header structure by giving the string @a s has
 * second argument to function sip_refer_to_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REFER_TO_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REFER_TO_STR(s) siptag_refer_to_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_refer_to_str;

/**@ingroup sip_refer_to
 * Tag list item for reference to a
 * @ref sip_refer_to "Refer-To header" string.
 */
#define SIPTAG_REFER_TO_STR_REF(x) siptag_refer_to_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_refer_to_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_refer_to_v(sip_refer_to_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_refer_to_vr(sip_refer_to_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_refer_to_v(v)   (tag_value_t)(v)
#define siptag_refer_to_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_referred_by
 *
 * Tag list item for pointer to a @ref sip_referred_by "Referred-By header"
 * structure #sip_referred_by_t.
 *
 * The SIPTAG_REFERRED_BY() macro is used to include a tag item with a
 * pointer to a #sip_referred_by_t structure in a tag list.
 *
 * @param x pointer to a #sip_referred_by_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REFERRED_BY_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REFERRED_BY(x) siptag_referred_by, siptag_referred_by_v(x)

SOFIAPUBVAR tag_typedef_t siptag_referred_by;

/**@ingroup sip_referred_by
 * Tag list item for reference to a 
 * @ref sip_referred_by "Referred-By header" pointer.
 */
#define SIPTAG_REFERRED_BY_REF(x) siptag_referred_by_ref, siptag_referred_by_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_referred_by_ref;

/**@ingroup sip_referred_by
 *
 * Tag list item for string with @ref sip_referred_by "Referred-By header" value.
 *
 * The SIPTAG_REFERRED_BY_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_referred_by_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_referred_by "Referred-By header" value, or NULL.
 *
 * The string in SIPTAG_REFERRED_BY_STR() can be converted to a
 * #sip_referred_by_t header structure by giving the string @a s has
 * second argument to function sip_referred_by_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REFERRED_BY_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REFERRED_BY_STR(s) siptag_referred_by_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_referred_by_str;

/**@ingroup sip_referred_by
 * Tag list item for reference to a
 * @ref sip_referred_by "Referred-By header" string.
 */
#define SIPTAG_REFERRED_BY_STR_REF(x) siptag_referred_by_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_referred_by_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_referred_by_v(sip_referred_by_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_referred_by_vr(sip_referred_by_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_referred_by_v(v)   (tag_value_t)(v)
#define siptag_referred_by_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_replaces
 *
 * Tag list item for pointer to a @ref sip_replaces "Replaces header"
 * structure #sip_replaces_t.
 *
 * The SIPTAG_REPLACES() macro is used to include a tag item with a
 * pointer to a #sip_replaces_t structure in a tag list.
 *
 * @param x pointer to a #sip_replaces_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REPLACES_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REPLACES(x) siptag_replaces, siptag_replaces_v(x)

SOFIAPUBVAR tag_typedef_t siptag_replaces;

/**@ingroup sip_replaces
 * Tag list item for reference to a 
 * @ref sip_replaces "Replaces header" pointer.
 */
#define SIPTAG_REPLACES_REF(x) siptag_replaces_ref, siptag_replaces_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_replaces_ref;

/**@ingroup sip_replaces
 *
 * Tag list item for string with @ref sip_replaces "Replaces header" value.
 *
 * The SIPTAG_REPLACES_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_replaces_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_replaces "Replaces header" value, or NULL.
 *
 * The string in SIPTAG_REPLACES_STR() can be converted to a
 * #sip_replaces_t header structure by giving the string @a s has
 * second argument to function sip_replaces_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REPLACES_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REPLACES_STR(s) siptag_replaces_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_replaces_str;

/**@ingroup sip_replaces
 * Tag list item for reference to a
 * @ref sip_replaces "Replaces header" string.
 */
#define SIPTAG_REPLACES_STR_REF(x) siptag_replaces_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_replaces_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_replaces_v(sip_replaces_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_replaces_vr(sip_replaces_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_replaces_v(v)   (tag_value_t)(v)
#define siptag_replaces_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_session_expires
 *
 * Tag list item for pointer to a @ref sip_session_expires "Session-Expires header"
 * structure #sip_session_expires_t.
 *
 * The SIPTAG_SESSION_EXPIRES() macro is used to include a tag item with a
 * pointer to a #sip_session_expires_t structure in a tag list.
 *
 * @param x pointer to a #sip_session_expires_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SESSION_EXPIRES_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SESSION_EXPIRES(x) siptag_session_expires, siptag_session_expires_v(x)

SOFIAPUBVAR tag_typedef_t siptag_session_expires;

/**@ingroup sip_session_expires
 * Tag list item for reference to a 
 * @ref sip_session_expires "Session-Expires header" pointer.
 */
#define SIPTAG_SESSION_EXPIRES_REF(x) siptag_session_expires_ref, siptag_session_expires_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_session_expires_ref;

/**@ingroup sip_session_expires
 *
 * Tag list item for string with @ref sip_session_expires "Session-Expires header" value.
 *
 * The SIPTAG_SESSION_EXPIRES_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_session_expires_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_session_expires "Session-Expires header" value, or NULL.
 *
 * The string in SIPTAG_SESSION_EXPIRES_STR() can be converted to a
 * #sip_session_expires_t header structure by giving the string @a s has
 * second argument to function sip_session_expires_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SESSION_EXPIRES_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SESSION_EXPIRES_STR(s) siptag_session_expires_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_session_expires_str;

/**@ingroup sip_session_expires
 * Tag list item for reference to a
 * @ref sip_session_expires "Session-Expires header" string.
 */
#define SIPTAG_SESSION_EXPIRES_STR_REF(x) siptag_session_expires_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_session_expires_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_session_expires_v(sip_session_expires_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_session_expires_vr(sip_session_expires_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_session_expires_v(v)   (tag_value_t)(v)
#define siptag_session_expires_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_min_se
 *
 * Tag list item for pointer to a @ref sip_min_se "Min-SE header"
 * structure #sip_min_se_t.
 *
 * The SIPTAG_MIN_SE() macro is used to include a tag item with a
 * pointer to a #sip_min_se_t structure in a tag list.
 *
 * @param x pointer to a #sip_min_se_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_MIN_SE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_MIN_SE(x) siptag_min_se, siptag_min_se_v(x)

SOFIAPUBVAR tag_typedef_t siptag_min_se;

/**@ingroup sip_min_se
 * Tag list item for reference to a 
 * @ref sip_min_se "Min-SE header" pointer.
 */
#define SIPTAG_MIN_SE_REF(x) siptag_min_se_ref, siptag_min_se_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_min_se_ref;

/**@ingroup sip_min_se
 *
 * Tag list item for string with @ref sip_min_se "Min-SE header" value.
 *
 * The SIPTAG_MIN_SE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_min_se_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_min_se "Min-SE header" value, or NULL.
 *
 * The string in SIPTAG_MIN_SE_STR() can be converted to a
 * #sip_min_se_t header structure by giving the string @a s has
 * second argument to function sip_min_se_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_MIN_SE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_MIN_SE_STR(s) siptag_min_se_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_min_se_str;

/**@ingroup sip_min_se
 * Tag list item for reference to a
 * @ref sip_min_se "Min-SE header" string.
 */
#define SIPTAG_MIN_SE_STR_REF(x) siptag_min_se_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_min_se_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_min_se_v(sip_min_se_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_min_se_vr(sip_min_se_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_min_se_v(v)   (tag_value_t)(v)
#define siptag_min_se_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_path
 *
 * Tag list item for pointer to a @ref sip_path "Path header"
 * structure #sip_path_t.
 *
 * The SIPTAG_PATH() macro is used to include a tag item with a
 * pointer to a #sip_path_t structure in a tag list.
 *
 * @param x pointer to a #sip_path_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PATH_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PATH(x) siptag_path, siptag_path_v(x)

SOFIAPUBVAR tag_typedef_t siptag_path;

/**@ingroup sip_path
 * Tag list item for reference to a 
 * @ref sip_path "Path header" pointer.
 */
#define SIPTAG_PATH_REF(x) siptag_path_ref, siptag_path_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_path_ref;

/**@ingroup sip_path
 *
 * Tag list item for string with @ref sip_path "Path header" value.
 *
 * The SIPTAG_PATH_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_path_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_path "Path header" value, or NULL.
 *
 * The string in SIPTAG_PATH_STR() can be converted to a
 * #sip_path_t header structure by giving the string @a s has
 * second argument to function sip_path_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PATH_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PATH_STR(s) siptag_path_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_path_str;

/**@ingroup sip_path
 * Tag list item for reference to a
 * @ref sip_path "Path header" string.
 */
#define SIPTAG_PATH_STR_REF(x) siptag_path_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_path_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_path_v(sip_path_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_path_vr(sip_path_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_path_v(v)   (tag_value_t)(v)
#define siptag_path_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_service_route
 *
 * Tag list item for pointer to a @ref sip_service_route "Service-Route header"
 * structure #sip_service_route_t.
 *
 * The SIPTAG_SERVICE_ROUTE() macro is used to include a tag item with a
 * pointer to a #sip_service_route_t structure in a tag list.
 *
 * @param x pointer to a #sip_service_route_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SERVICE_ROUTE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SERVICE_ROUTE(x) siptag_service_route, siptag_service_route_v(x)

SOFIAPUBVAR tag_typedef_t siptag_service_route;

/**@ingroup sip_service_route
 * Tag list item for reference to a 
 * @ref sip_service_route "Service-Route header" pointer.
 */
#define SIPTAG_SERVICE_ROUTE_REF(x) siptag_service_route_ref, siptag_service_route_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_service_route_ref;

/**@ingroup sip_service_route
 *
 * Tag list item for string with @ref sip_service_route "Service-Route header" value.
 *
 * The SIPTAG_SERVICE_ROUTE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_service_route_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_service_route "Service-Route header" value, or NULL.
 *
 * The string in SIPTAG_SERVICE_ROUTE_STR() can be converted to a
 * #sip_service_route_t header structure by giving the string @a s has
 * second argument to function sip_service_route_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SERVICE_ROUTE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SERVICE_ROUTE_STR(s) siptag_service_route_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_service_route_str;

/**@ingroup sip_service_route
 * Tag list item for reference to a
 * @ref sip_service_route "Service-Route header" string.
 */
#define SIPTAG_SERVICE_ROUTE_STR_REF(x) siptag_service_route_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_service_route_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_service_route_v(sip_service_route_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_service_route_vr(sip_service_route_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_service_route_v(v)   (tag_value_t)(v)
#define siptag_service_route_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_reason
 *
 * Tag list item for pointer to a @ref sip_reason "Reason header"
 * structure #sip_reason_t.
 *
 * The SIPTAG_REASON() macro is used to include a tag item with a
 * pointer to a #sip_reason_t structure in a tag list.
 *
 * @param x pointer to a #sip_reason_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REASON_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REASON(x) siptag_reason, siptag_reason_v(x)

SOFIAPUBVAR tag_typedef_t siptag_reason;

/**@ingroup sip_reason
 * Tag list item for reference to a 
 * @ref sip_reason "Reason header" pointer.
 */
#define SIPTAG_REASON_REF(x) siptag_reason_ref, siptag_reason_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_reason_ref;

/**@ingroup sip_reason
 *
 * Tag list item for string with @ref sip_reason "Reason header" value.
 *
 * The SIPTAG_REASON_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_reason_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_reason "Reason header" value, or NULL.
 *
 * The string in SIPTAG_REASON_STR() can be converted to a
 * #sip_reason_t header structure by giving the string @a s has
 * second argument to function sip_reason_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_REASON_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_REASON_STR(s) siptag_reason_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_reason_str;

/**@ingroup sip_reason
 * Tag list item for reference to a
 * @ref sip_reason "Reason header" string.
 */
#define SIPTAG_REASON_STR_REF(x) siptag_reason_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_reason_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_reason_v(sip_reason_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_reason_vr(sip_reason_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_reason_v(v)   (tag_value_t)(v)
#define siptag_reason_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_security_client
 *
 * Tag list item for pointer to a @ref sip_security_client "Security-Client header"
 * structure #sip_security_client_t.
 *
 * The SIPTAG_SECURITY_CLIENT() macro is used to include a tag item with a
 * pointer to a #sip_security_client_t structure in a tag list.
 *
 * @param x pointer to a #sip_security_client_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SECURITY_CLIENT_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SECURITY_CLIENT(x) siptag_security_client, siptag_security_client_v(x)

SOFIAPUBVAR tag_typedef_t siptag_security_client;

/**@ingroup sip_security_client
 * Tag list item for reference to a 
 * @ref sip_security_client "Security-Client header" pointer.
 */
#define SIPTAG_SECURITY_CLIENT_REF(x) siptag_security_client_ref, siptag_security_client_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_security_client_ref;

/**@ingroup sip_security_client
 *
 * Tag list item for string with @ref sip_security_client "Security-Client header" value.
 *
 * The SIPTAG_SECURITY_CLIENT_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_security_client_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_security_client "Security-Client header" value, or NULL.
 *
 * The string in SIPTAG_SECURITY_CLIENT_STR() can be converted to a
 * #sip_security_client_t header structure by giving the string @a s has
 * second argument to function sip_security_client_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SECURITY_CLIENT_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SECURITY_CLIENT_STR(s) siptag_security_client_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_security_client_str;

/**@ingroup sip_security_client
 * Tag list item for reference to a
 * @ref sip_security_client "Security-Client header" string.
 */
#define SIPTAG_SECURITY_CLIENT_STR_REF(x) siptag_security_client_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_security_client_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_security_client_v(sip_security_client_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_security_client_vr(sip_security_client_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_security_client_v(v)   (tag_value_t)(v)
#define siptag_security_client_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_security_server
 *
 * Tag list item for pointer to a @ref sip_security_server "Security-Server header"
 * structure #sip_security_server_t.
 *
 * The SIPTAG_SECURITY_SERVER() macro is used to include a tag item with a
 * pointer to a #sip_security_server_t structure in a tag list.
 *
 * @param x pointer to a #sip_security_server_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SECURITY_SERVER_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SECURITY_SERVER(x) siptag_security_server, siptag_security_server_v(x)

SOFIAPUBVAR tag_typedef_t siptag_security_server;

/**@ingroup sip_security_server
 * Tag list item for reference to a 
 * @ref sip_security_server "Security-Server header" pointer.
 */
#define SIPTAG_SECURITY_SERVER_REF(x) siptag_security_server_ref, siptag_security_server_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_security_server_ref;

/**@ingroup sip_security_server
 *
 * Tag list item for string with @ref sip_security_server "Security-Server header" value.
 *
 * The SIPTAG_SECURITY_SERVER_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_security_server_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_security_server "Security-Server header" value, or NULL.
 *
 * The string in SIPTAG_SECURITY_SERVER_STR() can be converted to a
 * #sip_security_server_t header structure by giving the string @a s has
 * second argument to function sip_security_server_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SECURITY_SERVER_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SECURITY_SERVER_STR(s) siptag_security_server_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_security_server_str;

/**@ingroup sip_security_server
 * Tag list item for reference to a
 * @ref sip_security_server "Security-Server header" string.
 */
#define SIPTAG_SECURITY_SERVER_STR_REF(x) siptag_security_server_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_security_server_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_security_server_v(sip_security_server_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_security_server_vr(sip_security_server_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_security_server_v(v)   (tag_value_t)(v)
#define siptag_security_server_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_security_verify
 *
 * Tag list item for pointer to a @ref sip_security_verify "Security-Verify header"
 * structure #sip_security_verify_t.
 *
 * The SIPTAG_SECURITY_VERIFY() macro is used to include a tag item with a
 * pointer to a #sip_security_verify_t structure in a tag list.
 *
 * @param x pointer to a #sip_security_verify_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SECURITY_VERIFY_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SECURITY_VERIFY(x) siptag_security_verify, siptag_security_verify_v(x)

SOFIAPUBVAR tag_typedef_t siptag_security_verify;

/**@ingroup sip_security_verify
 * Tag list item for reference to a 
 * @ref sip_security_verify "Security-Verify header" pointer.
 */
#define SIPTAG_SECURITY_VERIFY_REF(x) siptag_security_verify_ref, siptag_security_verify_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_security_verify_ref;

/**@ingroup sip_security_verify
 *
 * Tag list item for string with @ref sip_security_verify "Security-Verify header" value.
 *
 * The SIPTAG_SECURITY_VERIFY_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_security_verify_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_security_verify "Security-Verify header" value, or NULL.
 *
 * The string in SIPTAG_SECURITY_VERIFY_STR() can be converted to a
 * #sip_security_verify_t header structure by giving the string @a s has
 * second argument to function sip_security_verify_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SECURITY_VERIFY_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SECURITY_VERIFY_STR(s) siptag_security_verify_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_security_verify_str;

/**@ingroup sip_security_verify
 * Tag list item for reference to a
 * @ref sip_security_verify "Security-Verify header" string.
 */
#define SIPTAG_SECURITY_VERIFY_STR_REF(x) siptag_security_verify_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_security_verify_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_security_verify_v(sip_security_verify_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_security_verify_vr(sip_security_verify_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_security_verify_v(v)   (tag_value_t)(v)
#define siptag_security_verify_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_privacy
 *
 * Tag list item for pointer to a @ref sip_privacy "Privacy header"
 * structure #sip_privacy_t.
 *
 * The SIPTAG_PRIVACY() macro is used to include a tag item with a
 * pointer to a #sip_privacy_t structure in a tag list.
 *
 * @param x pointer to a #sip_privacy_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PRIVACY_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PRIVACY(x) siptag_privacy, siptag_privacy_v(x)

SOFIAPUBVAR tag_typedef_t siptag_privacy;

/**@ingroup sip_privacy
 * Tag list item for reference to a 
 * @ref sip_privacy "Privacy header" pointer.
 */
#define SIPTAG_PRIVACY_REF(x) siptag_privacy_ref, siptag_privacy_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_privacy_ref;

/**@ingroup sip_privacy
 *
 * Tag list item for string with @ref sip_privacy "Privacy header" value.
 *
 * The SIPTAG_PRIVACY_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_privacy_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_privacy "Privacy header" value, or NULL.
 *
 * The string in SIPTAG_PRIVACY_STR() can be converted to a
 * #sip_privacy_t header structure by giving the string @a s has
 * second argument to function sip_privacy_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PRIVACY_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PRIVACY_STR(s) siptag_privacy_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_privacy_str;

/**@ingroup sip_privacy
 * Tag list item for reference to a
 * @ref sip_privacy "Privacy header" string.
 */
#define SIPTAG_PRIVACY_STR_REF(x) siptag_privacy_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_privacy_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_privacy_v(sip_privacy_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_privacy_vr(sip_privacy_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_privacy_v(v)   (tag_value_t)(v)
#define siptag_privacy_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_etag
 *
 * Tag list item for pointer to a @ref sip_etag "SIP-ETag header"
 * structure #sip_etag_t.
 *
 * The SIPTAG_ETAG() macro is used to include a tag item with a
 * pointer to a #sip_etag_t structure in a tag list.
 *
 * @param x pointer to a #sip_etag_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ETAG_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ETAG(x) siptag_etag, siptag_etag_v(x)

SOFIAPUBVAR tag_typedef_t siptag_etag;

/**@ingroup sip_etag
 * Tag list item for reference to a 
 * @ref sip_etag "SIP-ETag header" pointer.
 */
#define SIPTAG_ETAG_REF(x) siptag_etag_ref, siptag_etag_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_etag_ref;

/**@ingroup sip_etag
 *
 * Tag list item for string with @ref sip_etag "SIP-ETag header" value.
 *
 * The SIPTAG_ETAG_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_etag_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_etag "SIP-ETag header" value, or NULL.
 *
 * The string in SIPTAG_ETAG_STR() can be converted to a
 * #sip_etag_t header structure by giving the string @a s has
 * second argument to function sip_etag_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ETAG_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ETAG_STR(s) siptag_etag_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_etag_str;

/**@ingroup sip_etag
 * Tag list item for reference to a
 * @ref sip_etag "SIP-ETag header" string.
 */
#define SIPTAG_ETAG_STR_REF(x) siptag_etag_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_etag_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_etag_v(sip_etag_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_etag_vr(sip_etag_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_etag_v(v)   (tag_value_t)(v)
#define siptag_etag_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_if_match
 *
 * Tag list item for pointer to a @ref sip_if_match "SIP-If-Match header"
 * structure #sip_if_match_t.
 *
 * The SIPTAG_IF_MATCH() macro is used to include a tag item with a
 * pointer to a #sip_if_match_t structure in a tag list.
 *
 * @param x pointer to a #sip_if_match_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_IF_MATCH_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_IF_MATCH(x) siptag_if_match, siptag_if_match_v(x)

SOFIAPUBVAR tag_typedef_t siptag_if_match;

/**@ingroup sip_if_match
 * Tag list item for reference to a 
 * @ref sip_if_match "SIP-If-Match header" pointer.
 */
#define SIPTAG_IF_MATCH_REF(x) siptag_if_match_ref, siptag_if_match_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_if_match_ref;

/**@ingroup sip_if_match
 *
 * Tag list item for string with @ref sip_if_match "SIP-If-Match header" value.
 *
 * The SIPTAG_IF_MATCH_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_if_match_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_if_match "SIP-If-Match header" value, or NULL.
 *
 * The string in SIPTAG_IF_MATCH_STR() can be converted to a
 * #sip_if_match_t header structure by giving the string @a s has
 * second argument to function sip_if_match_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_IF_MATCH_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_IF_MATCH_STR(s) siptag_if_match_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_if_match_str;

/**@ingroup sip_if_match
 * Tag list item for reference to a
 * @ref sip_if_match "SIP-If-Match header" string.
 */
#define SIPTAG_IF_MATCH_STR_REF(x) siptag_if_match_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_if_match_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_if_match_v(sip_if_match_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_if_match_vr(sip_if_match_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_if_match_v(v)   (tag_value_t)(v)
#define siptag_if_match_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_mime_version
 *
 * Tag list item for pointer to a @ref sip_mime_version "MIME-Version header"
 * structure #sip_mime_version_t.
 *
 * The SIPTAG_MIME_VERSION() macro is used to include a tag item with a
 * pointer to a #sip_mime_version_t structure in a tag list.
 *
 * @param x pointer to a #sip_mime_version_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_MIME_VERSION_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_MIME_VERSION(x) siptag_mime_version, siptag_mime_version_v(x)

SOFIAPUBVAR tag_typedef_t siptag_mime_version;

/**@ingroup sip_mime_version
 * Tag list item for reference to a 
 * @ref sip_mime_version "MIME-Version header" pointer.
 */
#define SIPTAG_MIME_VERSION_REF(x) siptag_mime_version_ref, siptag_mime_version_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_mime_version_ref;

/**@ingroup sip_mime_version
 *
 * Tag list item for string with @ref sip_mime_version "MIME-Version header" value.
 *
 * The SIPTAG_MIME_VERSION_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_mime_version_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_mime_version "MIME-Version header" value, or NULL.
 *
 * The string in SIPTAG_MIME_VERSION_STR() can be converted to a
 * #sip_mime_version_t header structure by giving the string @a s has
 * second argument to function sip_mime_version_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_MIME_VERSION_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_MIME_VERSION_STR(s) siptag_mime_version_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_mime_version_str;

/**@ingroup sip_mime_version
 * Tag list item for reference to a
 * @ref sip_mime_version "MIME-Version header" string.
 */
#define SIPTAG_MIME_VERSION_STR_REF(x) siptag_mime_version_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_mime_version_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_mime_version_v(sip_mime_version_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_mime_version_vr(sip_mime_version_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_mime_version_v(v)   (tag_value_t)(v)
#define siptag_mime_version_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_content_type
 *
 * Tag list item for pointer to a @ref sip_content_type "Content-Type header"
 * structure #sip_content_type_t.
 *
 * The SIPTAG_CONTENT_TYPE() macro is used to include a tag item with a
 * pointer to a #sip_content_type_t structure in a tag list.
 *
 * @param x pointer to a #sip_content_type_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_TYPE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_TYPE(x) siptag_content_type, siptag_content_type_v(x)

SOFIAPUBVAR tag_typedef_t siptag_content_type;

/**@ingroup sip_content_type
 * Tag list item for reference to a 
 * @ref sip_content_type "Content-Type header" pointer.
 */
#define SIPTAG_CONTENT_TYPE_REF(x) siptag_content_type_ref, siptag_content_type_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_type_ref;

/**@ingroup sip_content_type
 *
 * Tag list item for string with @ref sip_content_type "Content-Type header" value.
 *
 * The SIPTAG_CONTENT_TYPE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_content_type_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_content_type "Content-Type header" value, or NULL.
 *
 * The string in SIPTAG_CONTENT_TYPE_STR() can be converted to a
 * #sip_content_type_t header structure by giving the string @a s has
 * second argument to function sip_content_type_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_TYPE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_TYPE_STR(s) siptag_content_type_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_content_type_str;

/**@ingroup sip_content_type
 * Tag list item for reference to a
 * @ref sip_content_type "Content-Type header" string.
 */
#define SIPTAG_CONTENT_TYPE_STR_REF(x) siptag_content_type_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_type_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_content_type_v(sip_content_type_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_content_type_vr(sip_content_type_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_content_type_v(v)   (tag_value_t)(v)
#define siptag_content_type_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_content_encoding
 *
 * Tag list item for pointer to a @ref sip_content_encoding "Content-Encoding header"
 * structure #sip_content_encoding_t.
 *
 * The SIPTAG_CONTENT_ENCODING() macro is used to include a tag item with a
 * pointer to a #sip_content_encoding_t structure in a tag list.
 *
 * @param x pointer to a #sip_content_encoding_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_ENCODING_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_ENCODING(x) siptag_content_encoding, siptag_content_encoding_v(x)

SOFIAPUBVAR tag_typedef_t siptag_content_encoding;

/**@ingroup sip_content_encoding
 * Tag list item for reference to a 
 * @ref sip_content_encoding "Content-Encoding header" pointer.
 */
#define SIPTAG_CONTENT_ENCODING_REF(x) siptag_content_encoding_ref, siptag_content_encoding_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_encoding_ref;

/**@ingroup sip_content_encoding
 *
 * Tag list item for string with @ref sip_content_encoding "Content-Encoding header" value.
 *
 * The SIPTAG_CONTENT_ENCODING_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_content_encoding_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_content_encoding "Content-Encoding header" value, or NULL.
 *
 * The string in SIPTAG_CONTENT_ENCODING_STR() can be converted to a
 * #sip_content_encoding_t header structure by giving the string @a s has
 * second argument to function sip_content_encoding_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_ENCODING_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_ENCODING_STR(s) siptag_content_encoding_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_content_encoding_str;

/**@ingroup sip_content_encoding
 * Tag list item for reference to a
 * @ref sip_content_encoding "Content-Encoding header" string.
 */
#define SIPTAG_CONTENT_ENCODING_STR_REF(x) siptag_content_encoding_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_encoding_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_content_encoding_v(sip_content_encoding_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_content_encoding_vr(sip_content_encoding_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_content_encoding_v(v)   (tag_value_t)(v)
#define siptag_content_encoding_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_content_language
 *
 * Tag list item for pointer to a @ref sip_content_language "Content-Language header"
 * structure #sip_content_language_t.
 *
 * The SIPTAG_CONTENT_LANGUAGE() macro is used to include a tag item with a
 * pointer to a #sip_content_language_t structure in a tag list.
 *
 * @param x pointer to a #sip_content_language_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_LANGUAGE_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_LANGUAGE(x) siptag_content_language, siptag_content_language_v(x)

SOFIAPUBVAR tag_typedef_t siptag_content_language;

/**@ingroup sip_content_language
 * Tag list item for reference to a 
 * @ref sip_content_language "Content-Language header" pointer.
 */
#define SIPTAG_CONTENT_LANGUAGE_REF(x) siptag_content_language_ref, siptag_content_language_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_language_ref;

/**@ingroup sip_content_language
 *
 * Tag list item for string with @ref sip_content_language "Content-Language header" value.
 *
 * The SIPTAG_CONTENT_LANGUAGE_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_content_language_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_content_language "Content-Language header" value, or NULL.
 *
 * The string in SIPTAG_CONTENT_LANGUAGE_STR() can be converted to a
 * #sip_content_language_t header structure by giving the string @a s has
 * second argument to function sip_content_language_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_LANGUAGE_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_LANGUAGE_STR(s) siptag_content_language_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_content_language_str;

/**@ingroup sip_content_language
 * Tag list item for reference to a
 * @ref sip_content_language "Content-Language header" string.
 */
#define SIPTAG_CONTENT_LANGUAGE_STR_REF(x) siptag_content_language_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_language_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_content_language_v(sip_content_language_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_content_language_vr(sip_content_language_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_content_language_v(v)   (tag_value_t)(v)
#define siptag_content_language_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_content_disposition
 *
 * Tag list item for pointer to a @ref sip_content_disposition "Content-Disposition header"
 * structure #sip_content_disposition_t.
 *
 * The SIPTAG_CONTENT_DISPOSITION() macro is used to include a tag item with a
 * pointer to a #sip_content_disposition_t structure in a tag list.
 *
 * @param x pointer to a #sip_content_disposition_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_DISPOSITION_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_DISPOSITION(x) siptag_content_disposition, siptag_content_disposition_v(x)

SOFIAPUBVAR tag_typedef_t siptag_content_disposition;

/**@ingroup sip_content_disposition
 * Tag list item for reference to a 
 * @ref sip_content_disposition "Content-Disposition header" pointer.
 */
#define SIPTAG_CONTENT_DISPOSITION_REF(x) siptag_content_disposition_ref, siptag_content_disposition_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_disposition_ref;

/**@ingroup sip_content_disposition
 *
 * Tag list item for string with @ref sip_content_disposition "Content-Disposition header" value.
 *
 * The SIPTAG_CONTENT_DISPOSITION_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_content_disposition_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_content_disposition "Content-Disposition header" value, or NULL.
 *
 * The string in SIPTAG_CONTENT_DISPOSITION_STR() can be converted to a
 * #sip_content_disposition_t header structure by giving the string @a s has
 * second argument to function sip_content_disposition_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_DISPOSITION_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_DISPOSITION_STR(s) siptag_content_disposition_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_content_disposition_str;

/**@ingroup sip_content_disposition
 * Tag list item for reference to a
 * @ref sip_content_disposition "Content-Disposition header" string.
 */
#define SIPTAG_CONTENT_DISPOSITION_STR_REF(x) siptag_content_disposition_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_disposition_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_content_disposition_v(sip_content_disposition_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_content_disposition_vr(sip_content_disposition_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_content_disposition_v(v)   (tag_value_t)(v)
#define siptag_content_disposition_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_content_length
 *
 * Tag list item for pointer to a @ref sip_content_length "Content-Length header"
 * structure #sip_content_length_t.
 *
 * The SIPTAG_CONTENT_LENGTH() macro is used to include a tag item with a
 * pointer to a #sip_content_length_t structure in a tag list.
 *
 * @param x pointer to a #sip_content_length_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_LENGTH_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_LENGTH(x) siptag_content_length, siptag_content_length_v(x)

SOFIAPUBVAR tag_typedef_t siptag_content_length;

/**@ingroup sip_content_length
 * Tag list item for reference to a 
 * @ref sip_content_length "Content-Length header" pointer.
 */
#define SIPTAG_CONTENT_LENGTH_REF(x) siptag_content_length_ref, siptag_content_length_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_length_ref;

/**@ingroup sip_content_length
 *
 * Tag list item for string with @ref sip_content_length "Content-Length header" value.
 *
 * The SIPTAG_CONTENT_LENGTH_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_content_length_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_content_length "Content-Length header" value, or NULL.
 *
 * The string in SIPTAG_CONTENT_LENGTH_STR() can be converted to a
 * #sip_content_length_t header structure by giving the string @a s has
 * second argument to function sip_content_length_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_CONTENT_LENGTH_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_CONTENT_LENGTH_STR(s) siptag_content_length_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_content_length_str;

/**@ingroup sip_content_length
 * Tag list item for reference to a
 * @ref sip_content_length "Content-Length header" string.
 */
#define SIPTAG_CONTENT_LENGTH_STR_REF(x) siptag_content_length_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_content_length_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_content_length_v(sip_content_length_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_content_length_vr(sip_content_length_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_content_length_v(v)   (tag_value_t)(v)
#define siptag_content_length_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_unknown
 *
 * Tag list item for pointer to a @ref sip_unknown "unknown headers"
 * structure #sip_unknown_t.
 *
 * The SIPTAG_UNKNOWN() macro is used to include a tag item with a
 * pointer to a #sip_unknown_t structure in a tag list.
 *
 * @param x pointer to a #sip_unknown_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_UNKNOWN_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_UNKNOWN(x) siptag_unknown, siptag_unknown_v(x)

SOFIAPUBVAR tag_typedef_t siptag_unknown;

/**@ingroup sip_unknown
 * Tag list item for reference to a 
 * @ref sip_unknown "unknown headers" pointer.
 */
#define SIPTAG_UNKNOWN_REF(x) siptag_unknown_ref, siptag_unknown_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_unknown_ref;

/**@ingroup sip_unknown
 *
 * Tag list item for string with @ref sip_unknown "unknown headers" value.
 *
 * The SIPTAG_UNKNOWN_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_unknown_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_unknown "unknown headers" value, or NULL.
 *
 * The string in SIPTAG_UNKNOWN_STR() can be converted to a
 * #sip_unknown_t header structure by giving the string @a s has
 * second argument to function sip_unknown_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_UNKNOWN_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_UNKNOWN_STR(s) siptag_unknown_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_unknown_str;

/**@ingroup sip_unknown
 * Tag list item for reference to a
 * @ref sip_unknown "unknown headers" string.
 */
#define SIPTAG_UNKNOWN_STR_REF(x) siptag_unknown_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_unknown_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_unknown_v(sip_unknown_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_unknown_vr(sip_unknown_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_unknown_v(v)   (tag_value_t)(v)
#define siptag_unknown_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_error
 *
 * Tag list item for pointer to a @ref sip_error "erroneous headers"
 * structure #sip_error_t.
 *
 * The SIPTAG_ERROR() macro is used to include a tag item with a
 * pointer to a #sip_error_t structure in a tag list.
 *
 * @param x pointer to a #sip_error_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ERROR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ERROR(x) siptag_error, siptag_error_v(x)

SOFIAPUBVAR tag_typedef_t siptag_error;

/**@ingroup sip_error
 * Tag list item for reference to a 
 * @ref sip_error "erroneous headers" pointer.
 */
#define SIPTAG_ERROR_REF(x) siptag_error_ref, siptag_error_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_error_ref;

/**@ingroup sip_error
 *
 * Tag list item for string with @ref sip_error "erroneous headers" value.
 *
 * The SIPTAG_ERROR_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_error_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_error "erroneous headers" value, or NULL.
 *
 * The string in SIPTAG_ERROR_STR() can be converted to a
 * #sip_error_t header structure by giving the string @a s has
 * second argument to function sip_error_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_ERROR_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_ERROR_STR(s) siptag_error_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_error_str;

/**@ingroup sip_error
 * Tag list item for reference to a
 * @ref sip_error "erroneous headers" string.
 */
#define SIPTAG_ERROR_STR_REF(x) siptag_error_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_error_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_error_v(sip_error_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_error_vr(sip_error_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_error_v(v)   (tag_value_t)(v)
#define siptag_error_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_separator
 *
 * Tag list item for pointer to a @ref sip_separator "separator line between headers and body"
 * structure #sip_separator_t.
 *
 * The SIPTAG_SEPARATOR() macro is used to include a tag item with a
 * pointer to a #sip_separator_t structure in a tag list.
 *
 * @param x pointer to a #sip_separator_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SEPARATOR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SEPARATOR(x) siptag_separator, siptag_separator_v(x)

SOFIAPUBVAR tag_typedef_t siptag_separator;

/**@ingroup sip_separator
 * Tag list item for reference to a 
 * @ref sip_separator "separator line between headers and body" pointer.
 */
#define SIPTAG_SEPARATOR_REF(x) siptag_separator_ref, siptag_separator_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_separator_ref;

/**@ingroup sip_separator
 *
 * Tag list item for string with @ref sip_separator "separator line between headers and body" value.
 *
 * The SIPTAG_SEPARATOR_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_separator_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_separator "separator line between headers and body" value, or NULL.
 *
 * The string in SIPTAG_SEPARATOR_STR() can be converted to a
 * #sip_separator_t header structure by giving the string @a s has
 * second argument to function sip_separator_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_SEPARATOR_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_SEPARATOR_STR(s) siptag_separator_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_separator_str;

/**@ingroup sip_separator
 * Tag list item for reference to a
 * @ref sip_separator "separator line between headers and body" string.
 */
#define SIPTAG_SEPARATOR_STR_REF(x) siptag_separator_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_separator_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_separator_v(sip_separator_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_separator_vr(sip_separator_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_separator_v(v)   (tag_value_t)(v)
#define siptag_separator_vr(vp) (tag_value_t)(vp)
#endif

/**@ingroup sip_payload
 *
 * Tag list item for pointer to a @ref sip_payload "message payload"
 * structure #sip_payload_t.
 *
 * The SIPTAG_PAYLOAD() macro is used to include a tag item with a
 * pointer to a #sip_payload_t structure in a tag list.
 *
 * @param x pointer to a #sip_payload_t structure, or NULL.
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PAYLOAD_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PAYLOAD(x) siptag_payload, siptag_payload_v(x)

SOFIAPUBVAR tag_typedef_t siptag_payload;

/**@ingroup sip_payload
 * Tag list item for reference to a 
 * @ref sip_payload "message payload" pointer.
 */
#define SIPTAG_PAYLOAD_REF(x) siptag_payload_ref, siptag_payload_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_payload_ref;

/**@ingroup sip_payload
 *
 * Tag list item for string with @ref sip_payload "message payload" value.
 *
 * The SIPTAG_PAYLOAD_STR() macro is used to include a tag item with a 
 * string containing value of a #sip_payload_t header in a tag list.
 *
 * @param s pointer to a string containing 
 *    @ref sip_payload "message payload" value, or NULL.
 *
 * The string in SIPTAG_PAYLOAD_STR() can be converted to a
 * #sip_payload_t header structure by giving the string @a s has
 * second argument to function sip_payload_make().
 *
 * The corresponding tag taking reference parameter is 
 * SIPTAG_PAYLOAD_STR_REF().
 *
 *
 * @HIDE
 */
#define SIPTAG_PAYLOAD_STR(s) siptag_payload_str, tag_str_v(s)

SOFIAPUBVAR tag_typedef_t siptag_payload_str;

/**@ingroup sip_payload
 * Tag list item for reference to a
 * @ref sip_payload "message payload" string.
 */
#define SIPTAG_PAYLOAD_STR_REF(x) siptag_payload_str_ref, tag_str_vr(&(x))
SOFIAPUBVAR tag_typedef_t siptag_payload_str_ref;

#if SU_HAVE_INLINE
su_inline tag_value_t
siptag_payload_v(sip_payload_t const *v)
{ return (tag_value_t)v; }
su_inline tag_value_t
siptag_payload_vr(sip_payload_t const **vp)
{ return (tag_value_t)vp; }
#else
#define siptag_payload_v(v)   (tag_value_t)(v)
#define siptag_payload_vr(vp) (tag_value_t)(vp)
#endif

SOFIA_END_DECLS
#endif
