/*
 * ----------------------------------------------------------------
 * Softgun Main Programm
 *	Create the machine mentioned in configfile and run the
 *	emulator	
 *
 * (C) 2004  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------------------
 */
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>

#include "debugvars.h"
#include "fio.h"
#include "signode.h"
#include "mmu.h"
#include "debugserver.h"
#include "gdebug.h"
#include "loader.h"
#include "configfile.h"
#include "shlib.h"
#include "boards/boards.h"

static char *imagename=NULL;
static char *configfname=NULL;

static void
help() {
	fprintf(stderr,"Usage:\n");
	fprintf(stderr,"\tns9750 [options] <image to load>\n");
	fprintf(stderr,"Options:\n");
	fprintf(stderr,"-l <loadaddr>: Load to address (not for SRecords !)\n");
	fprintf(stderr,"-c <configfile>: Use non default configfile\n");
	fprintf(stderr,"-g <startaddr>:  Use non default startaddress\n");
	fprintf(stderr,"\n");
}

static int 
read_configfile() {
	char *str = alloca(100+strlen(getenv("HOME")));
	sprintf(str,"%s/.emuconfig",getenv("HOME"));

	if(configfname) {
		if(Config_ReadFile(configfname)>=0) {
			return 0;
		} else {
			fprintf(stderr,"Can not read configfile %s\n",configfname);
			exit(3255);
		}
	}
	if(Config_ReadFile(str)>=0) {
		return 0;
	}
	fprintf(stderr,"Error: Can Not read configuration file %s\n",str);
	exit(1843);
}

static void
parse_commandline(int argc,char *argv[]) {
	char confstr[100];
	while(argc) {
		if(argv[0][0]=='-') {
			switch(argv[0][1]) {
				case 'c':
					if(argc>1) {
						configfname=argv[1];
						argc--;argv++;
					} else {
						fprintf(stderr,"Missing name of configuration file\n");
						exit(74530);
					}
					break;
				case 'l':
					if(argc>1) {
						snprintf(confstr,100,"[loader]\nload_address: %s\n",argv[1]);
						Config_AddString(confstr);
						argc--;argv++;
					} else {
						fprintf(stderr,"Missing argument\n");
						help();
						exit(245);
					}
					break;

				case 'g':
					if(argc>1) {
						snprintf(confstr,100,"\n[global]\nstart_address: %s\n",argv[1]);
						fprintf(stderr,"**********Add confstr %s\n",confstr);
						Config_AddString(confstr);
						argc--;argv++;
					} else {
						fprintf(stderr,"Missing argument\n");
						help();
						exit(245);
					}
					break;

				default:
					fprintf(stderr,"unknown argument \"%s\"\n",argv[0]);
					help();
					exit(3245);
			}
		} else {
			imagename=argv[0];
		} 
		argc--;argv++;
	}
}

/*
 * ------------------------------------------------------------------
 * main
 *	Create board from configfile, Then run it
 * ------------------------------------------------------------------
 */

int
main(int argc,char *argv[]) {
	char *boardname;
	Board *board;
	uint32_t load_address;
	signal(SIGPIPE, SIG_IGN);
	parse_commandline(argc-1,argv+1);
	read_configfile();
	FIO_Init();
	DebugVars_Init();
	SignodesInit();
	Boards_Init();
	Shlibs_Init();
	boardname = Config_ReadVar("global","board");
	if(!boardname) {
		fprintf(stderr,"No Board selected in Configfile global section\n");
		exit(1);
	}
	board = Board_Find(boardname);
	if(!board) {
		exit(1);
	}
	if(Board_DefaultConfig(board)) {
	//	fprintf(stderr,"defaultconfig %s\n",Board_DefaultConfig(board));
		Config_AddString(Board_DefaultConfig(board));
	}
	Board_Create(board);
	Config_ReadUInt32(&load_address,"loader","load_address");
	if(imagename) {
		if(Load_AutoType(imagename,load_address)<0) {
			exit(1);
		}
	}
	Debugger_New(); 
	Board_Run(board);
	exit(0);
}
