/*
 * USB Protocol definiton header file
 *
 * (C) 2006 Jochen Karrer
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ----------------------------------------------------
 */

#define USB_PID_OUT             (1)
#define USB_PID_IN              (9)
#define USB_PID_SOF             (5)
#define USB_PID_SETUP           (0xd)

/* Data packets */
#define USB_PID_DATA0           (0x3)
#define USB_PID_DATA1           (0xb)
#define USB_PID_DATA2           (0x7)
#define USB_PID_MDATA           (0xf)

/* Handshake packets */
#define USB_PID_ACK             (0x2)
#define USB_PID_NACK            (0xa)
#define USB_PID_STALL           (0xe)
#define USB_PID_NYET            (0x6)
#define USB_PID_ERR             (0xc)

#define USB_PID_PRE             (0xc)
#define USB_PID_SPLIT           (0x8)
#define USB_PID_PING            (0x4)
#define USB_PID_RESERVED        (0)

#define USB_MAX_PKTLEN (1024)
typedef struct UsbPacket {
        uint8_t pid;
        uint8_t addr;   /* 7  Bits */
        uint8_t epnt;   /* 4  Bits */
        uint16_t fnumb; /* 11 Bits, only in SOF */
        uint8_t data[USB_MAX_PKTLEN];
	uint8_t token_crc;	/* 5 Bits */
        uint16_t crc16;
        int len;
} UsbPacket;

