#include <avr8_cpu.h>
#include <instructions_avr8.h>
#include <idecode_avr8.h>
#include <diskimage.h>
#include <cycletimer.h>
#include <configfile.h>

typedef struct AVR8_Variant {
        char *name;
        int flashwords;
        int srambytes;
} AVR8_Variant;

AVR8_Variant avr8_variants[] = {
        {
                .name = "ATMega8",
                .flashwords = 4096,
                .srambytes = 1024
        }
};

AVR8_Cpu gavr8;

void
AVR8_Run()  {
	uint32_t icode;
	AVR8_InstructionProc *iproc;
	while(1) {
		icode = ICODE = AVR8_ReadAppMem(GET_REG_PC);
		iproc = AVR8_InstructionProcFind(icode);
		iproc();
		SET_REG_PC(GET_REG_PC+2);
		fprintf(stderr,"PC: %08x\n",GET_REG_PC);
	}
}

/*
 * ----------------------------------------------------------
 * AVR8_Init
 *      Initialize the CPU.
 * ----------------------------------------------------------
 */
void
AVR8_Init(const char *instancename)
{
        AVR8_Variant *var;
	char *variantname;
	char *flashname;
	char *imagedir;
	int32_t cpu_clock = 20000000;
        int nr_variants = sizeof(avr8_variants) / sizeof(AVR8_Variant);
        int i;
	variantname = Config_ReadVar(instancename,"variant");
	if(!variantname) {
		fprintf(stderr,"No CPU variant selected\n");
		exit(1);
	}
        fprintf(stderr,"%d variants\n",nr_variants);
        for(i=0;i<nr_variants;i++) {
                var = &avr8_variants[i];
                if(strcmp(var->name,variantname) == 0) {
                        break;
                }
        }
        if(i == nr_variants) {
                fprintf(stderr,"Unknown AVR8 CPU \"%s\"\n",variantname);
                exit(1);
        }
        memset(&gavr8,0,sizeof(gavr8));
	imagedir = Config_ReadVar("global","imagedir");
	if(!imagedir) {
		fprintf(stderr,"No directory given for AVR8 flash diskimage\n");
		exit(1);
	}
	flashname = alloca(strlen(instancename) + strlen(imagedir) +20);
	sprintf(flashname,"%s/%s.flash",imagedir,instancename);
	gavr8.flash_di = DiskImage_Open(flashname,var->flashwords << 1,DI_RDWR | DI_CREAT_FF);
	if(!gavr8.flash_di) {
		fprintf(stderr,"Can not create or open the AVR internal flash image\n");
		exit(1);
	}
	gavr8.appmem = DiskImage_Mmap(gavr8.flash_di);
	gavr8.appmem_words = var->flashwords;
	AVR8_IDecoderNew();
	Config_ReadInt32(&cpu_clock,"global","cpu_clock");
	CycleTimers_Init(cpu_clock);
}

