/*
 * ------------------------------------------------------------------------
 * clock.h
 *      Emulation of clock trees
 *
 * (C) 2006 Jochen Karrer 
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * ------------------------------------------------------------------------
 */

#include "xy_hash.h"
typedef double Frequency_t;

struct Clock;
typedef void ClockTraceProc(struct Clock *clock,Frequency_t freq,void *clientData);

typedef struct ClockTrace {
        ClockTraceProc *proc;
        void *clientData;
        struct ClockTrace *next;
        int isactive; /* Sanity check to avoid recursion in invokation */
} ClockTrace_t;

typedef struct Clock {
	char *name;
	Frequency_t hz;
	ClockTrace_t *traceHead;
	/* derivation */
	ClockTrace_t *master_trace; 	/* trace in master clocks trace list */
	struct Clock *master; 		
	double derivation_ratio;
	uint64_t derivation_nom;
	uint64_t derivation_denom;
	uint64_t derivation_phase;

	struct Clock *first_slave;
	struct Clock *next_slave;
	XY_HashEntry *hash_entry;
} Clock_t;


void Clock_SetFreq(Clock_t *clock,Frequency_t hz);
//ClockTrace_t *Clock_Trace(Clock_t *clock,ClockTraceProc *proc,void *traceData);
//void Clock_Untrace(Clock_t *,ClockTrace_t *);
Clock_t * Clock_New(const char *format,...)  __attribute__ ((format (printf, 1, 2)));;

static inline Frequency_t 
Clock_Freq(Clock_t *clock) {
	return clock->hz;
}

/*
 * -------------------------------------------------------------------
 * Make a clock to be derived from another clock by a fraction
 * -------------------------------------------------------------------
 */

void Clock_MakeDerived(Clock_t *clock,Clock_t *master,uint64_t nom,uint64_t denom);
void Clock_Decouple(Clock_t *slave);
void Clock_DumpTree(Clock_t *top);
void ClocksInit(void);
/* Special versions of make derived and decouple with ratio 1:1 and names */
void Clock_Link(const char *slave,const char *master);
void Clock_Unlink(const char *slave);

