/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef ENABLE_GTK

#ifndef DGRAPHIC_H
#define DGRAPHIC_H

extern GtkWidget *windaemon;
extern GtkWidget *crossfade_v;
extern GtkWidget *cross_v_active;
extern GtkWidget *crossfade_b;
extern GtkWidget *cross_b_active;
extern GtkWidget *gdaemon_box;
extern GtkWidget *ledbar_dl;
extern GtkWidget *ledbar_dr;
extern GtkWidget *autofader;

extern pthread_mutex_t gdaemon_mutex;

extern int gpid;
extern gint gstatusbar_id;
extern GtkWidget *gstatusbar;
extern int stop_50_cent;

/* main.c */
gint on_dquit_activate (GtkMenuItem *, gpointer);
GtkWidget *create_windaemon (void);

/* ../gtk/about.c */
void on_about_activate (GtkMenuItem *, gpointer);

/* mix.c */
GtkWidget *gdaemon_add_mix (char *, daemon_client *);
void gdaemon_del_mix (daemon_client *);

/* player.c */
void on_dplayer_activate (GtkMenuItem *, gpointer);
void run_gsplayer (char *);
int gtimeout (gpointer);

/* volumes.c */
double gdaemon_volume_get (daemon_client *);
double gdaemon_volume_r_get (daemon_client *);
double gdaemon_volume_l_get (daemon_client *);
void on_dvolume_value_changed (GtkWidget *, gpointer);
void on_dbalance_value_changed (GtkWidget *, gpointer);
void on_solo_toggled (GtkWidget *, gpointer);
void on_mute_toggled (GtkWidget *, gpointer);

/* statusbar.c */
void msg_gstatusbar (char *, ...);

/* crossfade_v.c */
GtkWidget *create_crossfade_v (void);
void crossfade_v_hide (GtkWidget *, gpointer);
void crossfade_v_show (GtkWidget *, gpointer);
void crossfade_v_value_changed (GtkWidget *, gpointer);
void crossfade_v_up_toggled (GtkWidget *, gpointer);
void crossfade_v_down_toggled (GtkWidget *, gpointer);

/* crossfade_b.c */
GtkWidget *create_crossfade_b (void);
void crossfade_b_hide (GtkWidget *, gpointer);
void crossfade_b_show (GtkWidget *, gpointer);
void crossfade_b_value_changed (GtkWidget *, gpointer);
void crossfade_b_up_toggled (GtkWidget *, gpointer);
void crossfade_b_down_toggled (GtkWidget *, gpointer);

/* autofader.c */
GtkWidget *create_autofader (void);
void autofader_hide (GtkWidget *, gpointer);
void autofader_show (GtkWidget *, gpointer);
void autofader_value_changed (GtkWidget *, gpointer);
void autofader_toggled (GtkWidget *, gpointer);

/* ledbar.c */
int ledbar_d_timeout (gpointer);

#endif

#endif

/* EOF */
