/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "../player.h"
#include "../output.h"
#include "../file.h"
#include "../other.h"
#include "../format.h"
#include "../sock.h"
#include "../sds/sds.h"
#include "graphic.h"

static int input_no_rec = 0;

#ifdef ENABLE_DAEMON
int input_daemon_input_get_data (format_data_daemon_input *);
#endif
#ifdef ENABLE_MIC
int input_mic_get_data (format_data_mic *);
#endif

#ifdef ENABLE_MIC
void
on_mic_activate (GtkMenuItem * menuitem, gtk_element_input * p)
{
  if (input_no_rec)
    return;

  if (!p)
    fatal (_("Internal error."));

  if (!play->microphone)
    {

      format_data_mic *data;

      format_add (TYPE_MIC);
      data = play->formats[TYPE_MIC - 1]->data;

      if (input_mic_get_data (data))
	{
	  input_no_rec = 1;

	  if (play->daemon_input)
	    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
					    (p->t_daemon_input), TRUE);
	  else
	    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
					    (p->t_playlist), TRUE);

	  input_no_rec = 0;
	  return;
	}

      play->microphone = 1;

#ifdef ENABLE_DAEMON
      play->daemon_input = 0;
#endif

      events.next = -1;
      events.skip = 1;
      events.stop = 0;
      events.pause = 0;

      pthread_cond_signal (&play->p_pop);

      output_close ();

      gtk_widget_set_sensitive (p->playlist, FALSE);
      gtk_widget_set_sensitive (p->buttons, FALSE);
    }
}
#endif

void
on_playlist_activate (GtkMenuItem * menuitem, gtk_element_input * p)
{
  if (input_no_rec)
    return;

  if (!p)
    fatal (_("Internal error."));

  if (0
#ifdef ENABLE_MIC
      || play->microphone
#endif
#ifdef ENABLE_DAEMON
      || play->daemon_input
#endif
    )
    {

#ifdef ENABLE_DAEMON
      play->daemon_input = 0;
#endif

#ifdef ENABLE_MIC
      play->microphone = 0;
#endif

      events.next = -1;
      events.skip = 1;

      output_close ();

      gtk_widget_set_sensitive (p->playlist, TRUE);
      gtk_widget_set_sensitive (p->buttons, TRUE);
    }
}

#ifdef ENABLE_DAEMON

struct daemon_e_s
{
  GtkWidget *u;
  GtkWidget *t;
} daemon_e;

void daemon_input_tcp (GtkWidget *, gpointer);
void daemon_input_unix (GtkWidget *, gpointer);


void
on_daemon_input_activate (GtkMenuItem * menuitem, gtk_element_input * p)
{

  if (input_no_rec)
    return;

  if (!p)
    fatal (_("Internal error."));

  if (!play->daemon_input)
    {
      format_data_daemon_input *data;

      if (!play->daemon_input_opt)
	if (!(play->daemon_input_opt = strdup ("tcp")))
	  fatal ("Error: memory.");

      format_add (TYPE_DAEMON_INPUT);
      data = play->formats[TYPE_DAEMON_INPUT - 1]->data;

      if (input_daemon_input_get_data (data))
	{
	  input_no_rec = 1;

#ifdef ENABLE_MIC	  
	  if (play->microphone)
	    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
					    (p->t_microphone), TRUE);
	  else
#endif		  
	    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
					    (p->t_playlist), TRUE);

	  input_no_rec = 0;

	  free (play->daemon_input_opt);
	  play->daemon_input_opt = NULL;
	  return;
	}

      play->daemon_input = 1;

#ifdef ENABLE_MIC
      play->microphone = 0;
#endif

      events.next = -1;
      events.skip = 1;
      events.stop = 0;
      events.pause = 0;

      output_close ();

      pthread_cond_signal (&play->p_pop);

      gtk_widget_set_sensitive (p->playlist, FALSE);
      gtk_widget_set_sensitive (p->buttons, FALSE);
    }
}

int
input_daemon_input_get_data (format_data_daemon_input * data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *frame;
  GtkWidget *radiobutton;
  GtkWidget *stock;
  GtkWidget *label;
  GSList *group= NULL;

  GtkWidget *socket;

  GtkWidget *server;
  GtkWidget *port;

  GtkAdjustment *port_adj;

  GtkWidget *box_unix;
  GtkWidget *table_tcp;

  int ret = 1;
  char buf[SIZE_BUFFER];

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - SdS configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, GTK_STOCK_CANCEL,
				 GTK_RESPONSE_CANCEL, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);

  radiobutton = gtk_radio_button_new_with_mnemonic (group, _("Unix Socket"));
  group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton));
  gtk_frame_set_label_widget (GTK_FRAME (frame), radiobutton);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);

  box_unix = gtk_hbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), box_unix);

  daemon_e.u = box_unix;
  g_signal_connect ((gpointer) radiobutton, "toggled",
		    G_CALLBACK (daemon_input_unix), NULL);

  label = gtk_label_new (_("Socket File: "));
  gtk_box_pack_start (GTK_BOX (box_unix), label, FALSE, FALSE, 0);

  socket = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (box_unix), socket, TRUE, TRUE, 0);
  snprintf (buf, SIZE_BUFFER, "AUTO");
  gtk_entry_set_text (GTK_ENTRY (socket), buf);

  frame = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);

  radiobutton = gtk_radio_button_new_with_mnemonic (group, _("Tcp Socket"));
  group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton));
  gtk_frame_set_label_widget (GTK_FRAME (frame), radiobutton);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), FALSE);

  table_tcp = gtk_table_new (0, 0, FALSE);
  gtk_container_add (GTK_CONTAINER (frame), table_tcp);

  daemon_e.t = table_tcp;
  g_signal_connect ((gpointer) radiobutton, "toggled",
		    G_CALLBACK (daemon_input_tcp), NULL);

  label = gtk_label_new (_("Server: "));
  gtk_table_attach (GTK_TABLE (table_tcp), label, 0, 1, 0, 1, GTK_FILL,
		    GTK_FILL, 0, 0);

  server = gtk_entry_new ();
  gtk_table_attach (GTK_TABLE (table_tcp), server, 1, 2, 0, 1,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);
  gtk_entry_set_text (GTK_ENTRY (server), "localhost");

  label = gtk_label_new (_("Port: "));
  gtk_table_attach (GTK_TABLE (table_tcp), label, 0, 1, 1, 2, GTK_FILL,
		    GTK_FILL, 0, 0);

  port_adj =
    (GtkAdjustment *) gtk_adjustment_new (SDS_PORT, 0, 65536, 1, 10, 10);
  port = gtk_spin_button_new (port_adj, 1, 0);
  gtk_table_attach (GTK_TABLE (table_tcp), port, 1, 2, 1, 2,
		    GTK_FILL | GTK_EXPAND, GTK_FILL, 0, 0);

  gtk_widget_show_all (box);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton), TRUE);
  gtk_widget_set_sensitive (daemon_e.u, FALSE);
  gtk_widget_set_sensitive (daemon_e.t, TRUE);

  while (1)
    {

      if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
	{
	  char s[SIZE_BUFFER];

	  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobutton))
	      == TRUE)
	    {

	      if (!strlen (gtk_entry_get_text (GTK_ENTRY (server))))
		{
		  gtk_dialog_msg (_("No server?"));
		  continue;
		}

	      snprintf (s, SIZE_BUFFER, "tcp://%s:%d",
			gtk_entry_get_text (GTK_ENTRY (server)),
			(int)
			gtk_spin_button_get_value (GTK_SPIN_BUTTON (port)));

	    }
	  else
	    {

	      if (!strlen (gtk_entry_get_text (GTK_ENTRY (socket)))
		  || !strcasecmp (gtk_entry_get_text (GTK_ENTRY (socket)),
				  "AUTO"))
		snprintf (s, SIZE_BUFFER, "unix");
	      else
		snprintf (s, SIZE_BUFFER, "unix://%s",
			  gtk_entry_get_text (GTK_ENTRY (socket)));
	    }


	  if (data->sock)
	    sock_free (data->sock);
	  data->sock = sock_parse (s);

	  ret = 0;
	  break;
	}
      else
	{
	  ret = 1;
	  break;
	}
    }

  gtk_widget_destroy (dialog);

  return ret;
}
void
daemon_input_unix (GtkWidget * w, gpointer dummy)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w)) == FALSE)
    return;

  gtk_widget_set_sensitive (daemon_e.t, FALSE);
  gtk_widget_set_sensitive (daemon_e.u, TRUE);
}

void
daemon_input_tcp (GtkWidget * w, gpointer dummy)
{
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w)) == FALSE)
    return;

  gtk_widget_set_sensitive (daemon_e.u, FALSE);
  gtk_widget_set_sensitive (daemon_e.t, TRUE);
}

#endif

#ifdef ENABLE_MIC
int
input_mic_get_data (format_data_mic * data)
{
  GtkWidget *dialog;
  GtkWidget *box;
  GtkWidget *table;
  GtkWidget *stock;
  GtkWidget *label;

  GtkWidget *rate;
  GtkWidget *channels;
  GtkWidget *bitrate;

  int ret = 1;

  dialog =
    gtk_dialog_new_with_buttons (_("SomaPlayer - microphone configuration"),
				 GTK_WINDOW (winmain),
				 GTK_DIALOG_MODAL |
				 GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_OK,
				 GTK_RESPONSE_OK, GTK_STOCK_CANCEL,
				 GTK_RESPONSE_CANCEL, NULL);

  box = gtk_hbox_new (FALSE, 8);
  gtk_container_set_border_width (GTK_CONTAINER (box), 8);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), box, FALSE, FALSE,
		      0);

  stock =
    gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION,
			      GTK_ICON_SIZE_DIALOG);
  gtk_box_pack_start (GTK_BOX (box), stock, FALSE, FALSE, 0);

  table = gtk_table_new (0, 0, FALSE);
  gtk_table_set_row_spacings (GTK_TABLE (table), 4);
  gtk_table_set_col_spacings (GTK_TABLE (table), 4);
  gtk_box_pack_start (GTK_BOX (box), table, TRUE, TRUE, 0);

  label = gtk_label_new_with_mnemonic (_("Rate:"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 0, 1);

  rate = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (rate), "44100");

  gtk_table_attach_defaults (GTK_TABLE (table), rate, 1, 2, 0, 1);

  label = gtk_label_new_with_mnemonic (_("Channels"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 1, 2);

  channels = gtk_combo_box_new_text ();
  gtk_table_attach_defaults (GTK_TABLE (table), channels, 1, 2, 1, 2);
  gtk_combo_box_append_text (GTK_COMBO_BOX (channels), "STEREO");
  gtk_combo_box_append_text (GTK_COMBO_BOX (channels), "MONO");
  gtk_combo_box_set_active (GTK_COMBO_BOX (channels), 0);

  label = gtk_label_new_with_mnemonic (_("Bitrate"));
  gtk_table_attach_defaults (GTK_TABLE (table), label, 0, 1, 2, 3);

  bitrate = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (bitrate), "16");

  gtk_table_attach_defaults (GTK_TABLE (table), bitrate, 1, 2, 2, 3);

  gtk_widget_show_all (box);

  while (1)
    {

      if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK)
	{

	  if (!strlen (gtk_entry_get_text (GTK_ENTRY (rate))))
	    {
	      gtk_dialog_msg (_("No rate?"));
	      continue;
	    }

	  if (!(data->rate = atoi (gtk_entry_get_text (GTK_ENTRY (rate)))))
	    data->rate = 44100;

	  data->channels =
	    gtk_combo_box_get_active (GTK_COMBO_BOX (channels)) + 1;

	  if (!
	      (data->bitrate =
	       atoi ((char *) gtk_entry_get_text (GTK_ENTRY (bitrate)))))
	    data->bitrate = 16;

	  ret = 0;
	  break;
	}
      else
	{
	  ret = 1;
	  break;
	}
    }

  gtk_widget_destroy (dialog);

  return ret;
}
#endif

void
input_update (int input)
{

  switch (input)
    {
    case INPUT_PLS:
      gtk_widget_set_sensitive (element_input->playlist, TRUE);
      gtk_widget_set_sensitive (element_input->buttons, TRUE);
      input_no_rec = 1;
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				      (element_input->t_playlist), TRUE);
      input_no_rec = 0;
      break;

#ifdef ENABLE_MIC
    case INPUT_MIC:
      gtk_widget_set_sensitive (element_input->playlist, FALSE);
      gtk_widget_set_sensitive (element_input->buttons, FALSE);
      input_no_rec = 1;
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				      (element_input->t_microphone), TRUE);
      input_no_rec = 0;
      break;
#endif

#ifdef ENABLE_DAEMON
    case INPUT_SDS:
      gtk_widget_set_sensitive (element_input->playlist, FALSE);
      gtk_widget_set_sensitive (element_input->buttons, FALSE);
      input_no_rec = 1;
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				      (element_input->t_daemon_input), TRUE);
      input_no_rec = 0;
      break;
#endif
    }
}

/* EOF */
