/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "options.h"
#include "audio.h"
#include "volume.h"
#include "file.h"
#include "sds/sds.h"
#include "other.h"
#include "buffer.h"
#include "daemon.h"
#include "output.h"
#include "list.h"
#include "format.h"
#include "admin.h"

#ifdef ENABLE_MIC
#include "input/mic/mic.h"
#endif

int option_check_graphic (char *);
int option_check_daemon (char *);

/* it checks the parameters */
int
options (int argc, char **argv)
{
  register int i;
  int done = 0;
  audio *output = NULL;

  for (i = 1; i < argc && !done; i++)
    {
      if (!strcmp (argv[i], "-no") || !strcmp (argv[i], "--nooutput"))
	{
	  play->nooutput = 1;
	}

      else if (!strcmp (argv[i], "-ao") || !strcmp (argv[i], "--audiooutput"))
	{
	  i++;
	  if (!argv[i])
	    fatal (_("Error: option '%s' must have a parameter!"),
		   argv[i - 1]);

	  output = output_add (audio_type_select (argv[i]));
	}

      else if (!strcmp (argv[i], "-ad") || !strcmp (argv[i], "--audiodevice"))
	{
	  i++;
	  if (!argv[i])
	    fatal (_("Error: option '%s' must have a parameter!"),
		   argv[i - 1]);

	  if (!output)
	    fatal (_("No audiooutput setting."));

	  if (!(output->audio_dev = strdup (argv[i])))
	    fatal (_("Error: memory."));
	}

#ifdef ENABLE_CDAUDIO
      else if (!strcmp (argv[i], "-cd") || !strcmp (argv[i], "--cdromdevice"))
	{
	  i++;
	  if (!argv[i])
	    fatal (_("Error: option '%s' must have a parameter!"),
		   argv[i - 1]);
	  if (!(play->cd = strdup (argv[i])))
	    fatal (_("Error: memory."));
	}
#endif

#ifdef ENABLE_MIC
      else if (!strcmp (argv[i], "--devdsp"))
	{
	  i++;
	  if (!argv[i])
	    fatal (_("Error: option '%s' must have a parameter!"),
		   argv[i - 1]);
	  if (!(play->devdsp = strdup (argv[i])))
	    fatal (_("Error: memory."));
	}
#endif

      else if (!strcmp (argv[i], "-z") || !strcmp (argv[i], "--random"))
	play->random = 1;

      else if (!strcmp (argv[i], "-r") || !strcmp (argv[i], "--repeat"))
	play->repeat = 1;

      else if (!strcmp (argv[i], "-nb") || !strcmp (argv[i], "--nobuffer"))
	play->nobuffer = 1;

      else if (!strcmp (argv[i], "-nv") || !strcmp (argv[i], "--noverbose"))
	play->noverbose = 1;

      else if (!strcmp (argv[i], "-nr") || !strcmp (argv[i], "--norealtime"))
	play->norealtime = 1;

#ifdef ENABLE_GTK
      else if (!strcmp (argv[i], "-g") || !strcmp (argv[i], "--graphic"))
	play->graphic = 1;
#endif

      else if (!strcmp (argv[i], "-b") || !strcmp (argv[i], "--buffer"))
	{
	  i++;
	  if (!argv[i])
	    fatal (_("Error: option '%s' must have a parameter!"),
		   argv[i - 1]);

	  play->realsize = buffer_size (argv[i]);
	  if (play->realsize < 1024)
	    fatal (_("Error: buffer is too small: min 1024 bytes."));
	}

      else if (!strcmp (argv[i], "-v") || !strcmp (argv[i], "--volume"))
	{
	  int v;

	  i++;
	  if (!argv[i])
	    fatal (_("Error: option '%s' must have a parameter!"),
		   argv[i - 1]);

	  v = atoi (argv[i]);

	  if (v < VOLUME_MIN)
	    v = VOLUME_MIN;
	  if (v > VOLUME_MAX)
	    v = VOLUME_MAX;

	  play->volume = v;
	}

      else if (!strcmp (argv[i], "-d") || !strcmp (argv[i], "--daemon"))
	{
	  if (!(play->daemon = (daemon_data *) malloc (sizeof (daemon_data))))
	    fatal (_("Error: memory."));

	  if (argv[i + 1] && !daemon_option (argv[i + 1]))
	    i++;
	  else
	    {
	      play->daemon->interface = NULL;
	      play->daemon->port = SDS_PORT;
	      play->daemon->listen = SDS_LISTEN;
	      play->daemon->socket = SOCKET_TCP;
#ifdef ENABLE_IPV6
	      play->daemon->ipv6 = 0;
#endif

#ifdef ENABLE_GTK
	      play->daemon->autofader = 0;
#endif
	    }
	}

#ifdef ENABLE_DAEMON
      else if (!strcmp (argv[i], "-s") || !strcmp (argv[i], "--sds"))
	{
	  i++;
	  if (!argv[i])
	    fatal (_("Error: option '%s' must have a parameter!"),
		   argv[i - 1]);

	  play->daemon_input = 1;

	  if (!(play->daemon_input_opt = strdup (argv[i])))
	    fatal (_("Error: memory."));

	  format_add (TYPE_DAEMON_INPUT);
	}
#endif

#ifdef ENABLE_MIC
      else if (!strcmp (argv[i], "-m") || !strcmp (argv[i], "--mic"))
	{
	  if (!argv[i + 1])
	    {
	      play->microphone = 1;
	      /* This the MIC format */
	      format_add (TYPE_MIC);

	    }
	  else
	    {
	      play->microphone = 1;

	      if (mic_check_option (argv[i + 1]))
		{
		  i++;
		  if (!(play->mic_option = strdup (argv[i])))
		    fatal (_("Error: memory."));
		}

	      format_add (TYPE_MIC);
	    }
	}
#endif

      else if (!strcmp (argv[i], "-a") || !strcmp (argv[i], "--admin"))
	{
	  i++;
	  if (!argv[i])
	    fatal (_("Error: option '%s' must have a parameter!"),
		   argv[i - 1]);

	  if (!(play->admin = admin_parameter (argv[i])))
	    fatal ("Error: parameter of '%s'", argv[i - 1]);
#ifdef ENABLE_GTK
	  play->admin_active = 1;
#endif

	}

      else if (!strcmp (argv[i], "-h") || !strcmp (argv[i], "--help"))
	return usage ();

      else
	done++;
    }

  /* The name of program is: sds or gsds? */
  if (option_check_daemon (argv[0]) && !play->daemon)
    {
#ifdef ENABLE_GTK
      if (!strcmp (argv[0], "gsds"))
	play->graphic = 1;
#endif

      if (!(play->daemon = (daemon_data *) malloc (sizeof (daemon_data))))
	fatal (_("Error: memory."));

      play->daemon->interface = NULL;
      play->daemon->port = SDS_PORT;
      play->daemon->listen = SDS_LISTEN;
      play->daemon->socket = SOCKET_TCP;
#ifdef ENABLE_IPV6
      play->daemon->ipv6 = 0;
#endif
    }

#ifdef ENABLE_GTK
  /* The name of programm is gplayer o gsds? */
  else if (option_check_graphic (argv[0]))
    play->graphic = 1;
#endif

  if ((!done && !play->daemon
#ifdef ENABLE_DAEMON
       && !play->daemon_input
#endif
#ifdef ENABLE_MIC
       && !play->microphone
#endif
#ifdef ENABLE_GTK
       && !play->graphic
#endif
      ) || (done && play->daemon))
    return usage ();

  output = play->output;

  if (!output && !play->nooutput)
    {
      if (play->config_audio)
	output = output_add (audio_type_select (play->config_audio));

      else
	output = output_add (0);
    }

  while (output)
    {

      if ((0
#ifdef ENABLE_SNDFILE
	   || output->audio_type == USE_WAV
	   || output->audio_type == USE_AIFF
	   || output->audio_type == USE_AU
	   || output->audio_type == USE_RAW
	   || output->audio_type == USE_PAF
	   || output->audio_type == USE_SVX
	   || output->audio_type == USE_NIST
	   || output->audio_type == USE_VOC
	   || output->audio_type == USE_IRCAM
	   || output->audio_type == USE_W64
	   || output->audio_type == USE_MAT4
	   || output->audio_type == USE_MAT5
	   || output->audio_type == USE_PVF
	   || output->audio_type == USE_XI || output->audio_type == USE_HTK
#ifdef USE_MIDI
	   || output->audio_type == USE_MIDI
#endif
#ifdef USE_AVR
	   || output->audio_type == USE_AVR
#endif
#ifdef USE_WAVEX
	   || output->audio_type == USE_WAVEX
#endif
#endif
#ifdef ENABLE_LAME
	   || output->audio_type == USE_LAME
#endif
#ifdef ENABLE_OGG
	   || output->audio_type == USE_OGG
#endif
#ifdef ENABLE_ICECAST
	   || output->audio_type == USE_ICECAST
#endif
#ifdef ENABLE_ICECAST2
	   || output->audio_type == USE_ICECAST2
#endif
#ifdef ENABLE_SHOUTCAST
	   || output->audio_type == USE_SHOUTCAST
#endif
	  ) && !output->audio_dev)
	fatal (_("Error: missing audiodevice."));

      output = output->next;
    }

  /* Init audio */
  if (!output && !play->nooutput)
    audio_init ();

  if (!play->realsize)
    play->realsize = SIZE_BUFFER * 5;

#ifdef ENABLE_CDAUDIO
  if (!play->cd)
    play->cd = CDROM_DEVICE;
#endif

  /* Insert the other parameters as file */
  if (!play->daemon && done)
    for (i = (i > 1 ? i - 1 : 1); i < argc; i++)
      list_add (argv[i]);

  if (!play->first
#ifdef ENABLE_DAEMON
      && !play->daemon_input
#endif
#ifdef ENABLE_MIC
      && !play->microphone
#endif
      && !play->daemon
#ifdef ENABLE_GTK
      && !play->graphic
#endif
    )
    return usage ();

  return 0;
}

/* Check the graphic name */
int
option_check_graphic (char *file)
{
  int k;

  if (!strcmp (file, "gsplayer"))
    return 1;
  if (!strcmp (file, "gsds"))
    return 1;

  for (k = strlen (file) - 1; k > 0; k--)
    {
      if (file[k] == '/')
	{
	  if (!strcmp (file + k + 1, "gsplayer"))
	    return 1;
	  if (!strcmp (file + k + 1, "gsds"))
	    return 1;
	}
    }

  return 0;
}

/* Daemon ? */
int
option_check_daemon (char *file)
{

  if (strlen (file) < 3)
    return 0;

  if (!strcmp (file + strlen (file) - 3, "sds"))
    return 1;

  return 0;
}

/* EOF */
