/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef OUTPUT_H
#define OUTPUT_H

#define OUTPUT_DONE	0
#define OUTPUT_ERROR	1
#define OUTPUT_OPEN	2
#define OUTPUT_WRITE	3
#define OUTPUT_CLOSE	4
#define OUTPUT_EXIT	5

/* output.c */
char *output_check_file (char *);
void *output_thread (void *);
void output_open (long, int, int);
int output_check (void);
int output_write (void *, size_t);
void output_close (void);
void output_check_close (void);
void output_forced_close (void);
void output_info (void);
void output_exit (void);
audio *output_add (int);
void output_remove (audio *);
void output_remove_nb (audio *);
void output_bad_list (audio *);
void output_bad_list_forced (audio *);

void output_lock(void);
void output_unlock(void);

#endif

/* EOF */
