/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#ifdef ENABLE_DAEMON

#include "../../player.h"
#include "../../audio.h"
#include "../../other.h"
#include "../../util.h"
#include "../../sock.h"

/* Close the socket */
void
daemon_output_close (audio * output)
{
  int *fd = (int *) output->data;

  if (fd)
    {
      close (*fd);
      output->data = NULL;
    }
}

void
daemon_output_show (audio * output)
{
  msg (_("Audio Device:\n\tType: Soma Distribuited Sound\n"));
}

/* Open the socket */
int
daemon_output_init (audio * output, long rate, int channels, int bitrate)
{
  static int fd;
  sock_struct *sock;
  int i;
  char str[SIZE_BUFFER];

  /* Check the argument: default tcp on localhost */
  if (!output->audio_dev && !(output->audio_dev = strdup ("tcp")))
    fatal ("Error: memory.");

  if(!(sock=sock_parse(output->audio_dev))) return 1;

  msg(_("Connect to play:\n\tType %s\n\tServer %s\n\tPort %d\n\tProtocol Somaplayer Distributed Sound"),sock->type == SOCKET_TCP ? "tcp" : "unix",sock->server, sock->port);

  if(!(fd=sock_connect(sock))) {
    sock_free(sock);
    return 1;
  }

  i = snprintf (str, SIZE_BUFFER, "%d %d %d 100 0 0 0 %d\n", (int) rate, channels, bitrate, big_endian ());
  if (write (fd, str, i) != i)
    {
      msg_error (_("Server error."));
      return 1;
    }

  output->data = (void *) &fd;
  
  sock_free(sock);

  return 0;
}

int
daemon_output_write (audio * output, int channels, int bitrate, void *data,
		     size_t length)
{
  int *fd = (int *) output->data;

  if (fd)
    return write (*fd, data, length);

  return 0;
}

#endif
