/* Somaplayer - Copyright (C) 2003-4 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "file.h"
#include "buffer.h"
#include "list.h"
#include "format.h"
#include "other.h"
#include "output.h"

#ifdef ENABLE_GTK
#include "gtk/statusbar.h"
#include "gtk/graphic.h"
#endif

/* Now we playing something? */
int
playing (void)
{
  int ret;

  pthread_mutex_lock (&play->m_list);

  if (play->this && play->this->filename)
    ret = 1;
  else
    ret = 0;
  pthread_mutex_unlock (&play->m_list);

  return ret;
}

/* The name of this file */
char *
playing_file (void)
{
  static char ret[SIZE_BUFFER];

  pthread_mutex_lock (&play->m_list);

  if (!play->this)
    {
      pthread_mutex_unlock (&play->m_list);
      return NULL;
    }

  strncpy (ret, play->this->filename, SIZE_BUFFER);

  pthread_mutex_unlock (&play->m_list);

  return ret;
}

/* The name of this file (with ID3 tags) */
char *
playing_name (void)
{
  static char ret[SIZE_BUFFER];

  pthread_mutex_lock (&play->m_list);

  if (!play->this)
    {
      pthread_mutex_unlock (&play->m_list);
      return NULL;
    }

  strncpy (ret, play->this->name, SIZE_BUFFER);

  pthread_mutex_unlock (&play->m_list);

  return ret;
}

/* There is the list of file ? */
int
playing_list (void)
{
  int ret;

  pthread_mutex_lock (&play->m_list);

  if (play->first)
    ret = 1;
  else
    ret = 0;

  pthread_mutex_unlock (&play->m_list);

  return ret;
}

/* This is the player thread */
void *
player (void *data)
{

  int type = -1;
  int buf_start = 0;

  srand (getpid ());

#ifdef ENABLE_GTK

  while (1)
    {
#endif

      /* Get the next file. List_Next lock play->m_list and return a value
       * without unlock.
       */
      while ((play->this = list_next ()))
	{
	  char filename[SIZE_BUFFER];

	  /* ... so now i unlock */
	  pthread_mutex_unlock (&play->m_list);

	  strcpy (filename, playing_file ());

	  play->done = INIT;
	  events.skip = 0;
	  events.next = 0;
	  events.pause = 0;
	  play->remote = remote_file (filename);

	  msg (_("Read file: %s"), filename);

	  type = type_file (filename);

#ifdef ENABLE_GTK
	  if (play->graphic && play->go_graphic
#ifdef ENABLE_MIC
	      && type != TYPE_MIC
#endif
#ifdef ENABLE_DAEMON
	      && type != TYPE_DAEMON_INPUT
#endif
	    )
	    playlist_select ();
#endif

	  /* Open it */
	  if (1
#ifdef ENABLE_DAEMON
	      && type != TYPE_DAEMON_INPUT
#endif
#ifdef ENABLE_MIC
	      && type != TYPE_MIC
#endif
#ifdef ENABLE_CDAUDIO
	      && type != TYPE_CDAUDIO
#endif
#ifdef ENABLE_SNDFILE
	      && type != TYPE_SNDFILE
#endif
	    )
	    {
	      if (my_open (play->this->filename, play->remote))
		{
		  continue;
		}

	      if (pthread_mutex_init (&play->mutex, NULL))
		fatal (_("Mutex error."));

	      if (pthread_cond_init (&play->p_pop, NULL))
		fatal (_("Cond error."));

	      /* Open the buffer thread */
	      if (!play->nobuffer)
		{
		  if (pthread_cond_init (&play->p_push, NULL))
		    fatal (_("Cond error."));

		  buffer_init ();

		  if (play->done == ENDOFFILE)
		    continue;

#ifdef ENABLE_GTK
		  if (play->graphic)
		    msg_statusbar ("");
#endif
		  if (pthread_create (&th2, NULL, buffer_push, NULL))
		    fatal (_("Thread error."));

		  buf_start = 1;

		}
	    }
	  else
	    play->done = ENDOFFILE;

	  /* Search the correct format for this file */
	  play->format_current = format_search (type);

	  if (!play->format_current)
	    {
	      msg (_("Skipping: no support for this type of file yet."));
	      events.skip = 1;
	    }
	  else
	    /* Play: */
	    play->format_current->run ();

	  play->play = 0;
	  events.skip = 1;

	  /* Close the buffer thread */
	  if (buf_start
#ifdef ENABLE_DAEMON
	      && type != TYPE_DAEMON_INPUT
#endif
#ifdef ENABLE_MIC
	      && type != TYPE_MIC
#endif
#ifdef ENABLE_CDAUDIO
	      && type != TYPE_CDAUDIO
#endif
#ifdef ENABLE_SNDFILE
	      && type != TYPE_SNDFILE
#endif
	    )
	    {
	      pthread_mutex_unlock (&play->mutex);

	      if (!play->nobuffer)
		{
		  pthread_cond_signal (&play->p_push);
		  pthread_join (th2, NULL);
		}

	      my_close ();

	      pthread_mutex_destroy (&play->mutex);

	    }

	  if (events.quit)
	    break;

	  /* Check the graphic buttons STOP, PLAY, REPEAT... */
#ifdef ENABLE_GTK
	  if (events.restart)
	    {

	      events.restart = 0;
	      while (!events.restart)
		sched_yield ();
	      events.restart = 0;

	    }

	  if (events.stop)
	    {
	      pthread_mutex_lock (&play->mutex);
	      pthread_cond_wait (&play->p_pop, &play->mutex);
	      pthread_mutex_unlock (&play->mutex);
	    }

#endif
	}

      play->play = 0;
      output_check_close ();

      pthread_mutex_unlock (&play->m_list);

#ifdef ENABLE_GTK

      if (events.quit || !play->graphic)
	break;

      play->this = NULL;

      pthread_mutex_lock (&play->mutex);
      pthread_cond_wait (&play->p_pop, &play->mutex);
      pthread_mutex_unlock (&play->mutex);

      if (events.quit || !play->graphic)
	break;

    }

#endif

  events.quit = 1;

  if (!play->nobuffer
#ifdef ENABLE_DAEMON
      && type != TYPE_DAEMON_INPUT
#endif
#ifdef ENABLE_MIC
      && type != TYPE_MIC
#endif
#ifdef ENABLE_CDAUDIO
      && type != TYPE_CDAUDIO
#endif
#ifdef ENABLE_SNDFILE
      && type != TYPE_SNDFILE
#endif
      && type != -1 && buf_start)
    {
      pthread_join (th2, NULL);

      pthread_cond_destroy (&play->p_push);
    }

  pthread_exit (NULL);
}

/* EOF */
