/* 
   EOFaultHandler.h
   
   Copyright (C) SKYRIX Software AG and Helge Hess

   Author: Helge Hess (helge.hess@opengroupware.org)
   Date:   1999-2004

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOFaultHandler_h__
#define __EOFaultHandler_h__

#import <Foundation/NSObject.h>

@class NSInvocation, NSMethodSignature;
@class EOFault;

@interface EOFaultHandler : NSObject
{
@public
  int     faultReferences;
  void    *extraData;   /* saved ivars overridden by 'faultHandler' ivar */
  Class   targetClass;
  NSZone  *zone;
}

- (Class)targetClass;
- (void *)extraData;
- (void)setTargetClass:(Class)_class extraData:(void *)_extraData;

/* firing */

- (BOOL)shouldPerformInvocation:(NSInvocation *)_invocation;
- (void)faultWillFire:(EOFault *)_fault;
- (void)completeInitializationOfObject:(id)_object;

/* fault reflection */

- (Class)classForFault:(EOFault *)_fault;
- (BOOL)respondsToSelector:(SEL)_selector forFault:(EOFault *)_fault;
- (BOOL)conformsToProtocol:(Protocol *)_protocol forFault:(EOFault *)_fault;
- (BOOL)isKindOfClass:(Class)_class forFault:(EOFault *)_fault;
- (BOOL)isMemberOfClass:(Class)_class forFault:(EOFault *)_fault;

- (NSMethodSignature *)methodSignatureForSelector:(SEL)_selector
  forFault:(EOFault *)_fault;

/* description */

- (NSString *)descriptionForObject:(id)_fault;

@end /* EOFaultHandler */

#endif /* __EOFaultHandler_h__ */
