/*
  Copyright (C) 2004-2005 SKYRIX Software AG

  This file is part of SOPE.

  SOPE is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  SOPE is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
  License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with SOPE; see the file COPYING.  If not, write to the
  Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/

#ifndef	__NGiCal_iCalRecurrenceRule_H_
#define	__NGiCal_iCalRecurrenceRule_H_

#import <Foundation/NSObject.h>

/*
 iCalRecurrenceRule
 
 Encapsulates a (probably complex) recurrence rule by offering
 a high level API.
 
 NOTE: as of now, only a very limited subset of RFC2445 is implemented.
 Please see the unit tests for what is covered.
*/

typedef enum {
  iCalRecurrenceFrequenceSecondly = 1,
  iCalRecurrenceFrequenceMinutely = 2,
  iCalRecurrenceFrequenceHourly   = 3,
  iCalRecurrenceFrequenceDaily    = 4,
  iCalRecurrenceFrequenceWeekly   = 5,
  iCalRecurrenceFrequenceMonthly  = 6,
  iCalRecurrenceFrequenceYearly   = 7,
} iCalRecurrenceFrequency;

typedef enum {
  iCalWeekDayMonday    = 1,
  iCalWeekDayTuesday   = 2,
  iCalWeekDayWednesday = 4,
  iCalWeekDayThursday  = 8,
  iCalWeekDayFriday    = 16,
  iCalWeekDaySaturday  = 32,
  iCalWeekDaySunday    = 64,
} iCalWeekDay;

@class NSString, NSCalendarDate, NGCalendarDateRange;

@interface iCalRecurrenceRule : NSObject
{
  iCalRecurrenceFrequency frequency;
  int            interval;
  unsigned       repeatCount;
  NSCalendarDate *untilDate;
  struct {
    unsigned weekStart: 7;
    unsigned mask:      7;
  } byDay;

  NSString       *rrule;
}

+ (id)recurrenceRuleWithICalRepresentation:(NSString *)_iCalRep;

- (void)setFrequency:(iCalRecurrenceFrequency)_frequency;
- (iCalRecurrenceFrequency)frequency;
- (void)setRepeatInterval:(int)_repeatInterval;
- (int)repeatInterval;
- (void)setWeekStart:(iCalWeekDay)_weekStart;
- (iCalWeekDay)weekStart;
- (void)setByDayMask:(unsigned)_mask;
- (unsigned)byDayMask;
  
/* count and untilDate are mutually exclusive */
- (void)setRepeatCount:(unsigned)_repeatCount;
- (unsigned)repeatCount;
- (void)setUntilDate:(NSCalendarDate *)_untilDate;
- (NSCalendarDate *)untilDate;

- (BOOL)isInfinite;

/* parse complete iCal RRULE */
- (void)setRrule:(NSString *)_rrule;

- (NSString *)iCalRepresentation;

@end

#endif	/* __NGiCal_iCalRecurrenceRule_H_ */
