<?php
// $Horde: accounts/templates/main.inc,v 1.1.1.1.2.8 2003/09/19 09:36:19 jan Exp $ 
include_once ACCOUNTS_BASE . '/templates/menu/menu.inc'; ?>

<table border="0" align="center" width="100%" cellspacing="0" cellpadding="3">
<tr>
<td colspan="2" class="header" align="left">
<b><?php echo _("Select one of the following functions from the menu bar above.") ?></b>
</td>
</tr>

<?php if (in_array('passwd', $conf['menu']['apps']) && $registry->getParam('status', 'passwd') != 'inactive'): ?>
<tr>
<td class="control" valign="top"><b><?php echo Horde::link($registry->getWebRoot('passwd'), _("Password")) . _("Password") ?></a></b></td>
<td class="control">
<?php echo _("Allow you to change your account's password.") ?> 
<?php echo _("Changes should take effect immediately.  This is a secure way to remotely change your password.") ?> 
<?php echo _("Note that the new password must meet minimum requirements or it will not be changed.") ?>
</td>
</tr>
<?php endif; ?>

<?php if (in_array('vacation', $conf['menu']['apps']) && $registry->getParam('status', 'vacation') != 'inactive'): ?>
<tr>
<td class="control" valign="top"><b><?php echo Horde::link($registry->getWebRoot('vacation'), _("Vacation")) . _("Vacation") ?></a></b></td>
<td class="control">
<?php echo _("Allow you to setup or remove a vacation notice for your account.") ?> 
<?php echo _("A vacation notice will automatically reply to any incoming e-mail you receive while you are away or unable to attend to your e-mail -- for example while on vacation or out of town on business. It could be used as a courtesy to let others know why you are not answering their e-mail to you.") ?>
</td>
</tr>
<?php endif; ?>

<?php if (in_array('forwards', $conf['menu']['apps']) && $registry->getParam('status', 'forwards') != 'inactive'): ?>
<tr>
<td class="control" valign="top"><b><?php echo Horde::link($registry->getWebRoot('forwards'), _("Forwards")) . _("Forwards") ?></a></b></td>
<td class="control">
<?php echo _("Allow you to set or remove a forward on your e-mail.") ?> 
<?php echo _("An e-mail forward lets you redirect your mail to another e-mail address (or a comma separated list of addresses if you wish). You can even forward to another address and keep a copy in your local mailbox.") ?>
</td>
</tr>
<?php endif; ?>
</table>

<?php
// Get username/realm to gather information for.
$auth = split('@', Auth::getAuth());
$username = strtolower($auth[0]);
$realm = @$auth[1];
?>

<br />
<table class="control" border="0" align="center" width="100%" cellspacing="0" cellpadding="3">
<tr>
  <td class="header" colspan="2"><?php echo _("My Account Information") ?></td>
</tr>
<tr>
  <td width="25%"><?php echo _("Login"); ?></td>
  <td width="75%"><?php echo $username; ?></td>
</tr>

<?php if ($fullname = $mydriver->getFullname($username, $realm)): ?>
<tr>
  <td><?php echo _("Full Name"); ?></td>
  <td><?php echo $fullname; ?></td>
</tr>
<?php endif; ?>

<?php if ($home = $mydriver->getHome($username, $realm)): ?>
<tr>
  <td><?php echo _("Home Directory"); ?></td>
  <td><?php echo $home; ?></td>
</tr>
<?php endif; ?>

<?php if ($shell = $mydriver->getShell($username, $realm)): ?>
<tr>
  <td><?php echo _("Default Shell"); ?></td>
  <td><?php echo $shell; ?></td>
</tr>
<?php endif; ?>

<?php if ($quota = $mydriver->getQuota($username, $realm)): ?>
<tr>
  <td><?php echo _("Quota"); ?></td>
  <td><?php echo sprintf(_("%.2fMB used of %.2fMB allowed (%.2f%%)"),
            $quota['used'] / ( 1024 * 1024.0),
            $quota['limit'] / ( 1024 * 1024.0),
            ($quota['used'] * 100.0) / $quota['limit'] ); ?></td>
</tr>
<?php endif; ?>
</table>

<?php
echo "<br />";
if ($registry->getParam('status', 'forwards') != 'inactive') {
    $summary = $registry->callByPackage('forwards', 'horde/summary');
    if (!PEAR::isError($summary)) {
       echo $summary;
    }
}
echo "<br />";
if ($registry->getParam('status', 'vacation') != 'inactive') {
    $summary = $registry->callByPackage('vacation', 'horde/summary');
    if (!PEAR::isError($summary)) {
       echo $summary;
    }
}
?>
