
#include "config.h"
#include "config_defaults.h"
#include "backend_plugins.h"

#include <kapplication.h>
#include <kconfig.h>
#include <kstandarddirs.h>

#include <qdir.h>

#include <klocale.h>

FileFormat::FileFormat()
{
}

FileFormat::FileFormat(QString ext)
{
    extension=ext;
    encoder=QString::null;
    decoder=QString::null;
    replaygain=QString::null;
    encTime=0;
    decTime=0;
    repTime=0;
    compressionLevel=0;
}

FileFormat::~FileFormat()
{
}

void Config::createFormat(QString format, QString encoder, QString decoder)
{
    FileFormatList::Iterator it;

    for( it=fileFormatList.begin(); it!=fileFormatList.end(); ++it )
    {
        if( (*it).extension == format ) {
            if( encoder ) (*it).encoders.append(encoder);
            if( decoder ) (*it).decoders.append(decoder);
            return;
        }
    }

    it=fileFormatList.append(FileFormat(format));
    if( encoder ) (*it).encoders.append(encoder);
    if( decoder ) (*it).decoders.append(decoder);

    //implemented in backend_plugins.cpp
    /*for( ExtensionList::Iterator jt=backendPlugins.extensionList.begin(); jt!=backendPlugins.extensionList.end(); ++jt )
    {
        if( (*jt).extension == format ) {
            (*it).fileSize=(*jt).fileSize;
            //#ifdef DEBUG
            //system( QString("echo \"(*it).fileSize (").append(format).append("): %1").arg((*it).fileSize).append("\" >> ~/debug.txt") );
            //#endif
            break;
        }
        //system( "echo hopp >> ~/debug.txt" );
    }*/
}

void Config::read()
{
    KConfig *conf=kapp->config();
    QStringList listDefaults;
    int configVersion;

    rebuildFormatList();

    for( FileFormatList::Iterator it=fileFormatList.begin(); it!=fileFormatList.end(); ++it )
    {
        conf->setGroup((*it).extension);
        (*it).encoder=conf->readEntry("encoder",(*it).encoders.first());
        (*it).decoder=conf->readEntry("decoder",(*it).decoders.first());
        (*it).replaygain=conf->readEntry("replaygain",(*it).replaygains.first());
        (*it).encTime=conf->readDoubleNumEntry("encTime",0.1);
        (*it).decTime=conf->readDoubleNumEntry("decTime",0.02);
        (*it).repTime=conf->readDoubleNumEntry("repTime",0.02);
        BackendPlugins::PluginStructure plugin=backendPlugins.plugin((*it).encoder);
        (*it).compressionLevel=conf->readDoubleNumEntry("compressionLevel",((plugin.enc.strength.range_min+plugin.enc.strength.range_max)/2)/plugin.enc.strength.step);
    }

    conf->setGroup("Interface");
    convert.pauseMS=conf->readNumEntry("pauseMS",DEFAULT_PAUSEMS);
    startTab=conf->readNumEntry("startTab",DEFAULT_STARTTAB);
    fileListFont=conf->readFontEntry("fileListFont",0);
    showToolBar=conf->readBoolEntry("showToolBar",DEFAULT_TOOLBAR);

    conf->setGroup("EnDecoder Options");
    convert.mp3CrcCheck=conf->readBoolEntry("mp3CrcCheck",DEFAULT_MP3_CRC_CHECK);
    convert.mp3ISO=conf->readBoolEntry("mp3ISO",DEFAULT_MP3_ISO);

    conf->setGroup("Backends");
    listDefaults.clear();
    QString datadir=locateLocal("data","soundkonverter/bin/");
    datadir.remove(datadir.length()-1,1);
    listDefaults.append(datadir);
    listDefaults.append(QDir::homeDirPath()+"/bin");
    listDefaults.append("/usr/local/bin");
    listDefaults.append("/usr/bin");
    backend.directories=conf->readListEntry("directories",listDefaults);
    listDefaults.clear();
    backend.programs=conf->readListEntry("programs",listDefaults);

    conf->setGroup("LastOptions");
    lastOptions.profile=conf->readEntry("profile",i18n("Medium"));
    lastOptions.format=conf->readEntry("format","mp3");
    lastOptions.qualityMode=conf->readEntry("qualityMode",i18n("Quality"));
    lastOptions.quality=conf->readNumEntry("quality",40);
    lastOptions.bitrateMode=conf->readEntry("bitrateMode","vbr");
    lastOptions.bitrateRange=conf->readBoolEntry("bitrateRange",false);
    lastOptions.minBitrate=conf->readNumEntry("minBitrate",96);
    lastOptions.maxBitrate=conf->readNumEntry("maxBitrate",192);
    lastOptions.resample=conf->readBoolEntry("resample",false);
    lastOptions.samplingrate=conf->readEntry("samplingrate","44100");
    lastOptions.channels=conf->readBoolEntry("channels",false);
    lastOptions.numChannels=conf->readEntry("numChannels",i18n("Stereo"));
    lastOptions.replaygain=conf->readBoolEntry("replaygain",true);
    lastOptions.sharedDirPath=conf->readEntry("sharedDirPath",QDir::homeDirPath());
    lastOptions.metadataPath=conf->readEntry("metadataPath",QDir::homeDirPath()+"/%g/%a/%b/%a - %n - %t");
    lastOptions.copyStructurePath=conf->readEntry("copyStructurePath",QDir::homeDirPath());

    conf->setGroup("Misc");
    KStandardDirs *stdDirs=new KStandardDirs();
    calibrationFile=conf->readEntry("calibrationFile",stdDirs->findResource("data","soundkonverter/test.ogg"));
    configVersion=conf->readNumEntry("configVersion",0);
    if(configVersion!=190) firstRun=true;
    askForNewOptions=conf->readBoolEntry("askForNewOptions",DEFAULT_ASK_FOR_NEW_OPTIONS);
    check.online_plugins=conf->readBoolEntry("checkOnlinePluginsOnStartup",DEFAULT_CHECK_ONLINE_PLUGINS);
    check.online_backends=conf->readBoolEntry("checkOnlineBackendsOnStartup",DEFAULT_CHECK_ONLINE_BACKENDS);
    check.backends=conf->readBoolEntry("checkBackendsOnStartup",DEFAULT_CHECK_BACKENDS);
}

void Config::write()
{
    KConfig *conf = kapp->config();
    int configVersion=0;

    for( FileFormatList::Iterator it=fileFormatList.begin(); it!=fileFormatList.end(); ++it )
    {
        conf->setGroup((*it).extension);
        conf->writeEntry("encoder",(*it).encoder);
        conf->writeEntry("decoder",(*it).decoder);
        conf->writeEntry("replaygain",(*it).replaygain);
        conf->writeEntry("encTime",(*it).encTime);
        conf->writeEntry("decTime",(*it).decTime);
        conf->writeEntry("repTime",(*it).repTime);
        conf->writeEntry("compressionLevel",(*it).compressionLevel);
    }

    conf->setGroup("Interface");
    conf->writeEntry("pauseMS",convert.pauseMS);
    conf->writeEntry("startTab",startTab);
    conf->writeEntry("fileListFont",fileListFont);
    conf->writeEntry("showToolBar",showToolBar);

    conf->setGroup("EnDecoder Options");
    conf->writeEntry("mp3CrcCheck",convert.mp3CrcCheck);
    conf->writeEntry("mp3ISO",convert.mp3ISO);

    conf->setGroup("Backends");
    conf->writeEntry("directories",backend.directories);
    conf->writeEntry("programs",backend.programs);

    conf->setGroup("LastOptions");
    conf->writeEntry("profile",lastOptions.profile);
    conf->writeEntry("format",lastOptions.format);
    conf->writeEntry("qualityMode",lastOptions.qualityMode);
    conf->writeEntry("quality",lastOptions.quality);
    conf->writeEntry("bitrateMode",lastOptions.bitrateMode);
    conf->writeEntry("bitrateRange",lastOptions.bitrateRange);
    conf->writeEntry("minBitrate",lastOptions.minBitrate);
    conf->writeEntry("maxBitrate",lastOptions.maxBitrate);
    conf->writeEntry("resample",lastOptions.resample);
    conf->writeEntry("samplingrate",lastOptions.samplingrate);
    conf->writeEntry("channels",lastOptions.channels);
    conf->writeEntry("numChannels",lastOptions.numChannels);
    conf->writeEntry("replaygain",lastOptions.replaygain);
    conf->writeEntry("sharedDirPath",lastOptions.sharedDirPath);
    conf->writeEntry("metadataPath",lastOptions.metadataPath);
    conf->writeEntry("copyStructurePath",lastOptions.copyStructurePath);

    conf->setGroup("Misc");
    conf->writeEntry("calibrationFile",calibrationFile);
    if(!firstRun) configVersion=190;
    conf->writeEntry("configVersion",configVersion);
    conf->writeEntry("askForNewOptions",askForNewOptions);
    conf->writeEntry("checkOnlinePluginsOnStartup",check.online_plugins);
    conf->writeEntry("checkOnlineBackendsOnStartup",check.online_backends);
    conf->writeEntry("checkBackendsOnStartup",check.backends);

    conf->sync();
}

void Config::rebuildFormatList()
{
    fileFormatList.clear();

    for( BackendPlugins::PluginStructureList::Iterator it=backendPlugins.plugins.begin(); it!=backendPlugins.plugins.end(); ++it )
    {
        QStringList::Iterator jt;

        for( jt=(*it).enc.formats.begin(); jt!=(*it).enc.formats.end(); ++jt )
        {
            if((*it).enc.enabled) {
                createFormat((*jt),(*it).enc.bin,QString::null);
            }
        }
        for( jt=(*it).dec.formats.begin(); jt!=(*it).dec.formats.end(); ++jt )
        {
            if((*it).dec.enabled) {
                createFormat((*jt),QString::null,(*it).dec.bin);
            }
        }
    }
}

FileFormat Config::fileFormat(QString ext)
{
    for( FileFormatList::Iterator it=fileFormatList.begin(); it!=fileFormatList.end(); ++it )
    {
        if( (*it).extension == ext ) return *it;
    }

    return FileFormat(ext);
}

void Config::readOldConfig()
{
    KConfig *conf = kapp->config();

    conf->setGroup("EnDecoder");

    QString ogg_decoder = conf->readEntry("ogg_decoder", "");
    QString ogg_encoder = conf->readEntry("ogg_encoder", "");
    float ogg_decTime = conf->readDoubleNumEntry("ogg_decTime", 0.0);
    float ogg_encTime = conf->readDoubleNumEntry("ogg_encTime", 0.0);

    QString mp3_decoder = conf->readEntry("mp3_decoder", "");
    QString mp3_encoder = conf->readEntry("mp3_encoder", "");
    float mp3_decTime = conf->readDoubleNumEntry("mp3_decTime", 0.0);
    float mp3_encTime = conf->readDoubleNumEntry("mp3_encTime", 0.0);

    QString mpc_decoder = conf->readEntry("mpc_decoder", "");
    QString mpc_encoder = conf->readEntry("mpc_encoder", "");
    float mpc_decTime = conf->readDoubleNumEntry("mpc_decTime", 0.0);
    float mpc_encTime = conf->readDoubleNumEntry("mpc_encTime", 0.0);

    QString flac_decoder = conf->readEntry("flac_decoder", "");
    QString flac_encoder = conf->readEntry("flac_encoder", "");
    float flac_decTime = conf->readDoubleNumEntry("flac_decTime", 0.0);
    float flac_encTime = conf->readDoubleNumEntry("flac_encTime", 0.0);

    QString ape_decoder = conf->readEntry("ape_decoder", "");
    QString ape_encoder = conf->readEntry("ape_encoder", "");
    float ape_decTime = conf->readDoubleNumEntry("ape_decTime", 0.0);
    float ape_encTime = conf->readDoubleNumEntry("ape_encTime", 0.0);

    QString wma_decoder = conf->readEntry("wma_decoder", "");
    QString wma_encoder = conf->readEntry("wma_encoder", "");
    float wma_decTime = conf->readDoubleNumEntry("wma_decTime", 0.0);
    float wma_encTime = conf->readDoubleNumEntry("wma_encTime", 0.0);

    conf->setGroup("EnDecoder Options");
    int flacCompressionLevel = conf->readNumEntry("flacCompressionLevel", 0);
    int apeCompressionLevel = conf->readNumEntry("apeCompressionLevel", 0);

    for( FileFormatList::Iterator it=fileFormatList.begin(); it!=fileFormatList.end(); ++it ) {
        if( (*it).extension == "ogg" && (*it).encoders.findIndex(ogg_encoder) && ogg_encoder != "" ) (*it).encoder=ogg_encoder;
        if( (*it).extension == "ogg" && (*it).decoders.findIndex(ogg_decoder) && ogg_decoder != "" ) (*it).decoder=ogg_decoder;
        if( (*it).extension == "ogg" && ogg_encTime != 0.0 ) (*it).encTime=ogg_encTime;
        if( (*it).extension == "ogg" && ogg_decTime != 0.0 ) (*it).decTime=ogg_decTime;

        if( (*it).extension == "mp3" && (*it).encoders.findIndex(mp3_encoder) && mp3_encoder != "" ) (*it).encoder=mp3_encoder;
        if( (*it).extension == "mp3" && (*it).decoders.findIndex(mp3_decoder) && mp3_decoder != "" ) (*it).decoder=mp3_decoder;
        if( (*it).extension == "mp3" && mp3_encTime != 0.0 ) (*it).encTime=mp3_encTime;
        if( (*it).extension == "mp3" && mp3_decTime != 0.0 ) (*it).decTime=mp3_decTime;

        if( (*it).extension == "mpc" && (*it).encoders.findIndex(mpc_encoder) && mpc_encoder != "" ) (*it).encoder=mpc_encoder;
        if( (*it).extension == "mpc" && (*it).decoders.findIndex(mpc_decoder) && mpc_decoder != "" ) (*it).decoder=mpc_decoder;
        if( (*it).extension == "mpc" && mpc_encTime != 0.0 ) (*it).encTime=mpc_encTime;
        if( (*it).extension == "mpc" && mpc_decTime != 0.0 ) (*it).decTime=mpc_decTime;

        if( (*it).extension == "flac" && (*it).encoders.findIndex(flac_encoder) && flac_encoder != "" ) (*it).encoder=flac_encoder;
        if( (*it).extension == "flac" && (*it).decoders.findIndex(flac_decoder) && flac_decoder != "" ) (*it).decoder=flac_decoder;
        if( (*it).extension == "flac" && flac_encTime != 0.0 ) (*it).encTime=flac_encTime;
        if( (*it).extension == "flac" && flac_decTime != 0.0 ) (*it).decTime=flac_decTime;
        if( (*it).extension == "flac" && flacCompressionLevel != 0 ) (*it).compressionLevel=flacCompressionLevel;

        if( (*it).extension == "ape" && (*it).encoders.findIndex(ape_encoder) && ape_encoder != "" ) (*it).encoder=ape_encoder;
        if( (*it).extension == "ape" && (*it).decoders.findIndex(ape_decoder) && ape_decoder != "" ) (*it).decoder=ape_decoder;
        if( (*it).extension == "ape" && ape_encTime != 0.0 ) (*it).encTime=ape_encTime;
        if( (*it).extension == "ape" && ape_decTime != 0.0 ) (*it).decTime=ape_decTime;
        if( (*it).extension == "ape" && apeCompressionLevel != 0 ) (*it).compressionLevel=apeCompressionLevel;

        if( (*it).extension == "wma" && (*it).encoders.findIndex(wma_encoder) && wma_encoder != "" ) (*it).encoder=wma_encoder;
        if( (*it).extension == "wma" && (*it).decoders.findIndex(wma_decoder) && wma_decoder != "" ) (*it).decoder=wma_decoder;
        if( (*it).extension == "wma" && wma_encTime != 0.0 ) (*it).encTime=wma_encTime;
        if( (*it).extension == "wma" && wma_decTime != 0.0 ) (*it).decTime=wma_decTime;
    }

    conf->setGroup("EnDecoder");

    conf->deleteEntry("ogg_decoder");
    conf->deleteEntry("ogg_encoder");
    conf->deleteEntry("ogg_decTime");
    conf->deleteEntry("ogg_encTime");
    conf->deleteEntry("ogg_trcTime");

    conf->deleteEntry("mp3_decoder");
    conf->deleteEntry("mp3_encoder");
    conf->deleteEntry("mp3_decTime");
    conf->deleteEntry("mp3_encTime");
    conf->deleteEntry("mp3_trcTime");

    conf->deleteEntry("mp2_decoder");
    conf->deleteEntry("mp2_encoder");
    conf->deleteEntry("mp2_decTime");
    conf->deleteEntry("mp2_encTime");
    conf->deleteEntry("mp2_trcTime");

    conf->deleteEntry("mpc_decoder");
    conf->deleteEntry("mpc_encoder");
    conf->deleteEntry("mpc_decTime");
    conf->deleteEntry("mpc_encTime");
    conf->deleteEntry("mpc_trcTime");

    conf->deleteEntry("flac_decoder");
    conf->deleteEntry("flac_encoder");
    conf->deleteEntry("flac_decTime");
    conf->deleteEntry("flac_encTime");
    conf->deleteEntry("flac_trcTime");

    conf->deleteEntry("ape_decoder");
    conf->deleteEntry("ape_encoder");
    conf->deleteEntry("ape_decTime");
    conf->deleteEntry("ape_encTime");
    conf->deleteEntry("ape_trcTime");

    conf->deleteEntry("wma_decoder");
    conf->deleteEntry("wma_encoder");
    conf->deleteEntry("wma_decTime");
    conf->deleteEntry("wma_encTime");
    conf->deleteEntry("wma_trcTime");

    conf->setGroup("EnDecoder Options");
    conf->deleteEntry("flacCompressionLevel");
    conf->deleteEntry("flacVerify");
    conf->deleteEntry("apeCompressionLevel");
    conf->deleteEntry("apeVerify");
}

