
#ifndef _CONFIG_DIALOGUE_EN_DECODER_H_
#define _CONFIG_DIALOGUE_EN_DECODER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>

class QGroupBox;
class QGridLayout;
class QLabel;
class QComboBox;
class QStringList;
class QLineEdit;
class QPushButton;
class QScrollView;
class QVBox;

class KPushButton;

class Calibrate;

class FormatOptions
{
public:
    QString format;
    QGroupBox *group;
    QGridLayout *grid;
    QLabel *lEncoder;
    QComboBox *cEncoder;
    QStringList *sEncoder;
    QLabel *lEncTimeLabel;
    QLabel *lEncTime;
    QLabel *lDecoder;
    QComboBox *cDecoder;
    QStringList *sDecoder;
    QLabel *lDecTimeLabel;
    QLabel *lDecTime;
    QLabel *lReplayGain;
    QComboBox *cReplayGain;
    QStringList *sReplayGain;
    QLabel *lRepTimeLabel;
    QLabel *lRepTime;
    KPushButton *pCalibrate;
    KPushButton *pCancel;

    FormatOptions();
    FormatOptions(QString);
    ~FormatOptions();
};

typedef QValueList<FormatOptions> FormatOptionsList;

/**
 * @short ConfigDialogueEnDecoder
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ConfigDialogueEnDecoder : public QWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigDialogueEnDecoder( QWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigDialogueEnDecoder();

private:
    Calibrate *calibrate;
    FormatOptionsList formatOptions;
    QLineEdit *lTestFile;
    QPushButton *pSelectFile;

    QGridLayout *grid;
    QScrollView *sv;
    QVBox *box;

    void generateServiceMenu();

public slots:
    void resetDefaults();
    void saveSettings();
    void recalc();
    void reload();

signals:
    void configChanged();
    void calibrationStart(QString,QString);
    void calibrationCancel();

private slots:
    void cfgChanged();
    void calibrationExited(int);
    void showFileDialogue();
    void encoderChanged();
    void updateCalibrateButtons();
    void startCalibration();
    void cancelCalibration();

};

#endif // _CONFIG_DIALOGUE_EN_DECODER_H_

