

#include "cue_editor.h"

#include <qlayout.h>
#include <qtextedit.h>
#include <qstring.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <kmessagebox.h>


CueEditor::CueEditor( QWidget *parent, const char *name, bool modal, WFlags f )
    : QDialog( parent, name, modal, f )
{
    setCaption( QString(i18n("Cue Editor")).append(" - soundKonverter") );
    resize(600,500);
    setIcon(KGlobal::iconLoader()->loadIcon("kwrite",KIcon::Small));

    QGridLayout *grid=new QGridLayout(this,4,1,10,5);

    tTextEdit=new QTextEdit(this,"tTextEdit");
    tTextEdit->setFocus();
    grid->addWidget(tTextEdit,0,0);

    QHBoxLayout *buttonBox = new QHBoxLayout();
    grid->addLayout(buttonBox,3,0);

    pHelp=new KPushButton(KGlobal::iconLoader()->loadIcon("help",KIcon::Small),"",this,"pHelp");
    buttonBox->addWidget(pHelp);
    connect(pHelp,SIGNAL(clicked()),this,SLOT(help()));

    pGenerate=new KPushButton(KGlobal::iconLoader()->loadIcon("filenew",KIcon::Small),i18n("Generate"),this,"pGenerate");
    buttonBox->addWidget(pGenerate);
    connect(pGenerate,SIGNAL(clicked()),this,SLOT(generate()));

    pConvert=new KPushButton(KGlobal::iconLoader()->loadIcon("run",KIcon::Small),i18n("Format"),this,"pConvert");
    buttonBox->addWidget(pConvert);
    connect(pConvert,SIGNAL(clicked()),this,SLOT(convert()));

    pShift=new KPushButton(KGlobal::iconLoader()->loadIcon("reload",KIcon::Small),i18n("Shift Title/Performer"),this,"pShift");
    buttonBox->addWidget(pShift);
    connect(pShift,SIGNAL(clicked()),this,SLOT(shift()));

    buttonBox->addStretch();

    pOk=new KPushButton(KGlobal::iconLoader()->loadIcon("exit",KIcon::Small),i18n("Close"),this,"pOk");
    buttonBox->addWidget(pOk);
    connect(pOk,SIGNAL(clicked()),this,SLOT(accept()));
}

CueEditor::~CueEditor()
{
}

void CueEditor::help()
{
    KMessageBox::information( this,
        i18n("<p>With this small tool you can process cue files as they are used for burning music mixes and for organizing them in media players like amaroK.<br><br>You can generate a new file by pasting text into the input area. It must be formated the following way:<br><br>Title - Artist [time]<br>Title - Artist [3:25]<br>Title - Artist [2:37]<br>...<br>A tip: Use kwrite and regular expressions to format it this way.</p>"),
        i18n("Cue Editor - Help") );
}

void CueEditor::generate()
{
    QString text=tTextEdit->text();
    QString newText;
    QStringList titleList, performerList;
    QValueList<int> timeList;
    //char time[16];
    QString time;
    int min, sec;
    int index;

    while( index!=-1 )
    {
        index=text.find(" - ");
        if( index==-1 )
            break;
        titleList.append(text.left(index));
        text.remove(0,index+3);
        index=text.find(" [");
        if( index==-1 )
            break;
        performerList.append(text.left(index));
        text.remove(0,index+2);
        index=text.find("]");
        if( index==-1 )
            break;
        time=text.left(index);
        sscanf(time,"%i:%i",&min,&sec);
        timeList.append(min*60+sec);
        text.remove(0,index+2);
    }

    newText+="PERFORMER \"\"\n";
    newText+="TITLE \"\"\n";
    newText+="FILE \"\" MP3\n";

    int TRACK=1;
    char sTRACK[16];
    int INDEX=0;
    char sINDEX[16];
    bool msecs=false;
    QStringList::Iterator performerIt=performerList.begin();
    QValueList<int>::Iterator timeIt=timeList.begin();
    for( QStringList::Iterator titleIt=titleList.begin(); titleIt!=titleList.end(); ++titleIt )
    {
        if(TRACK<10) sprintf(sTRACK,"0%i",TRACK);
        else sprintf(sTRACK,"%i",TRACK);
        newText+="  TRACK "+QString(sTRACK)+" AUDIO\n";
        newText+="    TITLE \""+(*titleIt)+"\"\n";
        newText+="    PERFORMER \""+(*performerIt)+"\"\n";
        if(INDEX/60<10&&INDEX%60<10) sprintf(sINDEX,"0%i:0%i",INDEX/60,INDEX%60);
        else if(INDEX/60<10&&INDEX%60>10) sprintf(sINDEX,"0%i:%i",INDEX/60,INDEX%60);
        else if(INDEX/60>10&&INDEX%60<10) sprintf(sINDEX,"%i:0%i",INDEX/60,INDEX%60);
        else sprintf(sINDEX,"%i:%i",INDEX/60,INDEX%60);
        if(msecs) {
            newText+="    INDEX 01 "+QString(sINDEX)+":50\n";
            INDEX++;
            msecs=false;
        }
        else {
            newText+="    INDEX 01 "+QString(sINDEX)+":00\n";
            msecs=true;
        }

        performerIt++;
        timeIt++;
        TRACK++;
        INDEX+=(*timeIt);
    }

    tTextEdit->setText(newText);
}

void CueEditor::convert()
{
    QString text=tTextEdit->text();
    QString newText;
    QString tmpText;
    QString first, rest;
    QStringList splinters;
    int index;

    while( index!=-1 )
    {
        index=text.find("\"");
        if( index==-1 )
            break;
        newText+=text.left(index+1);
        text.remove(0,index+1);
        index=text.find("\"");
        tmpText=text.left(index+1);
        text.remove(0,index+1);
        if( newText.right(6) == "FILE \"" )
        {
            newText+=tmpText;
            continue;
        }
        splinters=QStringList::split(' ',tmpText);
        for( QStringList::Iterator it=splinters.begin(); it!=splinters.end(); ++it )
        {
            for( uint i=0; i<(*it).length(); i++ )
            {
                if( (*it).left(i).lower() != (*it).left(i).upper() )
                {
                    index=i;
                    break;
                }
            }
            first=(*it).left(index);
            first=first.upper();
            rest=(*it).right((*it).length()-index);
            rest=rest.lower();
            for( uint i=0; i<rest.length(); i++ )
            {
                /*if( rest.mid(i,1).lower() == rest.mid(i,1).upper() )
                {
                    rest=rest.left(i+1)+rest.mid(i+1,1).upper()+rest.right(rest.length()-i-2);
                }*/
                if( rest.mid(i,1) == "-" )
                {
                    rest=rest.left(i+1)+rest.mid(i+1,1).upper()+rest.right(rest.length()-i-2);
                }
                if( rest.mid(i,1).lower() == "j" && rest.mid(i-1,1).lower() == "d" )
                {
                    rest=rest.left(i-1)+rest.mid(i-1,2).upper()+rest.right(rest.length()-i-1);
                }
                if( rest.mid(i,1).lower() == "j" && first.right(1).lower() == "d" )
                {
                    rest=rest.left(i)+rest.mid(i,1).upper()+rest.right(rest.length()-i-1);
                }
            }

            newText+=first+rest+" ";
        }
        newText.remove(newText.length()-1,1);
    }

    newText+=text;

    tTextEdit->setText(newText);
}

void CueEditor::shift() //move the title to "PERFORMER" and performer to "TITLE"
{
    QString text=tTextEdit->text();
    QString newText;
    QString line, title="", performer="";
    int index;

    while( index!=-1 )
    {
        index=text.find("\n");
        if( index==-1 )
            break;
        line=text.left(index+1);
        text.remove(0,index+1);
        if( line.find("    TITLE \"") != -1 ) {
            line.replace("    TITLE \"","    PERFORMER \"");
            if( performer != "" ) newText+=performer;
            performer=line;
        }
        else if( line.find("    PERFORMER \"") != -1 ) {
            line.replace("    PERFORMER \"","    TITLE \"");
            if( title != "" ) newText+=title;
            title=line;
        }
        else {
            if( title != "" ) newText+=title;
            if( performer != "" ) newText+=performer;
            title="";
            performer="";
            newText+=line;
        }

        if( title != "" && performer != "" ) {
            newText+=title;
            newText+=performer;
            title="";
            performer="";
        }
    }

    tTextEdit->setText(newText);
}
/*
void CueEditor::shift() //replace title by performer and reverse
{
    QString text=tTextEdit->text();
    QString newText;
    QString line, title, performer;
    int index;

    while( index!=-1 )
    {
        index=text.find("\n");
        if( index==-1 )
            break;
        line=text.left(index+1);
        text.remove(0,index+1);
        if( line.find("    TITLE \"") != -1 ) {
            line.replace("    TITLE \"","    PERFORMER \"");
            newText+=line;
        }
        else if( line.find("    PERFORMER \"") != -1 ) {
            line.replace("    PERFORMER \"","    TITLE \"");
            newText+=line;
        }
        else {
            newText+=line;
        }
    }

    tTextEdit->setText(newText);
}
*/
