

#ifndef _OPEN_FILES_H_
#define _OPEN_FILES_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdialog.h>

class Options;
class QStringList;

/**
 * @short Open files
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class OpenFiles : public QDialog
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    OpenFiles( QStringList list, QWidget *parent=0, const char *name=0, bool modal=true, WFlags f=0 );

    /**
     * Default Destructor
     */
    virtual ~OpenFiles();

public slots:
    void okClicked();
    void fileAdded(QStringList);
    void addTime(float);

signals:
    void addFiles(QStringList);
    void addFile(QStringList);
    void timeAdded(float);

private:
    QPushButton *pOk;
    QPushButton *pCancel;
    QStringList files;

    Options *options;
};

#endif // _OPEN_FILES_H_
