

#ifndef _REPLAYGAINSCANNER_H_
#define _REPLAYGAINSCANNER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qdialog.h>

#include <kfileitem.h>
#include <kprocess.h>


class KListView;
class QListViewItem;
class KPushButton;
class QStringList;
class QComboBox;
class QProgressBar;
class ComboButton;
class KDirLister;
class QCheckBox;

/**
 * @short ReplayGainScanner
 * @author Daniel Faust <daniel@kaligames.de>
 * @version 0.1
 */
class ReplayGainScanner : public QDialog
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ReplayGainScanner( QWidget *parent=0, const char *name=0, bool modal=true, WFlags f=0 );

    /**
     * Default Destructor
     */
    virtual ~ReplayGainScanner();

public slots:
    void addFiles(QStringList);

private slots:
    void addClicked(int);
    void showDirDialogue();
    void showFileDialogue();
    void allFilesListed(const KFileItemList&);
    void scanStatus(int);
    //void scanCompleted();
    void removeFiles();
    void applyReplayGain();
    void removeReplayGain();
    void processExited(KProcess*);
    void cancel();

private:
    enum Mode {
        Apply, Remove, Force
    };

    Mode mode;
    int iFile;
    bool bKilled;
    KProcess pProcess;
    QListViewItem* currentItem;

    ComboButton *cAdd;
    QProgressBar *pScanStatus;
    QCheckBox *cForce;
    //QComboBox *cFilter;
    KListView *lList;
    QProgressBar *pProgressBar;
    KPushButton *pCancel;
    //KPushButton *pScanUnknown;
    KPushButton *pTagVisible;
    KPushButton *pOk;
    KPushButton *pRemoveTag;
    KPushButton *pRemoveFiles;
    KDirLister *dirLister;

    void processNextFile();
    void process();

protected:
    void dropEvent(QDropEvent*);
    void dragEnterEvent(QDragEnterEvent*);

};

#endif // _REPLAYGAINSCANNER_H_
