#!/usr/bin/env ruby
#
# amaroK-Script for integrating soundKonverter into amaroK
#
# (c) 2005 Daniel Faust <daniel@kaligames.de>
# License: GNU General Public License V2
#
# Thanks to Mark Kretschmann <markey@web.de> for his mp3fixer - I don't like ruby ;)


require "uri"


MenuItemName1 = "soundKonverter \"Convert selected files\""
MenuItemName2 = "soundKonverter \"Add ReplayGain to selected files\""


def cleanup()
    `dcop amarok script removeCustomMenuItem #{MenuItemName1}`
    `dcop amarok script removeCustomMenuItem #{MenuItemName2}`
end


trap( "SIGTERM" ) { cleanup() }

`dcop amarok script addCustomMenuItem #{MenuItemName1}`
`dcop amarok script addCustomMenuItem #{MenuItemName2}`


loop do
    message = gets().chomp()
    command = /[A-Za-z]*/.match( message ).to_s()

    case command
        when "configure"
            msg  = 'The soundKonverter script does not have configuration options. Simply select a track in the playlist, then start soundKonverter from the context-menu (right mouse click).'

            `dcop amarok playlist popupMessage "#{msg}"`

        when "customMenuClicked"
            if message.include?( "Convert selected files" )
                args = message.split()
                # Remove the command args
                5.times() { args.delete_at( 0 ) }

                # Iterate over all selected files
                files = ''
                args.each() do |arg|
                    uri = URI.parse( arg )
                    file = URI.unescape( uri.path() )
                    files += ' "'+file+'"'
                end
                `dcop amarok playlist shortStatusMessage "starting soundKonverter"`
                `soundkonverter #{files}`
            end
            if message.include?( "Add ReplayGain to selected files" )
                args = message.split()
                # Remove the command args
                7.times() { args.delete_at( 0 ) }

                files = ''
                args.each() do |arg|
                    uri = URI.parse( arg )
                    file = URI.unescape( uri.path() )
                    files += ' "'+file+'"'
                end
                `dcop amarok playlist shortStatusMessage "starting soundKonverter"`
                `soundkonverter --replaygain #{files}`
            end
    end
end

