/*
 * QtColorMap.h
 *
 *  Created on: Dec 9, 2008
 *      Author: bettini
 */

#ifndef QTCOLORMAP_H_
#define QTCOLORMAP_H_

#include <map>
#include <string>

namespace srchiliteqt {

/**
 * Map for source-highlight colors into qt colors (actually, into the
 * format #RRGGBB)
 */
class QtColorMap : public std::map<std::string, std::string> {
public:
    QtColorMap();
    ~QtColorMap();

    /**
     * Returns the color associated to the passed string (if the
     * string is already of the shape "#RRGGBB", then it returns the
     * string "#RRGGBB" itself, without the quotes)
     * @param color
     * @return the color associated to the passed string
     */
    std::string getColor(const std::string &color);
};

}

#endif /* QTCOLORMAP_H_ */
