/*
 * P3
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * camera.c
 * Copyright (C) 2001-2002 Bertrand 'blam' LAMY
 **********************************************/

#include "p3_base.h"
#include "util.h"
#include "gladd.h"
#include "math3d.h"
#include "atmosphere.h"
#include "frustum.h"
#include "coordsys.h"
#include "renderer.h"
#include "camera.h"

// HACK
//#include <SDL/SDL.h>

extern int screen_w;
extern int screen_h;
extern P3_renderer* renderer;
extern int engine_option;


P3_class P3_class_camera = { 
  P3_ID_CAMERA,
  (batch_func)     0,
  (render_func)    0,
  (shadow_func)    0,
  (raypick_func)   0,
  (raypick_b_func) 0,
};


P3_camera* P3_camera_new (P3_camera* c) {
  if (c == NULL) {
    c = (P3_camera*) malloc (sizeof (P3_camera));
  }
  P3_coordsys_initialize ((P3_coordsys*) c);
  c->to_render = NULL;
  c->fov = 60.0;
  c->front = 0.1;
  c->back = 100.0;
  /* quake default value for front and back is 4.0 and 4096.0 */
  c->class = &P3_class_camera;
  c->frustum = (P3_frustum*) malloc (sizeof(P3_frustum));
  c->option = 0;
  c->render_matrix[ 3] = 0.0;
  c->render_matrix[ 7] = 0.0;
  c->render_matrix[11] = 0.0;
  c->render_matrix[15] = 1.0;
  return c;
}

void P3_camera_set (P3_camera* c) {
  if (c->option & P3_CAMERA_ORTHO) {
    P3_frustum_new (c->frustum, c->fov, c->front, c->back, c->size[2], c->size[3], P3_TRUE);
  } else {
    P3_frustum_new (c->frustum, c->fov, c->front, c->back, c->size[2], c->size[3], P3_FALSE);
  }
}

void P3_camera_subrender (P3_camera* c) {
  GLfloat* m;
  GLfloat* p;
  GLfloat* r;
  P3_coordsys* root;

//Uint32 t3;
//t3 = SDL_GetTicks();

//printf ("camera subrender\n");

  if (!(engine_option & P3_GL_INITED)) { return; }
  renderer->c_camera = c;

  /* compute the model matrix */
  m = P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) c);
  r = P3_coordsys_get_root_matrix ((P3_coordsys*) c);

/*
  P3_matrix_copy (m, P3_coordsys_get_inverted_root_matrix ((P3_coordsys*) c));
  m[12] = 0.0;
  m[13] = 0.0;
  m[14] = 0.0;
  r = P3_coordsys_get_root_matrix ((P3_coordsys*) c);
  // p : translation matrix with the position of the camera in the rootparent coordsys (= NULL ?)
  p[ 0] = 1.0;
  p[ 1] = 0.0;
  p[ 2] = 0.0;
  p[ 3] = 0.0;
  p[ 4] = 0.0;
  p[ 5] = 1.0;
  p[ 6] = 0.0;
  p[ 7] = 0.0;
  p[ 8] = 0.0;
  p[ 9] = 0.0;
  p[10] = 1.0;
  p[11] = 0.0;
  // I think the - are because the camera looks to -z
  p[12] = - r[12];
  p[13] = - r[13];
  p[14] = - r[14];
  p[15] = 1.0;
  p[16] = 1.0;
  p[17] = 1.0;
  p[18] = 1.0;
*/

  /* simplified computation (for the processor, not for comprehension ;) */
  p = c->render_matrix;
  p[ 0] = m[0];
  p[ 4] = m[4];
  p[ 8] = m[8];
  p[12] = - r[12] * m[0] - r[13] * m[4] - r[14] * m[8];
  p[ 1] = m[1];
  p[ 5] = m[5];
  p[ 9] = m[9];
  p[13] = - r[12] * m[1] - r[13] * m[5] - r[14] * m[9];
  p[ 2] = m[2];
  p[ 6] = m[6];
  p[10] = m[10];
  p[14] = - r[12] * m[2] - r[13] * m[6] - r[14] * m[10];
  p[16] = m[16];
  p[17] = m[17];
  p[18] = m[18];

  /* compute the projection matrix */
// TO DO for each render ?
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  if (c->option & P3_CAMERA_ORTHO) {
    GLfloat v1; GLfloat v2;
    v1 = c->fov / 20.0;
    v2 = v1 * c->size[3] / c->size[2];
    glOrtho ((GLdouble) -v1, (GLdouble) v1, (GLdouble) -v2, (GLdouble) v2, (GLdouble) -10000.0, (GLdouble) 10000.0);
  } else {
    glPerspective (c->fov, ((float) c->size[2]) / ((float) c->size[3]), c->front, c->back);
  }
  glMatrixMode (GL_MODELVIEW);

  /* draw */
  if (c->to_render == NULL) {
    root = P3_coordsys_get_root ((P3_coordsys*) c);
    if(root != NULL) {
      renderer->root_object = (P3_any_object*) root;
    } else { 
      /* nothing to render */
      return; 
    }
  } else {
    renderer->root_object = c->to_render;
  }

  P3_frustum_instance_into (renderer->r_frustum, c->frustum, (P3_coordsys*) c, NULL);
  memcpy (renderer->c_frustum, renderer->r_frustum, sizeof (P3_frustum));
  renderer->c_frustum_coordsys = NULL;

  P3_renderer_render ();


//t3 = SDL_GetTicks () - t3;
  
//printf ("time to render %i\n", t3);

}

void P3_camera_render (P3_camera* c) {

//printf ("camera start render\n");

  glPushAttrib (GL_VIEWPORT);
  glMatrixMode (GL_PROJECTION);
  glPushMatrix ();
  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
//  glViewport (c->size[0], c->size[1], c->size[2], - c->size[3]);
  glViewport (c->size[0], screen_h - c->size[1] - c->size[3], c->size[2], c->size[3]);
  //  glViewport (c->size[0], c->size[1], c->size[2], c->size[3]);
//  glViewport (c->size[0], screen_h - c->size[1] - c->size[3], c->size[2], - c->size[3]);
  glEnable (GL_LIGHTING);
  glEnable (GL_CULL_FACE);
  glDepthMask (GL_TRUE);
  glEnable (GL_DEPTH_TEST);

//  glClear (GL_DEPTH_BUFFER_BIT);

  P3_camera_subrender (c);
/*
  glViewport (0, screen_h, screen_w, - screen_h);
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();
  glOrtho (0, screen_w, screen_h, 0, -1.0, 1.0);
  glMatrixMode (GL_MODELVIEW);
  glLoadIdentity ();
*/
  glMatrixMode (GL_PROJECTION);
  glPopMatrix ();
  glMatrixMode (GL_MODELVIEW);
  glPopMatrix ();
  glPopAttrib ();
  glDepthMask (GL_FALSE);
  glDisable (GL_DEPTH_TEST);
  glDisable (GL_LIGHTING);
  glDisable (GL_FOG);
  glDisable (GL_CULL_FACE);
//  glBindTexture (GL_TEXTURE_2D, 0);
//  glDisable (GL_TEXTURE_2D);

//printf ("camera end render\n");

}

void P3_camera_get_data (P3_camera* camera, P3_chunk* chunk) {
  P3_chunk_save_int (chunk, camera->option);
  P3_chunk_save (chunk, camera->m, 19 * sizeof (GLfloat));
  P3_chunk_save_float (chunk, camera->front);
  P3_chunk_save_float (chunk, camera->back);
  P3_chunk_save_float (chunk, camera->fov);
}

void P3_camera_set_data (P3_camera* camera, P3_chunk* chunk) {
  camera->class = &P3_class_camera;
  camera->validity = P3_COORDSYS_INVALID;
  camera->option = P3_chunk_load_int (chunk);
  P3_chunk_load (chunk, camera->m, 19 * sizeof (GLfloat));
  camera->front = P3_chunk_load_float (chunk);
  camera->back  = P3_chunk_load_float (chunk);
  camera->fov   = P3_chunk_load_float (chunk);
}
