/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/**********************************************
 * Copyright (C) 2002-2003 Bertrand 'blam' LAMY
 **********************************************/

/*==========+
 | INSTANCE |
 +==========*/

void P3_instance_batch (P3_instance* c, P3_instance* csys) {
  PyObject* f;
  PyObject* p;
  long i;
  if (!(c->option & P3_OBJECT_HIDDEN)) {
    /* compute renderering matrix: enter in this coordsys */
    P3_multiply_matrix (c->render_matrix, renderer->c_camera->render_matrix, P3_coordsys_get_root_matrix ((P3_coordsys*) c));
    f = PyObject_CallMethod ((PyObject*) c, "batch", NULL, NULL);
#ifdef SAFE_MODE
    if (PyErr_Occurred () != NULL) { PyErr_Print (); }
#endif /* SAFE_MODE */
    if (f != NULL) {
      i = PyInt_AS_LONG (PySequence_Fast_GET_ITEM (f, 0));
      p = PySequence_Fast_GET_ITEM (f, 1);
      if (p == Py_None) {
        csys = (P3_instance*) c;
      } else {
        csys = (P3_instance*) p;
      }
      if (i == 0) {
        P3_renderer_add (c, csys);
      } else if (i == 1) {
        P3_renderer_add_alpha (c, csys);
      } else if (i == 2) {
        P3_renderer_add       (c, csys);
        P3_renderer_add_alpha (c, csys);
      } else if (i == 3) {
        P3_renderer_batch (renderer->specials, c, csys, -1);
      }
      Py_DECREF (f);
    }
  }
}

P3_class P3_class_instance = {
  P3_ID_INSTANCE,
  (batch_func)     P3_instance_batch,
  (render_func)    P3_shape_render,
  (shadow_func)    0,
  (raypick_func)   0,
  (raypick_b_func) 0,
};

/*---------+
 | Methods |
 +---------*/

static int PyP3Instance_Init (PyObject* self, PyObject* args, PyObject* kwds) {
  P3_coordsys_initialize ((P3_coordsys*) self);
  ((P3_any_object*) self)->class = &P3_class_instance;
	return 0;
}

static void PyP3Instance_Dealloc (P3_instance* w) {
  PyObject_GC_UnTrack ((PyObject*) w);
  Py_XDECREF (w->parent);
  w->ob_type->tp_free ((PyObject*) w);
}

static PyObject* PyP3Instance_BatchObject (P3_instance* c, PyObject* args) {
  long i;
  i = PyInt_AS_LONG (PySequence_Fast_GET_ITEM (args, 1));
  if (i == 0) {
    P3_renderer_add (PySequence_Fast_GET_ITEM (args, 0), c);
  } else if (i == 1) {
    P3_renderer_add_alpha (PySequence_Fast_GET_ITEM (args, 0), c);
  } else if (i == 2) {
    void* o;
    o = PySequence_Fast_GET_ITEM (args, 0);
    P3_renderer_add       (o, c);
    P3_renderer_add_alpha (o, c);
  } else if (i == 3) {
    P3_renderer_batch (renderer->specials, PySequence_Fast_GET_ITEM (args, 0), c, -1);
  }
  Py_INCREF (Py_None);
  return Py_None;
}

static PyObject* PyP3Instance_GetState (P3_instance* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_chunk_add (chunk, a->m, 19 * sizeof (GLfloat));
  P3_chunk_add_int (chunk, a->option);
  tuple = PyTuple_New (2);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
// HACK because previous object saved their parent
  Py_INCREF (Py_None);
  PyTuple_SET_ITEM (tuple, 1, Py_None);
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Instance_SetState (P3_instance* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  a->class = &P3_class_instance;
  a->validity = P3_COORDSYS_INVALID;
  a->parent = NULL;
  chunk->content = PyString_AS_STRING (PySequence_Fast_GET_ITEM (args, 0));
  P3_chunk_get (chunk, a->m, 19 * sizeof (GLfloat));
  a->option = P3_chunk_get_int (chunk);
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3Instance_Methods[] = {
//  PYP3_COORDSYS_FUNCS,
  { "_getstate",    (PyCFunction) PyP3Instance_GetState,    METH_NOARGS },
  { "_setstate",    (PyCFunction) PyP3Instance_SetState,    METH_O },
  { "batch_object", (PyCFunction) PyP3Instance_BatchObject, METH_VARARGS },
  { NULL, NULL }
};

/*---------+
 | Get Set |
 +---------*/

/*
static PyGetSetDef PyP3Instance_GetSets[] = {
//  PYP3_CHILD_GETSETS,
//  PYP3_COORDSYS_GETSETS,
//  PYP3_VISIBLE_GETSETS,
	{ NULL }
};
*/

/*------+
 | Type |
 +------*/

PyTypeObject PyP3Instance_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Coordsys",
  sizeof(P3_instance),
  0,
  (destructor) PyP3Instance_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Child_Traverse,/* tp_traverse */
  (inquiry) PyP3Child_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Instance_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) 0,/* tp_getset */
//  (PyGetSetDef*) &PyP3Instance_GetSets,/* tp_getset */
  &PyP3Element_Type,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Instance_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};


