/*
 * P3 python wrapper
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*****************************************
 * Copyright (C) 2003 Bertrand 'blam' LAMY
 *****************************************/

/*=======+
 | LIGHT |
 +=======*/

/*---------+
 | Methods |
 +---------*/

static int PyP3Light_Init (P3_light* a, PyObject* args, PyObject* kwds) {
  P3_light_new (a);
  return 0;
}

static void PyP3Light_Dealloc (P3_light* a) {
  if (a->id != -1) lights_gl[a->id] = NULL;
  free (a->shadow_color);
  PyObject_GC_UnTrack ((PyObject*) a);
  Py_XDECREF (a->parent);
  a->ob_type->tp_free ((PyObject*) a); 
}

static PyObject* PyP3Light_GetState (P3_light* a) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* tuple;
  P3_light_get_data (a, chunk);
  tuple = PyTuple_New (2);
  PyTuple_SET_ITEM (tuple, 0, PyString_FromStringAndSize ((char*) chunk->content, chunk->nb));
// HACK because previous object saved their parent
  Py_INCREF (Py_None);
  PyTuple_SET_ITEM (tuple, 1, Py_None);
  P3_chunk_dealloc (chunk);
  return tuple;
}

static PyObject* PyP3Light_SetState (P3_light* a, PyObject* args) {
  P3_chunk* chunk = P3_chunk_new ();
  PyObject* o;
  o = PySequence_Fast_GET_ITEM (args, 0);
  chunk->content = PyString_AS_STRING (o);
  P3_light_set_data (a, chunk);
  free (chunk);
  Py_INCREF (Py_None);
  return Py_None;
}

static PyMethodDef PyP3Light_Methods[] = {
//  PYP3_COORDSYS_FUNCS,
  { "_getstate", (PyCFunction) PyP3Light_GetState, METH_NOARGS },
  { "_setstate", (PyCFunction) PyP3Light_SetState, METH_O },
  { NULL, NULL } /* sentinel */
};

/*---------+
 | Get Set |
 +---------*/

static PyObject* PyP3Light_GetShadowCast (P3_light* a, void* context) {
  if (a->option & P3_LIGHT_NO_SHADOW) {
    return PyInt_FromLong (0);
  } else {
    return PyInt_FromLong (1);
  }
}

static int PyP3Light_SetShadowCast (P3_light* a, PyObject* value, void* context) {
  if (PyObject_IsTrue (value) == 1) {
    a->option &= ~P3_LIGHT_NO_SHADOW;
  } else {
    a->option |= P3_LIGHT_NO_SHADOW;
  }
  return 0;
}

static PyObject* PyP3Light_GetShadowColor (P3_light* a, void* context) {
  PyObject* tuple;
  tuple = PyTuple_New (4);
  if (a->shadow_color == NULL) {
    PyTuple_SET_ITEM (tuple, 0, PyFloat_FromDouble (0.0));
    PyTuple_SET_ITEM (tuple, 1, PyFloat_FromDouble (0.0));
    PyTuple_SET_ITEM (tuple, 2, PyFloat_FromDouble (0.0));
    PyTuple_SET_ITEM (tuple, 3, PyFloat_FromDouble (0.5));
  } else {
    PyTuple_SET_ITEM (tuple, 0, PyFloat_FromDouble (a->shadow_color[0]));
    PyTuple_SET_ITEM (tuple, 1, PyFloat_FromDouble (a->shadow_color[0]));
    PyTuple_SET_ITEM (tuple, 2, PyFloat_FromDouble (a->shadow_color[0]));
    PyTuple_SET_ITEM (tuple, 3, PyFloat_FromDouble (a->shadow_color[0]));
  }
  return tuple;
}

static int PyP3Light_SetShadowColor (P3_light* a, PyObject* value, void* context) {
  GLfloat def[4] = { 0.0, 0.0, 0.0, 0.5 };
  GLfloat color[4];
  if (value == Py_None) {
    free (a->shadow_color);
    a->shadow_color = NULL;
  } else {
    PY_TUPLE_FLOAT_TO_ARRAY_4 (color, value);
    if (P3_float_array_compare (color, def, 4) == P3_TRUE) {
      free (a->shadow_color);
      a->shadow_color = NULL;
    } else {
      a->shadow_color = (GLfloat*) malloc (4 * sizeof (GLfloat));
      memcpy (a->shadow_color, color, 4 * sizeof (GLfloat));
    }
  }
  return 0;
}

PY_GET_SET_ON_OPTION          (Light, P3_light*, TopLevel,   P3_LIGHT_TOP_LEVEL)
//PY_GET_SET_ON_OPTION          (Light, P3_light*, Static,     P3_LIGHT_STATIC)
//PY_GET_SET_ON_OPTION          (Light, P3_light*, PureStatic, P3_LIGHT_PURE_STATIC)
PY_GET_SET_ON_FLOAT_ADD       (Light, P3_light*, _w, w,   if (fabs (a->w) < P3_EPSILON) { a->option |= P3_LIGHT_DIRECTIONAL; } else { a->option &= ~P3_LIGHT_DIRECTIONAL; })
PY_GET_SET_ON_FLOAT           (Light, P3_light*, Radius, radius)
PY_GET_SET_ON_FLOAT_ADD       (Light, P3_light*, Angle, angle, if (a->id != -1) { lights_gl[a->id] = NULL; a->id = -1; })
PY_GET_SET_ON_FLOAT_ADD       (Light, P3_light*, Exponent, exponent, if (a->id != -1) { lights_gl[a->id] = NULL; a->id = -1; })
PY_GET_SET_ON_FLOAT_ADD       (Light, P3_light*, Linear, linear, if (a->id != -1) { lights_gl[a->id] = NULL; a->id = -1; })
PY_GET_SET_ON_FLOAT_ADD       (Light, P3_light*, Constant, constant, if (a->id != -1) { lights_gl[a->id] = NULL; a->id = -1; })
PY_GET_SET_ON_FLOAT_ADD       (Light, P3_light*, Quadratic, quadratic, if (a->id != -1) { lights_gl[a->id] = NULL; a->id = -1; })
PY_GET_SET_ON_FLOAT_ARRAY_ADD (Light, P3_light*, Ambient, colors, 4, if (a->id != -1) { lights_gl[a->id] = NULL; a->id = -1; })
PY_GET_SET_ON_FLOAT_ARRAY_ADD (Light, P3_light*, Diffuse, colors + 4, 4, if (a->id != -1) { lights_gl[a->id] = NULL; a->id = -1; })
PY_GET_SET_ON_FLOAT_ARRAY_ADD (Light, P3_light*, Specular, colors + 8, 4, if (a->id != -1) { lights_gl[a->id] = NULL; a->id = -1; })

static PyGetSetDef PyP3Light_GetSets[] = {
//  PYP3_COORDSYS_GETSETS,
//  PYP3_CHILD_GETSETS,
//  PYP3_VISIBLE_GETSETS,
  { "_w",           (getter) PyP3Light_Get_w,          (setter) PyP3Light_Set_w,          NULL },
  { "radius",       (getter) PyP3Light_GetRadius,      (setter) PyP3Light_SetRadius,      NULL },
  { "angle",        (getter) PyP3Light_GetAngle,       (setter) PyP3Light_SetAngle,       NULL },
  { "exponent",     (getter) PyP3Light_GetExponent,    (setter) PyP3Light_SetExponent,    NULL },
  { "linear",       (getter) PyP3Light_GetLinear,      (setter) PyP3Light_SetLinear,      NULL },
  { "constant",     (getter) PyP3Light_GetConstant,    (setter) PyP3Light_SetConstant,    NULL },
  { "quadratic",    (getter) PyP3Light_GetQuadratic,   (setter) PyP3Light_SetQuadratic,   NULL },
  { "ambient",      (getter) PyP3Light_GetAmbient,     (setter) PyP3Light_SetAmbient,     NULL },
  { "diffuse",      (getter) PyP3Light_GetDiffuse,     (setter) PyP3Light_SetDiffuse,     NULL },
  { "specular",     (getter) PyP3Light_GetSpecular,    (setter) PyP3Light_SetSpecular,    NULL },
  { "top_level",    (getter) PyP3Light_GetTopLevel,    (setter) PyP3Light_SetTopLevel,    NULL },
  { "shadow_cast",  (getter) PyP3Light_GetShadowCast,  (setter) PyP3Light_SetShadowCast,  NULL },
  { "shadow_color", (getter) PyP3Light_GetShadowColor, (setter) PyP3Light_SetShadowColor, NULL },
//  { "static",      (getter) PyP3Light_GetStatic,     (setter) PyP3Light_SetStatic,     NULL },
//  { "pure_static", (getter) PyP3Light_GetPureStatic, (setter) PyP3Light_SetPureStatic, NULL },
  { NULL }
};

/*------+
 | Type |
 +------*/

PyTypeObject PyP3Light_Type = {
  PyObject_HEAD_INIT(NULL)
  0,
  "_soya._Light",
  sizeof(P3_light),
  0,
  (destructor) PyP3Light_Dealloc,/* tp_dealloc */
  0,/* tp_print */
  0,/* tp_getattr */
  0,/* tp_setattr */
  0,/* tp_compare */
  0,/* tp_repr */
  0,/* tp_as_number */
  0,/* tp_as_sequence */
  0,/* tp_as_mapping */
  0,/* tp_hash */
  0,/* tp_call */
  0,/* tp_str */
  PYP3_GENERIC_GETATTR,/* tp_getattro */
  0,/* tp_setattro */
  0,/* tp_as_buffer */
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE | Py_TPFLAGS_HAVE_GC,/* tp_flags */
  0,/* tp_doc */
  (traverseproc) PyP3Child_Traverse,/* tp_traverse */
  (inquiry) PyP3Child_Clear,/* tp_clear */
  0,/* tp_richcompare */
  0,/* tp_weaklistoffset */
  0,/* tp_iter */
  0,/* tp_iternext */
  (PyMethodDef*) &PyP3Light_Methods,/* tp_methods */
  0,/* tp_members */
  (PyGetSetDef*) &PyP3Light_GetSets,/* tp_getset */
  &PyP3Element_Type,/* tp_base */
  0,/* tp_dict */
  0,/* tp_descr_get */
  0,/* tp_descr_set */
  0,/* tp_dictoffset */
  (initproc) PyP3Light_Init,/* tp_init */
  PYP3_GENERIC_ALLOC,/* tp_alloc */
  (newfunc) PyP3Object_New,/* tp_new */
  PYP3_GENERIC_GC_FREE,/* tp_free */
};

